/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.audit;

import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.audit.OAuthAuditEntry;
import com.ibm.oauth.core.api.error.OAuthException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OAuthAuditEntryImpl
implements OAuthAuditEntry {
    static final SimpleDateFormat DATE_FORMAT;
    static final String SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String TZ_UTC = "UTC";
    private AttributeList _attributes;
    private Date _timestamp;
    private OAuthException _error;

    public OAuthAuditEntryImpl(AttributeList attributes) {
        this(attributes, null);
    }

    public OAuthAuditEntryImpl(AttributeList attributes, OAuthException error) {
        this._attributes = attributes;
        this._timestamp = new Date();
        this._error = error;
    }

    @Override
    public AttributeList getAttributes() {
        return this._attributes;
    }

    @Override
    public Date getTimeStamp() {
        return this._timestamp;
    }

    @Override
    public OAuthException getError() {
        return this._error;
    }

    @Override
    public Element toXML(Document document) {
        Element retVal = document.createElement("entry");
        retVal.setAttribute("timestamp", DATE_FORMAT.format(this._timestamp));
        if (this._error != null) {
            Element errorEle = document.createElement("error");
            errorEle.setAttribute("type", this._error.getError());
            Element msgEle = document.createElement("message");
            msgEle.appendChild(document.createCDATASection(this._error.getMessage()));
            errorEle.appendChild(msgEle);
            retVal.appendChild(errorEle);
        }
        Element eleAttributes = document.createElement("attributes");
        List<Attribute> attrs = this._attributes.getAllAttributes();
        for (Attribute attr : attrs) {
            Element eleAttr = document.createElement("attribute");
            eleAttr.setAttribute("name", attr.getName());
            eleAttr.setAttribute("type", attr.getType());
            for (String value : attr.getValues()) {
                Element eleValue = document.createElement("value");
                eleValue.appendChild(document.createTextNode(value));
                eleAttr.appendChild(eleValue);
            }
            eleAttributes.appendChild(eleAttr);
        }
        retVal.appendChild(eleAttributes);
        return retVal;
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_FORMAT);
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getTimeZone(TZ_UTC));
        DATE_FORMAT = sdf;
    }
}

