/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.token;

import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth20TokenHelper {
    static final String CLASS = OAuth20TokenHelper.class.getName();
    static Logger _log = Logger.getLogger(CLASS);
    static final String SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String TZ_UTC = "UTC";
    static boolean finestLoggable = _log.isLoggable(Level.FINEST);

    public static String expiresInSeconds(OAuth20Token token) {
        long now;
        long expiresAt = token.getCreatedAt() + (long)token.getLifetimeSeconds() * 1000L;
        long expiresIn = expiresAt - (now = System.currentTimeMillis());
        if (expiresIn < 0L) {
            expiresIn = 0L;
        }
        return "" + expiresIn / 1000L;
    }

    public static String expiresUTC(OAuth20Token token) {
        long expires = token.getCreatedAt() + (long)token.getLifetimeSeconds() * 1000L;
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_FORMAT);
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getTimeZone(TZ_UTC));
        return sdf.format(new Date(expires));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTokenExpired(OAuth20Token token) {
        String methodName = "isTokenExpired";
        _log.entering(CLASS, methodName);
        boolean result = false;
        try {
            long expiresAt = token.getCreatedAt() + (long)token.getLifetimeSeconds() * 1000L;
            long now = System.currentTimeMillis();
            long expiresIn = expiresAt - now;
            result = expiresIn <= 0L;
        }
        finally {
            _log.exiting(CLASS, methodName, "" + result);
        }
        return result;
    }

    public static Map<String, String[]> getExternalClaims(AttributeList attrList) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Attribute[] attributes = attrList.getAttributesByType("com.ibm.wsspi.security.oidc.external.claims");
        if (attributes != null && attributes.length > 0) {
            for (Attribute attribute : attributes) {
                result.put(attribute.getName(), attribute.getValuesArray());
            }
        }
        return result.size() > 0 ? result : null;
    }

    public static Map<String, String[]> getExternalClaims(Map<String, String[]> tokenMap, AttributeList attrList) {
        Map<String, String[]> result = tokenMap;
        Attribute[] attributes = attrList.getAttributesByType("com.ibm.wsspi.security.oidc.external.claims");
        if (attributes != null && attributes.length > 0) {
            for (Attribute attribute : attributes) {
                result.put(attribute.getName(), attribute.getValuesArray());
            }
        }
        return result;
    }

    public static void addExternalClaims(Map<String, String[]> tokenMap, OAuth20Token token) {
        if (finestLoggable) {
            _log.logp(Level.FINEST, CLASS, "addExternalClaims(TokenMap)", "addExternalClaims token:" + token);
        }
        if (token != null) {
            Map<String, String[]> map = token.getExtensionProperties();
            if (finestLoggable) {
                _log.logp(Level.FINEST, CLASS, "addExternalClaims()", "addExternalClaims map:" + map);
            }
            if (map != null) {
                Set<Map.Entry<String, String[]>> entries = map.entrySet();
                for (Map.Entry<String, String[]> entry : entries) {
                    tokenMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public static boolean addExternalClaims(AttributeList attrList, OAuth20Token token) {
        Map<String, String[]> map;
        if (finestLoggable) {
            _log.logp(Level.FINEST, CLASS, "addExternalClaims(attributeList)", "addExternalNames token:" + token);
        }
        boolean bResult = false;
        if (token != null && (map = token.getExtensionProperties()) != null) {
            Set<Map.Entry<String, String[]>> entries = map.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                attrList.setAttribute(entry.getKey(), "com.ibm.wsspi.security.oidc.external.claims", entry.getValue());
                bResult = true;
            }
        }
        return bResult;
    }

    public static Map<String, String[]> getExternalClaims(Map<String, String[]> tokenMap) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Set<Map.Entry<String, String[]>> entries = tokenMap.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            String key = entry.getKey();
            if (!key.startsWith("com.ibm.wsspi.security.oidc.external.claims:")) continue;
            result.put(key, entry.getValue());
        }
        return result.size() > 0 ? result : null;
    }
}

