/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.appqueue;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.AppQueueHandler;
import com.ibm.ws.sip.container.appqueue.QueueLoadListener;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;

public class DispatcherWorkingThread
extends AppQueueHandler
implements Runnable {
    private static final LogMgr c_logger = Log.get(DispatcherWorkingThread.class);
    private Thread _thread;
    private static final String THREAD_NAME = "WASX_Msg_Thread_";
    private static int threadIndex = 1;

    public DispatcherWorkingThread(int waitingQueueSize, int id, QueueLoadListener lstr) {
        super(waitingQueueSize, id, lstr);
        String threadName = THREAD_NAME + String.valueOf(threadIndex++);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "DispatcherWorkingThread", "initiating thread for pool = " + threadName);
        }
        this.init(threadName);
    }

    protected void init(String threadName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "DispatcherWorkingThread#init", "creating/starting java thread to run this class = " + threadName);
        }
        this._thread = new Thread((Runnable)this, threadName);
        this._thread.start();
    }

    @Override
    public void run() {
        while (true) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "run", this + " looping to see if queue has filled with new elements.");
            }
            try {
                this.extractAmsgAndExecute();
                continue;
            }
            catch (Throwable e2) {
                if (!c_logger.isErrorEnabled()) continue;
                c_logger.error("error.exception", null, null, e2);
                continue;
            }
            break;
        }
    }

    @Override
    protected void extractAmsgAndExecute() {
        try {
            ThreadLocalStorage.setQueueId(this.getId());
            Queueable msg = this.getRunnableObj();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "executeTask", "msg = " + msg);
            }
            this.reportToFailoverServiceStart();
            msg.run();
        }
        catch (Throwable e2) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception", null, null, e2);
            }
        }
        finally {
            ThreadLocalStorage.setQueueId(null);
            this.invalidateWhenReadyTU();
            this.finishToExecuteRunnable();
        }
    }

    @Override
    public String getInfo() {
        StringBuffer buff = new StringBuffer();
        buff.append("Name = <");
        buff.append(this._thread.getName());
        buff.append(super.getInfo());
        return buff.toString();
    }
}

