/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.ServerBuilder;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.servlet.ServletAdapter;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@Trivial
public final class ServletServerBuilder
extends AbstractServerImplBuilder<ServletServerBuilder> {
    List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    int maxInboundMessageSize = 0x400000;
    private ScheduledExecutorService scheduler;
    private boolean usingCustomScheduler;
    private InternalServerImpl internalServer;
    private ServerImplBuilder builder = new ServerImplBuilder(new ServerImplBuilder.ClientTransportServersBuilder(){
        static final long serialVersionUID = 5630178347950420955L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public List<? extends InternalServer> buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
            return ServletServerBuilder.this.buildTransportServers(streamTracerFactories);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$1", 1.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    });

    protected ServerBuilder<?> delegate() {
        return this.builder;
    }

    public ServletAdapter buildServletAdapter() {
        return new ServletAdapter(this.buildAndStart(), this.streamTracerFactories, this.maxInboundMessageSize);
    }

    private ServerTransportListener buildAndStart() {
        try {
            this.builder.build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.usingCustomScheduler) {
            this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
        }
        ServerTransportImpl serverTransport = new ServerTransportImpl(this.scheduler, this.usingCustomScheduler);
        return this.internalServer.serverListener.transportCreated((ServerTransport)serverTransport);
    }

    private List<? extends InternalServer> buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories");
        this.streamTracerFactories = streamTracerFactories;
        this.internalServer = new InternalServerImpl();
        return ImmutableList.of((Object)this.internalServer);
    }

    public ServletServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS should be configured by the servlet container");
    }

    public ServletServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (Object)"bytes must be >= 0");
        this.maxInboundMessageSize = bytes;
        return this;
    }

    public ServletServerBuilder scheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.usingCustomScheduler = true;
        return this;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    @VisibleForTesting
    static final class ServerTransportImpl
    implements ServerTransport {
        private final InternalLogId logId = InternalLogId.allocate(ServerTransportImpl.class, null);
        private final ScheduledExecutorService scheduler;
        private final boolean usingCustomScheduler;
        static final long serialVersionUID = 3244771752946039228L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServerTransportImpl(ScheduledExecutorService scheduler, boolean usingCustomScheduler) {
            this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
            this.usingCustomScheduler = usingCustomScheduler;
        }

        public void shutdown() {
            if (!this.usingCustomScheduler) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.scheduler);
            }
        }

        public void shutdownNow(Status reason) {
            this.shutdown();
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduler;
        }

        public ListenableFuture<InternalChannelz.SocketStats> getStats() {
            return null;
        }

        public InternalLogId getLogId() {
            return this.logId;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$ServerTransportImpl", ServerTransportImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class InternalServerImpl
    implements InternalServer {
        ServerListener serverListener;
        static final long serialVersionUID = -3661169052515463262L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        InternalServerImpl() {
        }

        public void start(ServerListener listener) {
            this.serverListener = listener;
        }

        public void shutdown() {
            if (this.serverListener != null) {
                this.serverListener.serverShutdown();
            }
        }

        public SocketAddress getListenSocketAddress() {
            return new SocketAddress(){
                static final long serialVersionUID = -6757261809185057330L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public String toString() {
                    return "ServletServer";
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$InternalServerImpl$1", 1.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
                }
            };
        }

        public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$InternalServerImpl", InternalServerImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }
}

