/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArrayCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MappingHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import java.util.Optional;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ArgumentCreator {
    private final ReferenceCreator referenceCreator;

    public ArgumentCreator(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    public Optional<Argument> createArgument(OperationType operationType, MethodInfo methodInfo, short position) {
        if (position >= methodInfo.parameters().size()) {
            throw new SchemaBuilderException("Can not create argument for parameter [" + position + "] on method [" + methodInfo.declaringClass().name() + "#" + methodInfo.name() + "]: method has only " + methodInfo.parameters().size() + " parameters");
        }
        Annotations annotationsForThisArgument = Annotations.getAnnotationsForArgument(methodInfo, position);
        if (!IgnoreHelper.shouldIgnore(annotationsForThisArgument)) {
            Type argumentType = (Type)methodInfo.parameters().get(position);
            String defaultName = methodInfo.parameterName((int)position);
            String name = annotationsForThisArgument.getOneOfTheseAnnotationsValue(Annotations.NAME).orElse(defaultName);
            Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForThisArgument, argumentType);
            Reference reference = ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operationType) ? this.referenceCreator.createReferenceForSourceArgument(argumentType, annotationsForThisArgument) : this.referenceCreator.createReferenceForOperationArgument(argumentType, annotationsForThisArgument);
            Argument argument = new Argument(defaultName, methodInfo.name(), MethodHelper.getPropertyName(Direction.IN, methodInfo.name()), name, maybeDescription.orElse(null), reference);
            if (NonNullHelper.markAsNonNull(argumentType, annotationsForThisArgument)) {
                argument.setNotNull(true);
            }
            if (ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operationType)) {
                argument.setSourceArgument(true);
            }
            argument.setArray(ArrayCreator.createArray(argumentType).orElse(null));
            argument.setTransformInfo(FormatHelper.getFormat(argumentType, annotationsForThisArgument).orElse(null));
            argument.setMappingInfo(MappingHelper.getMapping(argument, annotationsForThisArgument).orElse(null));
            argument.setDefaultValue(DefaultValueHelper.getDefaultValue(annotationsForThisArgument).orElse(null));
            return Optional.of(argument);
        }
        return Optional.empty();
    }

    private static boolean isSourceAnnotationOnSourceOperation(Annotations annotationsForArgument, OperationType operationType) {
        return operationType.equals((Object)OperationType.Source) && annotationsForArgument.containsOneOfTheseAnnotations(Annotations.SOURCE);
    }
}

