/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.converters.AtomicIntegerConverter;
import com.ibm.ws.microprofile.config.converters.AtomicLongConverter;
import com.ibm.ws.microprofile.config.converters.AutomaticConverter;
import com.ibm.ws.microprofile.config.converters.BitSetConverter;
import com.ibm.ws.microprofile.config.converters.BooleanConverter;
import com.ibm.ws.microprofile.config.converters.CurrencyConverter;
import com.ibm.ws.microprofile.config.converters.DateTimeConverter;
import com.ibm.ws.microprofile.config.converters.IdentityConverter;
import com.ibm.ws.microprofile.config.converters.InstantConverter;
import com.ibm.ws.microprofile.config.converters.OptionalConverter;
import com.ibm.ws.microprofile.config.converters.PriorityConverterMap;
import com.ibm.ws.microprofile.config.converters.URIConverter;
import com.ibm.ws.microprofile.config.converters.URLConverter;
import com.ibm.ws.microprofile.config.converters.UserConverter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.ConfigException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DefaultConverters {
    private static final TraceComponent tc = Tr.register(DefaultConverters.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private static final PriorityConverterMap defaultConverters = new PriorityConverterMap();
    static final long serialVersionUID = -3384044763116449735L;

    @Trivial
    public static PriorityConverterMap getDefaultConverters() {
        return defaultConverters;
    }

    /*
     * WARNING - void declaration
     */
    public static PriorityConverterMap getDiscoveredConverters(ClassLoader classLoader) {
        PriorityConverterMap discoveredConverters = new PriorityConverterMap();
        try {
            ServiceLoader<Converter> sl = ServiceLoader.load(Converter.class, classLoader);
            for (Converter converter : sl) {
                discoveredConverters.addConverter(UserConverter.newInstance(converter));
            }
        }
        catch (ServiceConfigurationError sl) {
            void e;
            FFDCFilter.processException((Throwable)sl, (String)"com.ibm.ws.microprofile.config.converters.DefaultConverters", (String)"116", null, (Object[])new Object[]{classLoader});
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.discover.converters.CWMCG0012E", (Object[])new Object[]{e}), (Throwable)e);
        }
        return discoveredConverters;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        defaultConverters.addConverter(new IdentityConverter());
        defaultConverters.addConverter(new OptionalConverter());
        defaultConverters.addConverter(new BooleanConverter());
        defaultConverters.addConverter(new AutomaticConverter(Integer.class));
        defaultConverters.addConverter(new AutomaticConverter(Long.class));
        defaultConverters.addConverter(new AutomaticConverter(Short.class));
        defaultConverters.addConverter(new AutomaticConverter(Byte.class));
        defaultConverters.addConverter(new AutomaticConverter(Double.class));
        defaultConverters.addConverter(new AutomaticConverter(Float.class));
        defaultConverters.addConverter(new AutomaticConverter(BigInteger.class));
        defaultConverters.addConverter(new AutomaticConverter(BigDecimal.class));
        defaultConverters.addConverter(new AtomicIntegerConverter());
        defaultConverters.addConverter(new AtomicLongConverter());
        defaultConverters.addConverter(new DateTimeConverter(Duration.class));
        defaultConverters.addConverter(new DateTimeConverter(Period.class));
        defaultConverters.addConverter(new DateTimeConverter(LocalDateTime.class));
        defaultConverters.addConverter(new DateTimeConverter(LocalDate.class));
        defaultConverters.addConverter(new DateTimeConverter(LocalTime.class));
        defaultConverters.addConverter(new DateTimeConverter(OffsetDateTime.class));
        defaultConverters.addConverter(new DateTimeConverter(OffsetTime.class));
        defaultConverters.addConverter(new DateTimeConverter(ZonedDateTime.class));
        defaultConverters.addConverter(new InstantConverter());
        defaultConverters.addConverter(new CurrencyConverter());
        defaultConverters.addConverter(new BitSetConverter());
        defaultConverters.addConverter(new URIConverter());
        defaultConverters.addConverter(new URLConverter());
        defaultConverters.addConverter(new AutomaticConverter(ChronoUnit.class));
        defaultConverters.setUnmodifiable();
    }
}

