/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.AbstractConnectionFactoryService;
import com.ibm.ws.jca.cm.AppDefinedResource;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.internal.JDBCDriverService;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.resource.ResourceFactory;
import java.io.Serializable;
import java.security.AccessController;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;

public class DataSourceService
extends AbstractConnectionFactoryService
implements AppDefinedResource,
ResourceFactory,
ApplicationRecycleComponent {
    private static final String BASE_PREFIX = "properties";
    private static final int BASE_PREFIX_LENGTH = "properties".length();
    private static final int TOTAL_PREFIX_LENGTH = BASE_PREFIX_LENGTH + ".0.".length();
    private static final TraceComponent tc = Tr.register(DataSourceService.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final String CONNECTION_MANAGER = "connectionManager";
    public static final String DATASOURCE = "dataSource";
    public static final String FACTORY_PID = "com.ibm.ws.jdbc.dataSource";
    private static final String JDBC_DRIVER = "driver";
    static final String SUPPORT_EXTENSIONS = "supportExtensions";
    static final String TARGET_CONNECTION_MANAGER = "connectionManager.target";
    static final String TARGET_CONTAINER_AUTH_DATA = "containerAuthData.target";
    static final String TARGET_JDBC_DRIVER = "driver.target";
    static final String TARGET_RECOVERY_AUTH_DATA = "recoveryAuthData.target";
    static final String UNIQUE_JNDI_NAME = "jndiName.unique";
    static final String DECLARING_APPLICATION = "declaringApplication";
    private static final HashSet<String> WPROPS_TO_SKIP = new HashSet<String>(Arrays.asList("application", "module", "component", "connectionManagerRef", "containerAuthDataRef", "id", "jdbcDriverRef", "recoveryAuthDataRef", "supportExtensions"));
    private ComponentContext componentContext;
    private ConnectorService connectorSvc;
    private final AtomicReference<DSConfig> dsConfigRef = new AtomicReference();
    private String vendorImplClassName;
    private boolean destroyWasDeferred;
    private static ConcurrentLinkedQueue<String> embDerbyRefCount = new ConcurrentLinkedQueue();
    private String id;
    private boolean isDerbyEmbedded;
    private boolean isUCP;
    private boolean sentUCPConnMgrPropsIgnoredInfoMessage;
    private boolean sentUCPDataSourcePropsIgnoredInfoMessage;
    private JDBCDriverService jdbcDriverSvc;
    private JDBCRuntimeVersion jdbcRuntime;
    private WSManagedConnectionFactoryImpl mcf;
    private ConcurrentHashMap<String, WSManagedConnectionFactoryImpl> mcfPerClassLoader;
    private Map<String, Object> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"activate", (Object[])new Object[]{PropertyService.hidePasswords(properties)});
        }
        String jndiName = (String)properties.get("jndiName");
        this.id = (String)properties.get("config.displayId");
        this.isServerDefined = "file".equals(properties.get("config.source"));
        if (this.isServerDefined) {
            if (jndiName != null && jndiName.startsWith("java:")) {
                throw new IllegalArgumentException(ConnectorService.getMessage((String)"UNSUPPORTED_VALUE_J2CA8011", (Object[])new Object[]{jndiName, "jndiName", DATASOURCE}));
            }
            String id = (String)properties.get("id");
            if (id != null && id.startsWith("application[")) {
                throw new IllegalArgumentException(ConnectorService.getMessage((String)"UNSUPPORTED_VALUE_J2CA8011", (Object[])new Object[]{id, "id", DATASOURCE}));
            }
        }
        this.lock.writeLock().lock();
        try {
            this.componentContext = context;
            this.properties = properties;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
        this.destroyConnectionFactories(true);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"deactivate", (Object)(this.id + ' ' + context.getProperties().get("jndiName")));
        }
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.appsToRecycle);
        this.appsToRecycle.removeAll(members);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnectionFactories(boolean destroyImmediately) {
        boolean trace;
        block12: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destroyConnectionFactories", (Object[])new Object[]{destroyImmediately, this.destroyWasDeferred});
            }
            if (!this.appsToRecycle.isEmpty()) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"recycle applications", (Object[])new Object[]{this.appsToRecycle});
                }
                ApplicationRecycleCoordinator appRecycleCoord = null;
                appRecycleCoord = (ApplicationRecycleCoordinator)priv.locateService(this.componentContext, "appRecycleService");
                HashSet members = new HashSet(this.appsToRecycle);
                this.appsToRecycle.removeAll(members);
                appRecycleCoord.recycleApplications(members);
            }
            this.lock.writeLock().lock();
            try {
                if (!this.isInitialized.get() && (!destroyImmediately || !this.destroyWasDeferred)) break block12;
                try {
                    this.isInitialized.set(false);
                    if (destroyImmediately) {
                        this.conMgrSvc.destroyConnectionFactories();
                        if (this.isDerbyEmbedded) {
                            this.shutdownDerbyEmbedded();
                        }
                        this.conMgrSvc.deleteObserver((Observer)((Object)this));
                        this.jdbcDriverSvc.deleteObserver((Observer)((Object)this));
                    }
                    this.destroyWasDeferred = !destroyImmediately;
                }
                catch (RuntimeException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destroyConnectionFactories");
        }
    }

    public String getApplication() {
        return (String)this.properties.get("application");
    }

    public String getComponent() {
        return (String)this.properties.get("component");
    }

    public final String getConfigElementName() {
        return DATASOURCE;
    }

    public final ConnectorService getConnectorService() {
        return this.connectorSvc;
    }

    public Version getFeatureVersion() {
        return this.jdbcRuntime.getVersion();
    }

    public String getID() {
        return this.id;
    }

    public final String getJNDIName() {
        return this.dsConfigRef.get().jndiName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ManagedConnectionFactory getManagedConnectionFactory(String identifier) throws Exception {
        void var9_17;
        Object vendorImpl;
        if (!this.jdbcDriverSvc.loadFromApp()) return this.mcf;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (identifier == null) {
            ClassLoader tccl = priv.getContextClassLoader();
            identifier = this.connectorSvc.getClassLoaderIdentifierService().getClassLoaderIdentifier(tccl);
        }
        WSManagedConnectionFactoryImpl mcf1 = this.mcfPerClassLoader.get(identifier);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getManagedConnectionFactory", (Object[])new Object[]{identifier, mcf1});
        }
        if (mcf1 != null) return mcf1;
        PropertyService vProps = new PropertyService();
        NavigableMap<String, Object> wProps = this.parseConfiguration(this.properties, vProps);
        vProps = (PropertyService)vProps.clone();
        String jndiName = (String)wProps.remove("jndiName");
        String type = (String)wProps.remove("type");
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"create new data source", (Object[])new Object[]{this.id, jndiName, type});
        }
        if (type == null) {
            boolean atLeastJDBC43 = this.jdbcRuntime.getVersion().compareTo(JDBCRuntimeVersion.VERSION_4_3) >= 0;
            Object object = vendorImpl = atLeastJDBC43 || this.id != null && this.id.contains("dataSource[DefaultDataSource]") ? this.jdbcDriverSvc.createAnyPreferXADataSource(vProps, this.id) : this.jdbcDriverSvc.createAnyPreferLegacyOrder(vProps, this.id);
            Class<XADataSource> clazz = vendorImpl instanceof XADataSource ? XADataSource.class : (vendorImpl instanceof ConnectionPoolDataSource ? ConnectionPoolDataSource.class : (vendorImpl instanceof DataSource ? DataSource.class : Driver.class));
        } else if (ConnectionPoolDataSource.class.getName().equals(type)) {
            Class<ConnectionPoolDataSource> clazz = ConnectionPoolDataSource.class;
            vendorImpl = this.jdbcDriverSvc.createConnectionPoolDataSource(vProps, this.id);
        } else if (XADataSource.class.getName().equals(type)) {
            Class<XADataSource> clazz = XADataSource.class;
            vendorImpl = this.jdbcDriverSvc.createXADataSource(vProps, this.id);
        } else if (DataSource.class.getName().equals(type)) {
            Class<DataSource> clazz = DataSource.class;
            vendorImpl = this.jdbcDriverSvc.createDataSource(vProps, this.id);
        } else {
            if (!Driver.class.getName().equals(type)) throw new SQLNonTransientException(ConnectorService.getMessage((String)"MISSING_RESOURCE_J2CA8030", (Object[])new Object[]{"type", type, DATASOURCE, jndiName == null ? this.id : jndiName}));
            Class<Driver> clazz = Driver.class;
            String url = vProps.getProperty("URL", vProps.getProperty("url"));
            if (url == null || "".equals(url)) throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4014.URL.for.Driver.missing", jndiName == null ? this.id : jndiName));
            vendorImpl = this.jdbcDriverSvc.getDriver(url, vProps, this.id);
        }
        mcf1 = new WSManagedConnectionFactoryImpl(this.dsConfigRef, (Class<?>)var9_17, vendorImpl, this.jdbcRuntime);
        WSManagedConnectionFactoryImpl mcf0 = this.mcfPerClassLoader.putIfAbsent(identifier, mcf1);
        mcf1 = mcf0 == null ? mcf1 : mcf0;
        if (!trace) return mcf1;
        if (!tc.isDebugEnabled()) return mcf1;
        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)(mcf0 == null ? "created" : "found"), (Object[])new Object[]{mcf1});
        return mcf1;
    }

    public String getModule() {
        return (String)this.properties.get("module");
    }

    public boolean getReauthenticationSupport() {
        return false;
    }

    public int[] getThreadIdentitySecurityAndRRSSupport(String identifier) {
        WSManagedConnectionFactoryImpl mcf1;
        if (this.jdbcDriverSvc.loadFromApp()) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (identifier == null) {
                ClassLoader tccl = priv.getContextClassLoader();
                identifier = this.connectorSvc.getClassLoaderIdentifierService().getClassLoaderIdentifier(tccl);
            }
            mcf1 = this.mcfPerClassLoader.get(identifier);
        } else {
            mcf1 = this.mcf;
        }
        DatabaseHelper dbHelper = mcf1.getHelper();
        return new int[]{dbHelper.getThreadIdentitySupport(), dbHelper.getThreadSecurity() ? 1 : 0, dbHelper.getRRSTransactional() ? 1 : 0};
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return this.dsConfigRef.get().transactional ? TransactionSupport.TransactionSupportLevel.XATransaction : TransactionSupport.TransactionSupportLevel.NoTransaction;
    }

    public boolean getValidatingManagedConnectionFactorySupport() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        try {
            void var8_18;
            String dbName;
            int wIsolationLevel;
            Object vendorImpl;
            PropertyService vProps = new PropertyService();
            NavigableMap<String, Object> wProps = this.parseConfiguration(this.properties, vProps);
            vProps = (PropertyService)vProps.clone();
            String jndiName = (String)wProps.remove("jndiName");
            String type = (String)wProps.remove("type");
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)DATASOURCE, (Object[])new Object[]{this.id, jndiName, type});
            }
            this.conMgrSvc = (ConnectionManagerService)priv.locateService(this.componentContext, CONNECTION_MANAGER);
            boolean createdDefaultConnectionManager = false;
            if (this.conMgrSvc == null) {
                SQLNonTransientException failure;
                if (wProps.containsKey("connectionManagerRef") && (failure = (SQLNonTransientException)this.connectorSvc.ignoreWarnOrFail(tc, null, SQLNonTransientException.class, "MISSING_RESOURCE_J2CA8030", new Object[]{"connectionManagerRef", "", DATASOURCE, jndiName == null ? this.id : jndiName})) != null) {
                    throw failure;
                }
                this.conMgrSvc = ConnectionManagerService.createDefaultService((String)this.id);
                createdDefaultConnectionManager = true;
            }
            this.conMgrSvc.addObserver((Observer)((Object)this));
            this.jdbcDriverSvc = (JDBCDriverService)priv.locateService(this.componentContext, JDBC_DRIVER);
            if (this.jdbcDriverSvc == null) {
                Tr.error((TraceComponent)tc, (String)"DSRA4003.driver.null", (Object[])new Object[]{jndiName == null ? this.id : jndiName});
                throw new SQLNonTransientException(ConnectorService.getMessage((String)"MISSING_RESOURCE_J2CA8030", (Object[])new Object[]{"jdbcDriverRef", "", DATASOURCE, jndiName == null ? this.id : jndiName}));
            }
            this.jdbcDriverSvc.addObserver((Observer)((Object)this));
            if (type == null) {
                boolean atLeastJDBC43 = this.jdbcRuntime.getVersion().compareTo(JDBCRuntimeVersion.VERSION_4_3) >= 0;
                Object object = vendorImpl = atLeastJDBC43 || this.id != null && this.id.contains("dataSource[DefaultDataSource]") ? this.jdbcDriverSvc.createAnyPreferXADataSource(vProps, this.id) : this.jdbcDriverSvc.createAnyPreferLegacyOrder(vProps, this.id);
                Class<XADataSource> clazz = vendorImpl instanceof XADataSource ? XADataSource.class : (vendorImpl instanceof ConnectionPoolDataSource ? ConnectionPoolDataSource.class : (vendorImpl instanceof DataSource ? DataSource.class : Driver.class));
            } else if (ConnectionPoolDataSource.class.getName().equals(type)) {
                Class<ConnectionPoolDataSource> clazz = ConnectionPoolDataSource.class;
                vendorImpl = this.jdbcDriverSvc.createConnectionPoolDataSource(vProps, this.id);
            } else if (XADataSource.class.getName().equals(type)) {
                Class<XADataSource> clazz = XADataSource.class;
                vendorImpl = this.jdbcDriverSvc.createXADataSource(vProps, this.id);
            } else if (DataSource.class.getName().equals(type)) {
                Class<DataSource> clazz = DataSource.class;
                vendorImpl = this.jdbcDriverSvc.createDataSource(vProps, this.id);
            } else {
                if (!Driver.class.getName().equals(type)) throw new SQLNonTransientException(ConnectorService.getMessage((String)"MISSING_RESOURCE_J2CA8030", (Object[])new Object[]{"type", type, DATASOURCE, jndiName == null ? this.id : jndiName}));
                Class<Driver> clazz = Driver.class;
                String url = vProps.getProperty("URL", vProps.getProperty("url"));
                if (url == null || "".equals(url)) throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4014.URL.for.Driver.missing", jndiName == null ? this.id : jndiName));
                vendorImpl = this.jdbcDriverSvc.getDriver(url, vProps, this.id);
            }
            this.vendorImplClassName = vendorImpl.getClass().getName();
            DataSourceService.parseIsolationLevel(wProps, this.vendorImplClassName);
            Object objIsolationLevel = wProps.get(DataSourceDef.isolationLevel.name());
            int n = wIsolationLevel = objIsolationLevel == null ? -1 : (Integer)objIsolationLevel;
            if (wIsolationLevel == 0) {
                boolean wTransactional;
                Object objTransactional = wProps.get(DataSourceDef.transactional.name());
                boolean bl = wTransactional = objTransactional == null ? true : (Boolean)objTransactional;
                if (wTransactional) {
                    throw new SQLException(AdapterUtil.getNLSMessage("DSRA4009.tran.none.transactional.unsupported", this.id));
                }
            }
            this.isDerbyEmbedded = this.vendorImplClassName.startsWith("org.apache.derby.jdbc.Embedded");
            if (this.isDerbyEmbedded && (dbName = (String)vProps.get(DataSourceDef.databaseName.name())) != null) {
                dbName = PathUtils.normalize((String)dbName);
                embDerbyRefCount.add(dbName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"ref count for database shutdown", (Object[])new Object[]{dbName, embDerbyRefCount});
                }
            }
            this.isUCP = this.vendorImplClassName.startsWith("oracle.ucp");
            if (this.isUCP) {
                if (!createdDefaultConnectionManager && !this.sentUCPConnMgrPropsIgnoredInfoMessage) {
                    Set<String> connMgrPropsAllowed = Collections.singleton("enableSharingForDirectLookups");
                    Tr.info((TraceComponent)tc, (String)"DSRA4013.ignored.connection.manager.config.used", (Object[])new Object[]{connMgrPropsAllowed});
                    this.sentUCPConnMgrPropsIgnoredInfoMessage = true;
                }
                this.updateConfigForUCP(wProps);
            }
            this.dsConfigRef.set(new DSConfig(this.id, jndiName, wProps, vProps, this.connectorSvc));
            WSManagedConnectionFactoryImpl mcfImpl = new WSManagedConnectionFactoryImpl(this.dsConfigRef, (Class<?>)var8_18, vendorImpl, this.jdbcRuntime);
            if (this.jdbcDriverSvc.loadFromApp()) {
                this.mcf = null;
                this.mcfPerClassLoader = new ConcurrentHashMap();
                ClassLoader tccl = priv.getContextClassLoader();
                String identifier = this.connectorSvc.getClassLoaderIdentifierService().getClassLoaderIdentifier(tccl);
                this.mcfPerClassLoader.put(identifier, mcfImpl);
            } else {
                this.mcf = mcfImpl;
                this.mcfPerClassLoader = null;
            }
            this.isInitialized.set(true);
            return;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"587", (Object)((Object)this));
            if (this.conMgrSvc != null) {
                this.conMgrSvc.deleteObserver((Observer)((Object)this));
            }
            if (this.jdbcDriverSvc == null) throw x;
            this.jdbcDriverSvc.deleteObserver((Observer)((Object)this));
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"591", (Object)((Object)this));
            if (this.conMgrSvc != null) {
                this.conMgrSvc.deleteObserver((Observer)((Object)this));
            }
            if (this.jdbcDriverSvc == null) throw x;
            this.jdbcDriverSvc.deleteObserver((Observer)((Object)this));
            throw x;
        }
    }

    private static final boolean match(Object o1, Object o2) {
        return o1 instanceof String[] && o2 instanceof String[] ? Arrays.deepEquals((String[])o1, (String[])o2) : AdapterUtil.match(o1, o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modified(ComponentContext context, Map<String, Object> newProperties) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"modified", (Object[])new Object[]{AdapterUtil.toString(newProperties)});
        }
        String jndiName = (String)newProperties.get("jndiName");
        this.lock.writeLock().lock();
        try {
            this.componentContext = context;
            if (!AdapterUtil.match(jndiName, this.properties.get("jndiName"))) {
                this.deactivate(context);
                this.activate(context, newProperties);
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"modified", (Object)"jndiName changed");
                }
                return;
            }
            if (this.isInitialized.get()) {
                PropertyService vProps = new PropertyService();
                NavigableMap<String, Object> wProps = this.parseConfiguration(newProperties, vProps);
                wProps.remove("jndiName");
                DSConfig config = this.dsConfigRef.get();
                if (!(DataSourceService.match(newProperties.get("connectionManagerRef"), this.properties.get("connectionManagerRef")) && DataSourceService.match(newProperties.get("jdbcDriverRef"), this.properties.get("jdbcDriverRef")) && DataSourceService.match(newProperties.get("onConnect"), this.properties.get("onConnect")) && DataSourceService.match(newProperties.get(DataSourceDef.transactional.name()), this.properties.get(DataSourceDef.transactional.name())))) {
                    this.destroyConnectionFactories(true);
                } else if (!(AdapterUtil.match(vProps, config.vendorProps) && AdapterUtil.match(wProps.get("supplementalJDBCTrace"), this.properties.get("supplementalJDBCTrace")) && AdapterUtil.match(wProps.remove("type"), this.properties.get("type")))) {
                    this.isUCP = this.isUCP || "com.ibm.ws.jdbc.dataSource.properties.oracle.ucp".equals(newProperties.get("properties.0.config.referenceType"));
                    this.destroyConnectionFactories(this.isDerbyEmbedded || this.isUCP);
                } else {
                    DataSourceService.parseIsolationLevel(wProps, this.vendorImplClassName);
                    if (this.isUCP) {
                        this.updateConfigForUCP(wProps);
                    }
                    this.dsConfigRef.set(new DSConfig(config, wProps));
                }
            }
            this.properties = newProperties;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"modified");
        }
    }

    private NavigableMap<String, Object> parseConfiguration(Map<String, Object> configProps, PropertyService vProps) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        TreeMap<String, Object> wProps = new TreeMap<String, Object>();
        String vPropsPID = null;
        boolean recommendAuthAlias = false;
        for (Map.Entry<String, Object> entry : configProps.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.length() > TOTAL_PREFIX_LENGTH && key.charAt(BASE_PREFIX_LENGTH) == '.' && key.startsWith(BASE_PREFIX)) {
                if ((key = key.substring(TOTAL_PREFIX_LENGTH)).equals("config.referenceType")) {
                    if (vPropsPID == null) {
                        vPropsPID = (String)value;
                        vProps.setFactoryPID(vPropsPID);
                        continue;
                    }
                    throw new SQLFeatureNotSupportedException(ConnectorService.getMessage((String)"CARDINALITY_ERROR_J2CA8040", (Object[])new Object[]{DATASOURCE, this.id, BASE_PREFIX}));
                }
                if (value instanceof Long && PropertyService.DURATION_MIXED_PROPS.contains(key)) {
                    value = ((Long)value).toString();
                }
                if (PropertyService.isPassword(key)) {
                    String password;
                    if (value instanceof SerializableProtectedString) {
                        password = new String(((SerializableProtectedString)value).getChars());
                        value = PasswordUtil.getCryptoAlgorithm((String)password) == null ? password : PasswordUtil.decode((String)password);
                    } else if (value instanceof String) {
                        password = (String)value;
                        Object object = value = PasswordUtil.getCryptoAlgorithm((String)password) == null ? password : PasswordUtil.decode((String)password);
                    }
                    if (DataSourceDef.password.name().equals(key)) {
                        recommendAuthAlias = true;
                    }
                } else if (trace && tc.isDebugEnabled()) {
                    if (key.toLowerCase().equals("url")) {
                        if (value instanceof String) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Found vendor property: " + key + '=' + PropertyService.filterURL((String)value)), (Object[])new Object[0]);
                        }
                    } else {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Found vendor property: " + key + '=' + value), (Object[])new Object[0]);
                    }
                }
                vProps.put(key, value);
                continue;
            }
            if (key.length() > "identifyException".length() + 3 && key.startsWith("identifyException.")) {
                Map errorMappings = (Map)wProps.computeIfAbsent("identifyException", k -> new HashMap(3));
                String unProcessedKey = key.substring("identifyException".length() + 1);
                int id = Integer.valueOf(unProcessedKey.substring(0, unProcessedKey.indexOf(46)));
                DSConfig.IdentifyException errorMapping = errorMappings.computeIfAbsent(id, k -> new DSConfig.IdentifyException());
                String propertyName = unProcessedKey.substring(unProcessedKey.indexOf(46) + 1);
                errorMapping.setProperty(propertyName, value);
                continue;
            }
            if (key.indexOf(46) != -1 || WPROPS_TO_SKIP.contains(key)) continue;
            wProps.put(key, value);
        }
        if (recommendAuthAlias && !"com.ibm.ws.jdbc.dataSource.properties.oracle.ucp".equals(vPropsPID)) {
            ConnectorService.logMessage((Level)Level.INFO, (String)"RECOMMEND_AUTH_ALIAS_J2CA8050", (Object[])new Object[]{this.id});
        }
        if (vPropsPID == null) {
            vProps.setFactoryPID("com.ibm.ws.jdbc.dataSource.properties");
        }
        return wProps;
    }

    private static final void parseIsolationLevel(NavigableMap<String, Object> wProps, String vendorImplClassName) {
        Object isolationLevel = wProps.get(DataSourceDef.isolationLevel.name());
        if (isolationLevel instanceof String) {
            isolationLevel = "TRANSACTION_READ_COMMITTED".equals(isolationLevel) ? Integer.valueOf(2) : ("TRANSACTION_REPEATABLE_READ".equals(isolationLevel) ? Integer.valueOf(4) : ("TRANSACTION_SERIALIZABLE".equals(isolationLevel) ? Integer.valueOf(8) : ("TRANSACTION_READ_UNCOMMITTED".equals(isolationLevel) ? Integer.valueOf(1) : ("TRANSACTION_NONE".equals(isolationLevel) ? Integer.valueOf(0) : ("TRANSACTION_SNAPSHOT".equals(isolationLevel) ? Integer.valueOf(vendorImplClassName.startsWith("com.microsoft.") ? 4096 : 16) : isolationLevel)))));
            wProps.put(DataSourceDef.isolationLevel.name(), isolationLevel);
        }
    }

    protected void setConnectionManager(ServiceReference<ConnectionManagerService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setConnectionManager", (Object[])new Object[]{ref});
        }
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void setDriver(ServiceReference<JDBCDriverService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setDriver", (Object[])new Object[]{ref});
        }
    }

    protected void setJdbcRuntimeVersion(JDBCRuntimeVersion ref) {
        this.jdbcRuntime = ref;
    }

    private void shutdownDerbyEmbedded() {
        block14: {
            DSConfig cfg = this.dsConfigRef.get();
            Properties vProps = cfg.vendorProps;
            String dbName = (String)((Hashtable)vProps).get(DataSourceDef.databaseName.name());
            if (dbName == null) {
                return;
            }
            dbName = PathUtils.normalize((String)dbName);
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object[])new Object[]{dbName, embDerbyRefCount});
            }
            if (embDerbyRefCount.remove(dbName) && !embDerbyRefCount.contains(dbName)) {
                try {
                    ClassLoader jdbcDriverLoader = this.jdbcDriverSvc.getClassLoaderForLibraryRef();
                    if (jdbcDriverLoader != null) {
                        String pwd;
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"using classloader", (Object[])new Object[]{jdbcDriverLoader});
                        }
                        Class<?> EmbDS = AdapterUtil.forNameWithPriv("org.apache.derby.jdbc.EmbeddedDataSource40", true, jdbcDriverLoader);
                        DataSource ds = (DataSource)EmbDS.newInstance();
                        EmbDS.getMethod("setDatabaseName", String.class).invoke((Object)ds, dbName);
                        EmbDS.getMethod("setShutdownDatabase", String.class).invoke((Object)ds, "shutdown");
                        String user = (String)((Hashtable)vProps).get(DataSourceDef.user.name());
                        if (user != null) {
                            EmbDS.getMethod("setUser", String.class).invoke((Object)ds, user);
                        }
                        if ((pwd = (String)((Hashtable)vProps).get(DataSourceDef.password.name())) != null) {
                            EmbDS.getMethod("setPassword", String.class).invoke((Object)ds, pwd);
                        }
                        ds.getConnection().close();
                    }
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"shutdownDerbyEmbedded");
                    }
                    break block14;
                }
                catch (SQLException x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)(x.getSQLState() + ' ' + x.getErrorCode() + ':' + x.getMessage()));
                    }
                    break block14;
                }
                catch (Throwable x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)x);
                    }
                    break block14;
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)false);
            }
        }
    }

    protected void unsetConnectionManager(ServiceReference<ConnectionManagerService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"unsetConnectionManager", (Object[])new Object[]{ref});
        }
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    protected void unsetDriver(ServiceReference<JDBCDriverService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"unsetDriver", (Object[])new Object[]{ref});
        }
    }

    protected void unsetJdbcRuntimeVersion(JDBCRuntimeVersion ref) {
        this.jdbcRuntime = null;
    }

    public void update(Observable observable, Object data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"service updated", (Object[])new Object[]{observable});
        }
        this.destroyConnectionFactories(true);
    }

    protected void checkAccess() throws ResourceException {
    }

    public void setMQQueueManager(Serializable xaresinfo) throws Exception {
    }

    private void updateConfigForUCP(NavigableMap<String, Object> wProps) {
        Object statementCacheSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Updating config for UCP", (Object[])new Object[0]);
        }
        if (wProps.remove("validationTimeout") != null && !this.sentUCPDataSourcePropsIgnoredInfoMessage) {
            LinkedHashSet<String> dsPropsIgnored = new LinkedHashSet<String>();
            dsPropsIgnored.add("statementCacheSize");
            dsPropsIgnored.add("validationTimeout");
            Tr.info((TraceComponent)tc, (String)"DSRA4012.ignored.datasource.config.used", (Object[])new Object[]{dsPropsIgnored});
            this.sentUCPDataSourcePropsIgnoredInfoMessage = true;
        }
        if ((statementCacheSize = wProps.get("statementCacheSize")) != null) {
            long numericVal;
            block10: {
                numericVal = -1L;
                if (statementCacheSize instanceof Number) {
                    numericVal = ((Number)statementCacheSize).longValue();
                } else {
                    try {
                        numericVal = Integer.parseInt((String)statementCacheSize);
                    }
                    catch (Exception x) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Caught the following exception parsing statement cache size: " + x), (Object[])new Object[0]);
                    }
                }
            }
            if (numericVal != 0L) {
                wProps.put("statementCacheSize", 0);
                if (numericVal != 10L && !this.sentUCPDataSourcePropsIgnoredInfoMessage) {
                    LinkedHashSet<String> dsPropsIgnored = new LinkedHashSet<String>();
                    dsPropsIgnored.add("statementCacheSize");
                    dsPropsIgnored.add("validationTimeout");
                    Tr.info((TraceComponent)tc, (String)"DSRA4012.ignored.datasource.config.used", (Object[])new Object[]{dsPropsIgnored});
                    this.sentUCPDataSourcePropsIgnoredInfoMessage = true;
                }
            }
        } else {
            wProps.put("statementCacheSize", 0);
        }
    }

    public boolean isLibertyConnectionPoolingDisabled() {
        return this.isUCP;
    }
}

