/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Set;

public abstract class PtoPMessageItemStream
extends BaseMessageItemStream
implements MessageEventListener,
ControllableResource,
LocalizationPoint {
    private static final TraceComponent tc = SibTr.register(PtoPMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private OutputHandler outputHandler = null;
    protected SIBUuid8 messagingEngineUuid;
    private Boolean toBeDeleted = Boolean.FALSE;
    private boolean deleteRequiredAtReconstitute = false;
    private boolean unableToOrder = false;
    private PersistentTranId currentTranId = null;
    private volatile boolean _blocked = false;

    public PtoPMessageItemStream() {
    }

    public PtoPMessageItemStream(BaseDestinationHandler destinationHandler, SIBUuid8 messagingEngineUuid, boolean isRemote) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PtoPMessageItemStream", (Object)new Object[]{destinationHandler, messagingEngineUuid, isRemote});
        }
        this.messagingEngineUuid = messagingEngineUuid;
        this.setStorageStrategy(destinationHandler.getStorageStrategy());
        this.initializeNonPersistent(destinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PtoPMessageItemStream", (Object)this);
        }
    }

    public void reconstitute(BaseDestinationHandler destinationHandler) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)destinationHandler);
        }
        this.initializeNonPersistent(destinationHandler);
        this.setDestMsgInterval();
        try {
            Statistics statistics = this.getStatistics();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute - counts total items, available items", (Object)new Object[]{new Long(statistics.getTotalItemCount()), new Long(statistics.getAvailableItemCount())});
            }
        }
        catch (MessageStoreException e) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
        }
    }

    @Override
    public OutputHandler getOutputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getOutputHandler", (Object)this.outputHandler);
        }
        return this.outputHandler;
    }

    @Override
    public void setOutputHandler(OutputHandler outputHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setOutputHandler", (Object)outputHandler);
        }
        this.outputHandler = outputHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOutputHandler");
        }
    }

    public void setDeleteRequiredAtReconstitute(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDeleteRequiredAtReconstitute", (Object)new Boolean(value));
            SibTr.exit((TraceComponent)tc, (String)"setDeleteRequiredAtReconstitute");
        }
        this.deleteRequiredAtReconstitute = value;
    }

    public boolean getDeleteRequiredAtReconstitute() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDeleteRequiredAtReconstitute");
            SibTr.exit((TraceComponent)tc, (String)"getDeleteRequiredAtReconstitute", (Object)new Boolean(this.deleteRequiredAtReconstitute));
        }
        return this.deleteRequiredAtReconstitute;
    }

    @Override
    public SIBUuid8 getLocalizingMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalizingMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getLocalizingMEUuid", (Object)this.messagingEngineUuid);
        }
        return this.messagingEngineUuid;
    }

    @Override
    public BaseDestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    public void unmarkAsToBeDeleted(Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unmarkAsToBeDeleted", (Object)transaction);
        }
        this.toBeDeleted = Boolean.FALSE;
        try {
            this.requestUpdate(transaction);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.unmarkAsToBeDeleted", (String)"1:336:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unmarkAsToBeDeleted", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unmarkAsToBeDeleted");
        }
    }

    public boolean isToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isToBeDeleted", (Object)this.toBeDeleted);
        }
        return this.toBeDeleted;
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            this.addPersistentDestinationData(hm);
            oos.writeObject(hm);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getPersistentData", (String)"1:396:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:403:1.93.1.14", e, this.getDestinationHandler().getName()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)e);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:415:1.93.1.14", e, this.getDestinationHandler().getName()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void addPersistentDestinationData(HashMap<String, Object> hm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentDestinationData", hm);
        }
        hm.put("messagingEngineUuid", this.getLocalizingMEUuid().toByteArray());
        hm.put("toBeDeleted", this.toBeDeleted);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentDestinationData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this.restorePersistentDestinationData(hm);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.restore", (String)"1:464:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:471:1.93.1.14", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)e);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:482:1.93.1.14", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void restorePersistentDestinationData(HashMap hm) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentDestinationData", (Object)new Object[]{hm});
        }
        this.messagingEngineUuid = new SIBUuid8((byte[])hm.get("messagingEngineUuid"));
        this.toBeDeleted = (Boolean)hm.get("toBeDeleted");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentDestinationData");
        }
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents");
        }
        msg.registerMessageEventListener(3, this);
        msg.registerMessageEventListener(5, this);
        msg.registerMessageEventListener(2, this);
        msg.registerMessageEventListener(4, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public void deregisterForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterForEvents");
        }
        msg.deregisterMessageEventListener(3, this);
        msg.deregisterMessageEventListener(5, this);
        msg.deregisterMessageEventListener(2, this);
        msg.deregisterMessageEventListener(4, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterForEvents");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        switch (event) {
            case 3: 
            case 5: 
            case 6: {
                if (this.currentTranId != null) {
                    this.currentTranId = null;
                    break;
                }
            }
            case 2: 
            case 4: {
                this.testIfToBeDeleted(msg);
                break;
            }
            default: {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:588:1.93.1.14"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.messageEventOccurred", (String)"1:594:1.93.1.14", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:601:1.93.1.14"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    public void testIfToBeDeleted(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"testIfToBeDeleted", (Object)msg);
        }
        if (this.isInStore() && (this.isToBeDeleted() || this.getDestinationHandler().isToBeDeleted())) {
            this.deregisterForEvents(msg);
            try {
                Statistics statistics = this.getStatistics();
                long countOfAvailableItems = statistics.getAvailableItemCount();
                long countOfUnavailableItems = statistics.getUnavailableItemCount();
                if (countOfAvailableItems > 0L || countOfUnavailableItems > 0L) {
                    this.getDestinationHandler().getDestinationManager().markDestinationAsCleanUpPending(this.getDestinationHandler());
                }
            }
            catch (MessageStoreException messageStoreException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"testIfToBeDeleted");
        }
    }

    @Override
    public abstract boolean reallocateMsgs();

    @Override
    public void removeItemStream(Transaction transaction, long lockID) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, new Long(lockID)});
        }
        this.deregisterControlAdapterMBean();
        this.remove(transaction, lockID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public void replaceUuid(SIBUuid8 newUuid, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"replaceUuid", (Object)new Object[]{newUuid, transaction});
        }
        if (this.messagingEngineUuid.toString().equals("0000000000000001")) {
            this.messagingEngineUuid = newUuid;
            try {
                this.requestUpdate(transaction);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.replaceUuid", (String)"1:720:1.93.1.14", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"replaceUuid", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replaceUuid");
        }
    }

    public void markAsToBeDeleted(Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAsToBeDeleted", (Object)transaction);
        }
        this.toBeDeleted = Boolean.TRUE;
        try {
            this.requestUpdate(transaction);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.markAsToBeDeleted", (String)"1:759:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
    }

    @Override
    public ConsumerManager getConsumerManager() {
        return null;
    }

    @Override
    public void dereferenceConsumerManager() {
    }

    @Override
    public boolean isSendAllowed() {
        return false;
    }

    @Override
    public ConsumerManager createConsumerManager() {
        return null;
    }

    @Override
    public long getOldestMessageAge() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOldestMessageAge");
        }
        MessageItem oldestItem = null;
        try {
            oldestItem = (MessageItem)this.findOldestItem();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getOldestMessageAge", (String)"1:825:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        long age = 0L;
        if (null != oldestItem) {
            age = oldestItem.calculateWaitTimeUpdate(System.currentTimeMillis());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getOldestMessageAge", (Object)new Long(age));
        }
        return age;
    }

    @Override
    public long getAvailableMessageCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAvailableMessageCount");
        }
        long returnValue = -1L;
        try {
            returnValue = this.getStatistics().getAvailableItemCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getAvailableMessageCount", (String)"1:863:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAvailableMessageCount", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    @Override
    public long getUnAvailableMessageCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUnAvailableMessageCount");
        }
        long returnValue = -1L;
        try {
            returnValue = this.getStatistics().getUnavailableItemCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getUnAvailableMessageCount", (String)"1:894:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUnAvailableMessageCount", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    @Override
    public void setCurrentTransaction(SIMPMessage msg, boolean isInDoubtOnRemoteConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCurrentTransaction", (Object)new Object[]{msg, new Boolean(isInDoubtOnRemoteConsumer)});
        }
        if (this.currentTranId != null && !msg.getTransactionId().equals((Object)this.currentTranId)) {
            this.unableToOrder = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to order. Transaction: " + msg.getTransactionId() + " Current:" + this.currentTranId));
            }
        } else {
            this.currentTranId = msg.getTransactionId();
        }
        if (isInDoubtOnRemoteConsumer) {
            msg.registerMessageEventListener(6, this);
            msg.registerMessageEventListener(3, this);
        } else {
            msg.registerMessageEventListener(3, this);
            msg.registerMessageEventListener(5, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCurrentTransaction");
        }
    }

    public PersistentTranId getOrderedActiveTran() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOrderedActiveTran");
            SibTr.exit((TraceComponent)tc, (String)"getOrderedActiveTran", (Object)this.currentTranId);
        }
        return this.currentTranId;
    }

    public boolean isUnableToOrder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isUnableToOrder");
            SibTr.exit((TraceComponent)tc, (String)"isUnableToOrder", (Object)new Boolean(this.unableToOrder));
        }
        return this.unableToOrder;
    }

    public void getActiveTransactions(Set<PersistentTranId> transactionList) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getActiveTransactions", transactionList);
        }
        AbstractItem item = null;
        NonLockingCursor cursor = this.newNonLockingItemCursor(new Filter(){

            public boolean filterMatches(AbstractItem abstractItem) throws MessageStoreException {
                return abstractItem.isRemoving();
            }
        });
        cursor.allowUnavailableItems();
        while (null != (item = cursor.next())) {
            transactionList.add(item.getTransactionId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getActiveTransactions");
        }
    }

    @Override
    public long getTotalMsgCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMsgCount");
        }
        long count = -1L;
        try {
            count = this.getStatistics().getTotalItemCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getTotalMsgCount", (String)"1:1021:1.93.1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalMsgCount", (Object)count);
        }
        return count;
    }

    public void setBlocked(boolean blocked) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBlocked", (Object)new Object[]{blocked, this._blocked});
        }
        this._blocked = blocked;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBlocked");
        }
    }

    public boolean isBlocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBlocked");
            SibTr.exit((TraceComponent)tc, (String)"isBlocked", (Object)this._blocked);
        }
        return this._blocked;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("MEUuid", (Object)this.messagingEngineUuid);
        writer.newLine();
        writer.taggedValue("toBeDeleted", (Object)this.toBeDeleted);
    }
}

