/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.impl.ConnectionResults;
import com.ibm.ws.rsadapter.impl.DB2Helper;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class DB2JCCHelper
extends DB2Helper {
    static TraceComponent tc = Tr.register(DB2JCCHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String DB2_TRACE_LEVEL = "traceLevel";
    private static final String DB2_TRACE_FILE = "traceFile";
    private static final String DB2_TRACE_FILE_DIR = "traceDirectory";
    private static final String DB2_TRACE_FILE_APPEND = "traceFileAppend";
    private Method getDB2PooledConnection;
    private Method getDB2XAConnection;
    private Method getSecurityMechanism;
    private Method setSecurityMechanism;
    private Method getConnectionWithGSS;
    private final AtomicReference<Method> getDB2Correlator = new AtomicReference();
    private final AtomicReference<Method> isInDB2UnitOfWork = new AtomicReference();
    private final AtomicReference<Method> reuseDB2Connection = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientUser = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientWorkstation = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientApplicationInformation = new AtomicReference();
    private final AtomicReference<Method> setDB2ClientAccountingInformation = new AtomicReference();
    private final AtomicReference<Method> setJCCLogWriter = new AtomicReference();
    private final AtomicReference<Method> setJCCLogWriter2 = new AtomicReference();
    private static final Class<?>[] TYPES_PrintWriter = new Class[]{PrintWriter.class};
    private static final Class<?>[] TYPES_PrintWriter_int = new Class[]{PrintWriter.class, Integer.TYPE};
    private static final Class<?>[] TYPES_GSSCredential_Properties = new Class[]{GSSCredential.class, Properties.class};
    private static final Class<?>[] TYPES_String = new Class[]{String.class};
    private int driverType = 0;
    private int jdbcDriverMajorVersion;
    private int jdbcDriverMinorVersion;
    private boolean tightBranchCouplingSupported;
    private boolean tightBranchCouplingSupportedbyDB;
    private transient String traceFile;
    private transient int configuredTraceLevel;
    private transient Class<DB2JCCHelper> currClass = DB2JCCHelper.class;

    DB2JCCHelper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        Object holder;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        this.configuredTraceLevel = 0;
        this.isRRSTransaction = false;
        this.threadIdentitySupport = 0;
        this.threadSecurity = false;
        boolean traceAppend = false;
        String traceDir = null;
        Object dtype = null;
        boolean validDriverTypeSpecified = false;
        Properties props = mcf.dsConfig.get().vendorProps;
        dtype = props.get("driverType");
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("driverType property = " + dtype), (Object[])new Object[0]);
        }
        if (dtype != null) {
            int n = dtype instanceof Number ? ((Number)dtype).intValue() : (this.driverType = dtype instanceof String ? Integer.valueOf((String)dtype) : 0);
            if (this.driverType == 2 || this.driverType == 4) {
                validDriverTypeSpecified = true;
            }
        }
        if (!validDriverTypeSpecified) {
            throw new ResourceException("Required driverType property was not specifed or is invalid. The driverType property is " + dtype);
        }
        if (this.localZOS && this.driverType == 2) {
            String dsClassName = mcf.vendorImplClass.getName();
            if (dsClassName.equals("com.ibm.db2.jcc.DB2XADataSource")) {
                throw new ResourceException(AdapterUtil.getNLSMessage("DB2ZOS_TYPE2_ERROR"));
            }
            if (dsClassName.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
                this.isRRSTransaction = true;
                this.threadIdentitySupport = 1;
                this.threadSecurity = true;
                Tr.info((TraceComponent)tc, (String)"DB2ZOS_CONFIG_INFO", (Object[])new Object[0]);
            }
        }
        if ((holder = props.get(DB2_TRACE_LEVEL)) != null && !holder.equals("")) {
            int n = holder instanceof Number ? ((Number)holder).intValue() : (this.configuredTraceLevel = holder instanceof String ? Integer.parseInt((String)holder) : 0);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"traceLevel is set to", (Object[])new Object[]{this.configuredTraceLevel});
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS", (Object[])new Object[0]);
        }
        this.traceFile = props.getProperty(DB2_TRACE_FILE);
        traceDir = props.getProperty(DB2_TRACE_FILE_DIR);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"traceDir is set to ", (Object[])new Object[]{traceDir});
        }
        traceDir = traceDir != null && !traceDir.equals("") ? traceDir + File.separator : "";
        holder = props.get(DB2_TRACE_FILE_APPEND);
        boolean bl = holder instanceof Boolean ? (Boolean)holder : (traceAppend = holder instanceof String ? Boolean.valueOf((String)holder) : false);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Trace Append is set to ", (Object[])new Object[]{holder});
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"DB2 JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object[])new Object[]{traceDir + this.traceFile});
            }
            try {
                final String file = traceDir + this.traceFile;
                final boolean append = traceAppend;
                this.genPw = new PrintWriter(AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws FileNotFoundException {
                        return new FileOutputStream(file, append);
                    }
                }), true);
            }
            catch (PrivilegedActionException privX) {
                Exception x = privX.getException();
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"343", (Object)this);
                if (x instanceof FileNotFoundException) {
                    Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object[])new Object[]{this.traceFile});
                }
                if (x instanceof RuntimeException) {
                    throw (RuntimeException)x;
                }
                throw new ResourceException((Throwable)x);
            }
        } else {
            this.genPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
    }

    @Override
    void customizeStaleStates() {
        super.customizeStaleStates();
        Collections.addAll(this.staleErrorCodes, -4499, -4498, -1776);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        try {
            stmt.setCursorName(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public boolean failoverOccurred(SQLException sqlX) {
        return sqlX.getErrorCode() == -4498;
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 1) {
            if (this.tightBranchCouplingSupported) {
                return 0x800000;
            }
            DSConfig config = this.mcf.dsConfig.get();
            if (this.tightBranchCouplingSupportedbyDB) {
                Tr.warning((TraceComponent)tc, (String)"TBC_JCC_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            } else {
                Tr.warning((TraceComponent)tc, (String)"TBC_DB_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            }
        }
        return 0;
    }

    @Override
    public int getDefaultBranchCoupling() {
        return 0;
    }

    @Override
    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        try {
            return (String)this.invokeOnDB2Connection(mc.sqlConn, this.getDB2Correlator, "getDB2Correlator", null, new Object[0]);
        }
        catch (NullPointerException npx) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", npx, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (NoSuchMethodError nsex) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", nsex, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (SQLException sqlex) {
            AdapterUtil.mapSQLException(sqlex, mc);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", sqlex, "method not supported on DB2 driver being used"});
            return null;
        }
    }

    private final Object invokeOnDB2Connection(Connection con, AtomicReference<Method> methRef, String methName, Class<?>[] paramTypes, Object ... params) throws SQLException {
        try {
            Method m = methRef.get();
            if (m == null) {
                Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "com.ibm.db2.jcc.DB2Connection");
                m = c.getMethod(methName, paramTypes);
                methRef.set(m);
            }
            return m.invoke((Object)con, params);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (NoSuchMethodException x) {
            throw (Error)new NoSuchMethodError(methName).initCause(x);
        }
        catch (InvocationTargetException e) {
            throw AdapterUtil.toSQLException(e.getCause());
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled() && !mc.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        return (!isTraceOn || !db2Tc.isDebugEnabled()) && mc.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"Disabling logging on connection: ", (Object[])new Object[]{mc.sqlConn});
        }
        try {
            this.invokeOnDB2Connection(mc.sqlConn, this.setJCCLogWriter, "setJCCLogWriter", TYPES_PrintWriter, new Object[]{null});
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"402", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)db2Tc, (String)"Setting printWriter on connection and with level", (Object[])new Object[]{pw, mc.sqlConn, this.configuredTraceLevel});
        }
        try {
            this.invokeOnDB2Connection(mc.sqlConn, this.setJCCLogWriter2, "setJCCLogWriter", TYPES_PrintWriter_int, pw, this.configuredTraceLevel);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"419", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = true;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
        if (db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"returning", (Object[])new Object[]{this.genPw});
        }
        return this.genPw;
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformationArray", (Object[])new Object[]{clientInfoArray, mc, explicitCall});
        }
        if (explicitCall) {
            mc.clientInfoExplicitlySet = true;
        } else {
            mc.clientInfoImplicitlySet = true;
        }
        try {
            this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientUser, "setDB2ClientUser", TYPES_String, clientInfoArray[0]);
            this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientWorkstation, "setDB2ClientWorkstation", TYPES_String, clientInfoArray[1]);
            this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientApplicationInformation, "setDB2ClientApplicationInformation", TYPES_String, clientInfoArray[2]);
            this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientAccountingInformation, "setDB2ClientAccountingInformation", TYPES_String, clientInfoArray[3]);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"611", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformationArray - Exception", (Object[])new Object[]{ex});
            }
            throw AdapterUtil.mapSQLException(ex, mc);
        }
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet) {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object[])new Object[]{mc});
            }
            try {
                Properties defaultClientInfo = mc.mcf.defaultClientInfo;
                String clientuser = defaultClientInfo.getProperty("ClientUser");
                String clienthostname = defaultClientInfo.getProperty("ClientHostname");
                String applicationname = defaultClientInfo.getProperty("ApplicationName");
                String clientacccountinginformation = defaultClientInfo.getProperty("ClientAccountingInformation");
                this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientUser, "setDB2ClientUser", TYPES_String, clientuser == null ? "" : clientuser);
                this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientWorkstation, "setDB2ClientWorkstation", TYPES_String, clienthostname == null ? "" : clienthostname);
                this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientApplicationInformation, "setDB2ClientApplicationInformation", TYPES_String, applicationname == null ? "" : applicationname);
                this.invokeOnDB2Connection(mc.sqlConn, this.setDB2ClientAccountingInformation, "setDB2ClientAccountingInformation", TYPES_String, clientacccountinginformation == null ? "" : clientacccountinginformation);
                mc.clientInfoExplicitlySet = false;
                mc.clientInfoImplicitlySet = false;
            }
            catch (SQLException ex) {
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"677", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation -- Exception", (Object[])new Object[]{ex});
                }
                throw AdapterUtil.mapSQLException(ex, mc);
            }
        }
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        return true;
    }

    @Override
    public Object getSQLJContext(WSRdbManagedConnectionImpl mc, Class<?> DefaultContext, WSConnectionManager connMgr) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object[])new Object[0]);
        }
        Object rtnctx = null;
        try {
            if (mc.cachedConnection == null) {
                mc.cachedConnection = this.mcf.jdbcRuntime.newConnection(mc, mc.sqlConn, WSRdbManagedConnectionImpl.key, mc.threadID);
                mc.cachedConnection.initialize(connMgr, WSRdbManagedConnectionImpl.key);
                mc.cachedConnection.setCurrentAutoCommit(mc.currentAutoCommit, WSRdbManagedConnectionImpl.key);
            } else {
                mc.cachedConnection.setThreadID(mc.threadID, WSRdbManagedConnectionImpl.key);
            }
        }
        catch (ResourceException rex) {
            FFDCFilter.processException((Throwable)rex, (String)this.getClass().getName(), (String)"550", (Object)this);
            SQLException sqlX = AdapterUtil.toSQLException(rex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)((Object)rex));
            }
            throw sqlX;
        }
        catch (SQLException sqlx) {
            FFDCFilter.processException((Throwable)sqlx, (String)this.getClass().getName(), (String)"1009", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)sqlx);
            }
            throw WSJdbcUtil.mapException(mc.cachedConnection, sqlx);
        }
        try {
            rtnctx = DefaultContext.getConstructor(Connection.class).newInstance(mc.cachedConnection);
        }
        catch (Exception x) {
            RuntimeException rx;
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"549", (Object)this);
            if (x instanceof InvocationTargetException && x.getCause() instanceof SQLException) {
                SQLException sqlX = WSJdbcUtil.mapException(mc.cachedConnection, (SQLException)x.getCause());
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)sqlX);
                }
                throw sqlX;
            }
            RuntimeException runtimeException = rx = x instanceof RuntimeException ? (RuntimeException)x : new RuntimeException(x);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)x);
            }
            throw rx;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", rtnctx);
        }
        return rtnctx;
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        boolean isTraceOn;
        block9: {
            block8: {
                isTraceOn = TraceComponent.isAnyTracingEnabled();
                super.gatherAndDisplayMetaDataInfo(conn, mcf);
                try {
                    DatabaseMetaData mdata = conn.getMetaData();
                    this.jdbcDriverMajorVersion = mdata.getDriverMajorVersion();
                    this.jdbcDriverMinorVersion = mdata.getDriverMinorVersion();
                    if (this.driverType == 4) {
                        String productVersion = mdata.getDatabaseProductVersion().toUpperCase();
                        if (productVersion.startsWith("DSN") || productVersion.startsWith("SQL")) {
                            int version = Integer.parseInt(productVersion.substring(3, 5));
                            boolean bl = this.tightBranchCouplingSupportedbyDB = version > 7;
                        }
                        if (this.jdbcDriverMajorVersion > 4 || this.jdbcDriverMajorVersion == 4 && this.jdbcDriverMinorVersion >= 1 || this.jdbcDriverMajorVersion == 3 && (this.jdbcDriverMinorVersion >= 51 || this.jdbcDriverMinorVersion >= 6 && this.jdbcDriverMinorVersion < 50)) {
                            this.tightBranchCouplingSupported = this.tightBranchCouplingSupportedbyDB;
                        }
                    }
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)(this.getClass().getName() + ".gatherAndDisplayMetaDataInfo"), (String)"1633", (Object)this);
                    if (!isTraceOn || !tc.isDebugEnabled()) break block8;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to determine JDBC driver major/minor version.", (Object[])new Object[]{x});
                }
            }
            try {
                this.isInDatabaseUnitOfWork(conn);
                mcf.supportsUOWDetection = true;
            }
            catch (Throwable t) {
                if (!isTraceOn || !tc.isDebugEnabled()) break block9;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"JCC Driver version does not support isInDB2UnitOfWork method", (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JCC Driver version supports isInDB2UnitOfWork method", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isInDatabaseUnitOfWork(Connection conn) throws SQLException {
        boolean flag = (Boolean)this.invokeOnDB2Connection(conn, this.isInDB2UnitOfWork, "isInDB2UnitOfWork", null, new Object[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isInDatabaseUnitOfWork", (Object[])new Object[]{flag});
        }
        return flag;
    }

    @Override
    public Connection getConnectionFromDatasource(DataSource ds, WSManagedConnectionFactoryImpl.KerbUsage useKerb, Object gssCredential) throws SQLException {
        if (useKerb != WSManagedConnectionFactoryImpl.KerbUsage.USE_CREDENTIAL) {
            return super.getConnectionFromDatasource(ds, useKerb, gssCredential);
        }
        try {
            this.configureForKerberos(ds);
            if (this.getConnectionWithGSS == null) {
                this.getConnectionWithGSS = ds.getClass().getMethod("getConnection", Object.class);
            }
            return (Connection)this.getConnectionWithGSS.invoke((Object)ds, gssCredential);
        }
        catch (Throwable t) {
            throw AdapterUtil.toSQLException(t);
        }
    }

    private void configureForKerberos(CommonDataSource ds) throws Throwable {
        short secMec;
        if (this.setSecurityMechanism == null) {
            this.getSecurityMechanism = ds.getClass().getMethod("getSecurityMechanism", new Class[0]);
            this.setSecurityMechanism = ds.getClass().getMethod("setSecurityMechanism", Short.TYPE);
        }
        if ((secMec = ((Short)this.getSecurityMechanism.invoke((Object)ds, new Object[0])).shortValue()) == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Overriding existing securityMechanism of " + secMec + " to 11 (kerberos)"), (Object[])new Object[0]);
            }
            this.setSecurityMechanism.invoke((Object)ds, (short)11);
        }
    }

    private PooledConnection getPooledConnectionUsingKerberos(CommonDataSource ds, Object gssCredential, boolean is2Phase) throws ResourceException {
        try {
            this.configureForKerberos(ds);
            if (is2Phase) {
                if (this.getDB2XAConnection == null) {
                    this.getDB2XAConnection = ds.getClass().getMethod("getDB2XAConnection", GSSCredential.class, Properties.class);
                }
                return (PooledConnection)this.getDB2XAConnection.invoke((Object)ds, gssCredential, null);
            }
            if (this.getDB2PooledConnection == null) {
                this.getDB2PooledConnection = ds.getClass().getMethod("getDB2PooledConnection", GSSCredential.class, Properties.class);
            }
            return (PooledConnection)this.getDB2PooledConnection.invoke((Object)ds, gssCredential, null);
        }
        catch (Throwable e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public ConnectionResults getPooledConnection(CommonDataSource ds, String userName, String password, boolean is2Phase, WSConnectionRequestInfoImpl cri, WSManagedConnectionFactoryImpl.KerbUsage useKerberos, Object gssCredential) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object[])new Object[]{AdapterUtil.toString(ds), userName, "******", is2Phase ? "two-phase" : "one-phase", cri, useKerberos, gssCredential});
        }
        if (useKerberos == WSManagedConnectionFactoryImpl.KerbUsage.USE_CREDENTIAL) {
            return new ConnectionResults(this.getPooledConnectionUsingKerberos(ds, gssCredential, is2Phase), null);
        }
        ConnectionResults results = super.getPooledConnection(ds, userName, password, is2Phase, cri, useKerberos, gssCredential);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)results);
        }
        return results;
    }

    @Override
    public void reuseKerbrosConnection(Connection sqlConn, GSSCredential gssCred, Properties props) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reuseKerbrosConnection", (Object[])new Object[]{sqlConn, gssCred, PropertyService.hidePasswords(props)});
        }
        this.invokeOnDB2Connection(sqlConn, this.reuseDB2Connection, "reuseDB2Connection", TYPES_GSSCredential_Properties, gssCred, props);
    }
}

