/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Connection;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.GIOPClient;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.GIOPIncomingMessage;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.rmi.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.MsgType_1_1;

final class GIOPConnectionThreaded
extends GIOPConnection {
    private static final Logger logger = Logger.getLogger(GIOPConnectionThreaded.class.getName());
    private final ThreadGate gate = new ThreadGate();
    private final SendMutex sendMutex = new SendMutex();
    private final ReentrantReadWriteLock receiverLock = new ReentrantReadWriteLock(true);
    private boolean shuttingDown;
    private final String label = ObjectUtil.getNextObjectLabel(this.getClass());

    private void addReceiverThread() {
        this.getExecutor().submit(new Receiver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abortiveShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try (OutputStream out = new OutputStream(12);){
                ProfileInfo profileInfo = new ProfileInfo();
                GIOPConnectionThreaded gIOPConnectionThreaded = this;
                synchronized (gIOPConnectionThreaded) {
                    profileInfo.major = this.giopVersion_.major;
                    profileInfo.minor = this.giopVersion_.minor;
                }
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
                out.setPosition(0);
                SendMutex sendMutex = this.sendMutex;
                synchronized (sendMutex) {
                    ReadBuffer readBuffer = out.getBufferReader();
                    this.transport_.send(readBuffer, true);
                    Assert.ensure(readBuffer.isComplete());
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
        this.processException(Connection.State.CLOSED, (SystemException)((Object)Transients.FORCED_SHUTDOWN.create()), false);
        this.arrive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void gracefulShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.upcallsInProgress_ > 0 || this.getState() != Connection.State.CLOSING) {
            logger.fine("pending upcalls: " + this.upcallsInProgress_ + " state: " + (Object)((Object)this.getState()));
            return;
        }
        if (this.canSendCloseConnection()) {
            try (OutputStream out = new OutputStream(12);){
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = this.giopVersion_.major;
                profileInfo.minor = this.giopVersion_.minor;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
                this.messageQueue_.add(this.orbInstance_, out.getBufferReader());
            }
        } else {
            logger.fine("could not send close connection message");
        }
        try {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
            try {
                this.getExecutor().submit(new Shutdown());
            }
            catch (RejectedExecutionException ree) {
                logger.log(Level.WARNING, "Could not submit shutdown task", ree);
            }
        }
        catch (OutOfMemoryError ex) {
            this.processException(Connection.State.CLOSED, (SystemException)new IMP_LIMIT(MinorCodes.describeImpLimit(1095974914), 1095974914, CompletionStatus.COMPLETED_NO), false);
        }
        finally {
            this.arrive();
        }
    }

    private void arrive() {
        if (this.isOutbound()) {
            this.orbInstance_.getClientPhaser().arriveAndDeregister();
        } else {
            this.orbInstance_.getServerPhaser().arriveAndDeregister();
        }
    }

    GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, GIOPClient client) {
        super(orbInstance, transport, client);
        orbInstance.getClientPhaser().register();
        this.start();
    }

    GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, OAInterface oa) {
        super(orbInstance, transport, oa);
        orbInstance.getServerPhaser().register();
    }

    private ExecutorService getExecutor() {
        if (this.isOutbound()) {
            return this.orbInstance_.getClientExecutor();
        }
        return this.orbInstance_.getServerExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execShutdown() {
        Object object;
        if (this.canSendCloseConnection() && this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try {
                object = this;
                synchronized (object) {
                    while (this.messageQueue_.hasUnsent()) {
                        ReadBuffer readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        if (readBuffer == null) continue;
                        SendMutex sendMutex = this.sendMutex;
                        synchronized (sendMutex) {
                            this.transport_.send(readBuffer, true);
                        }
                        this.messageQueue_.moveFirstUnsentToPending();
                    }
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
        object = this.sendMutex;
        synchronized (object) {
            this.transport_.shutdown();
        }
        try {
            this.receiverLock.writeLock().tryLock(this.shutdownTimeout_, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.processException(Connection.State.CLOSED, (SystemException)((Object)Transients.FORCED_SHUTDOWN.create()), false);
        }
        finally {
            if (this.receiverLock.isWriteLockedByCurrentThread()) {
                this.receiverLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execReceive() {
        logger.fine("Receiving incoming message " + this);
        GIOPIncomingMessage inMsg = new GIOPIncomingMessage(this.orbInstance_);
        while (true) {
            Upcall upcall;
            block16: {
                WriteBuffer writer = Buffer.createWriteBuffer(12);
                try {
                    logger.fine("Reading message header");
                    this.transport_.receive(writer, true);
                    Assert.ensure(writer.isComplete());
                }
                catch (SystemException ex) {
                    this.processException(Connection.State.CLOSED, ex, false);
                    return;
                }
                try {
                    inMsg.extractHeader(writer.readFromStart());
                    logger.fine("Header received for message of size " + inMsg.size());
                    writer.ensureAvailable(inMsg.size());
                }
                catch (SystemException ex) {
                    this.processException(Connection.State.ERROR, ex, false);
                    return;
                }
                if (!writer.isComplete()) {
                    try {
                        logger.fine("Receiving message body of size " + inMsg.size());
                        this.transport_.receive(writer, true);
                        Assert.ensure(writer.isComplete());
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return;
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Message body received ");
                    logger.fine("Received message are: \n" + writer.dumpAllData());
                }
                this.gate.admit();
                GIOPConnectionThreaded ex = this;
                synchronized (ex) {
                    if (this.getState().forbids(Connection.Access.READ)) {
                        return;
                    }
                }
                upcall = null;
                try {
                    if (!inMsg.consumeBuffer(writer)) break block16;
                    upcall = this.processMessage(inMsg);
                }
                catch (SystemException ex2) {
                    this.processException(Connection.State.ERROR, ex2, false);
                    return;
                }
            }
            if (upcall == null) continue;
            logger.fine("Processing message using upcall " + upcall.getClass().getName());
            boolean receivedBidirContext = this.transport_.get_info().received_bidir_service_context();
            if (receivedBidirContext) {
                this.addReceiverThread();
            }
            upcall.invoke();
            if (receivedBidirContext) return;
        }
    }

    @Override
    synchronized void ACM_callback() {
        if (this.acmTimer_ != null) {
            this.acmTimer_.cancel();
            this.acmTimer_ = null;
        }
        if (this.acmTask_ != null) {
            this.acmTask_.cancel();
            this.acmTask_ = null;
        }
        if (this.messageQueue_.hasUnsent() || this.upcallsInProgress_ > 0) {
            this.ACM_enableIdleMonitor();
            return;
        }
        this.setState(Connection.State.CLOSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Downcall down, boolean block) {
        block30: {
            Assert.ensure(this.transport_.mode() != SendReceiveMode.ReceiveOnly);
            Assert.ensure(down.unsent());
            logger.fine("Sending a request with Downcall of type " + down.getClass().getName() + " for operation " + down.operation() + " on transport " + this.transport_);
            boolean msgSentMarked = false;
            GIOPConnectionThreaded gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                if (this.checkWriteProhibited(down)) {
                    return true;
                }
                if (down.responseExpected()) {
                    down.allowWaiting();
                }
                this.messageQueue_.add(this.orbInstance_, down);
                if (this.isRequestSent()) {
                    msgSentMarked = true;
                }
            }
            if (block) {
                int t = down.policies().requestTimeout;
                int msgcount = 0;
                while (true) {
                    Downcall nextDown;
                    ReadBuffer readBuffer;
                    Object object = this;
                    synchronized (object) {
                        if (!down.unsent()) {
                            break block30;
                        }
                        Assert.ensure(this.messageQueue_.hasUnsent());
                        readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        nextDown = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    try {
                        object = this.sendMutex;
                        synchronized (object) {
                            if (t <= 0) {
                                this.transport_.send(readBuffer, true);
                                Assert.ensure(readBuffer.isComplete());
                            } else {
                                this.transport_.send_timeout(readBuffer, t);
                                if (!readBuffer.isComplete()) {
                                    throw new NO_RESPONSE();
                                }
                            }
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return true;
                    }
                    if (msgSentMarked || nextDown == null || nextDown.operation().equals("_locate")) continue;
                    msgSentMarked = true;
                    this.markRequestSent();
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(String.format("Sent message in blocking at msgcount=%d, size=%d, the message piece is: %n%s", msgcount, readBuffer.length(), readBuffer.dumpRemainingData()));
                    ++msgcount;
                }
            }
            gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                int msgcount = 0;
                while (down.unsent()) {
                    Assert.ensure(this.messageQueue_.hasUnsent());
                    ReadBuffer readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                    try {
                        SendMutex nextDown = this.sendMutex;
                        synchronized (nextDown) {
                            this.transport_.send(readBuffer, false);
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(Connection.State.CLOSED, ex, false);
                        return true;
                    }
                    if (!readBuffer.isComplete()) {
                        return false;
                    }
                    Downcall dummy = this.messageQueue_.moveFirstUnsentToPending();
                    if (msgSentMarked || dummy == null || !dummy.responseExpected() || !dummy.operation().equals("_locate")) continue;
                    msgSentMarked = true;
                    this.markRequestSent();
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(String.format("Sent message in non-blocking at msgcount=%d, size=%d, the message piece is: %n%s", msgcount, readBuffer.length(), readBuffer.dumpRemainingData()));
                    ++msgcount;
                }
            }
        }
        logger.fine(" Request send completed with Downcall of type " + down.getClass().getName());
        return !down.responseExpected();
    }

    private boolean checkWriteProhibited(Downcall down) {
        boolean writeProhibited;
        Connection.State state = this.getState();
        switch (state) {
            case ACTIVE: 
            case HOLDING: 
            case CLOSING: {
                writeProhibited = false;
                break;
            }
            case STALE: {
                down.notifyStaleConnection();
            }
            case CLOSED: {
                this.setState(Connection.State.STALE);
            }
            case ERROR: {
                logger.fine("writing not enabled for this connection");
                down.setFailureException((SystemException)((Object)new TRANSIENT()));
                writeProhibited = true;
                break;
            }
            default: {
                throw Assert.fail("Unknown connection state: " + (Object)((Object)state));
            }
        }
        return writeProhibited;
    }

    @Override
    public boolean receive(Downcall down, boolean block) {
        logger.fine("Receiving response with Downcall of type " + down.getClass().getName() + " for operation " + down.operation() + " from transport " + this.transport_);
        try {
            boolean result = down.waitUntilCompleted(block);
            logger.fine("Completed receiving response with Downcall of type " + down.getClass().getName());
            return result;
        }
        catch (SystemException ex) {
            this.processException(Connection.State.CLOSED, ex, false);
            return true;
        }
    }

    @Override
    public boolean sendReceive(Downcall down) {
        this.ACM_disableIdleMonitor();
        try {
            boolean bl = this.send(down, true) || this.receive(down, true);
            return bl;
        }
        finally {
            this.ACM_enableIdleMonitor();
        }
    }

    @Override
    void start() {
        block6: {
            this.gate.open();
            if (this.transport_.mode() != SendReceiveMode.SendOnly) {
                try {
                    if (!this.receiverLock.writeLock().tryLock()) break block6;
                    try {
                        this.addReceiverThread();
                    }
                    finally {
                        this.receiverLock.writeLock().unlock();
                    }
                }
                catch (OutOfMemoryError ex) {
                    IMP_LIMIT sysEx = new IMP_LIMIT(MinorCodes.describeImpLimit(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                    sysEx.initCause((Throwable)ex);
                    this.processException(Connection.State.CLOSED, (SystemException)sysEx, false);
                    throw sysEx;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void refresh() {
        boolean msgSentMarked = false;
        this.gate.open();
        GIOPConnectionThreaded gIOPConnectionThreaded = this;
        synchronized (gIOPConnectionThreaded) {
            if (this.getState().forbids(Connection.Access.WRITE)) {
                return;
            }
            if (this.isRequestSent()) {
                msgSentMarked = true;
            }
        }
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            return;
        }
        block14: while (true) {
            try {
                Object object;
                Downcall dummy;
                do {
                    ReadBuffer readBuffer;
                    object = this;
                    synchronized (object) {
                        if (!this.messageQueue_.hasUnsent()) {
                            break block14;
                        }
                        readBuffer = this.messageQueue_.getFirstUnsentBuffer();
                        readBuffer.rewindToStart();
                        dummy = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    object = this.sendMutex;
                    synchronized (object) {
                        this.transport_.send(readBuffer, true);
                    }
                    if (readBuffer.isComplete()) continue;
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                } while (msgSentMarked || dummy == null || !dummy.responseExpected() || !dummy.operation().equals("_locate"));
                object = this;
                synchronized (object) {
                    msgSentMarked = true;
                    this.markRequestSent();
                }
            }
            catch (SystemException ex) {
                this.processException(Connection.State.CLOSED, ex, false);
                return;
            }
        }
    }

    @Override
    void pause() {
        this.gate.close();
    }

    public String toString() {
        return this.label + ": state = " + (Object)((Object)this.getState());
    }

    private static final class SendMutex {
        private SendMutex() {
        }
    }

    private static final class ThreadGate {
        private boolean closed = true;

        private ThreadGate() {
        }

        synchronized void admit() {
            while (this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void open() {
            if (this.closed) {
                this.closed = false;
                this.notifyAll();
            }
        }

        synchronized void close() {
            this.closed = true;
        }
    }

    private final class Receiver
    implements Runnable {
        Receiver() {
            GIOPConnectionThreaded.this.receiverLock.readLock().lock();
        }

        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execReceive();
            }
            catch (RuntimeException ex) {
                throw Assert.fail(ex);
            }
            finally {
                GIOPConnectionThreaded.this.receiverLock.readLock().unlock();
            }
        }
    }

    private final class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execShutdown();
            }
            catch (RuntimeException ex) {
                throw Assert.fail(ex);
            }
        }
    }
}

