/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.ContactValidator;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.examples.Example;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExampleValidator
extends TypeValidator<Example> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ExampleValidator INSTANCE = new ExampleValidator();
    static final long serialVersionUID = 4331484410671267444L;

    public static ExampleValidator getInstance() {
        return INSTANCE;
    }

    private ExampleValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Example t) {
        if (t != null) {
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getValue() != null && t.getExternalValue() != null && !t.getExternalValue().isEmpty()) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"exampleOnlyValueOrExternalValue", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
        }
    }
}

