/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.SingleTableCache;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.UserApiConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.LinkedinLoginConfigImpl;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.IntrospectUserApiUtils;
import com.ibm.ws.security.social.internal.utils.OAuthClientUtil;
import com.ibm.ws.security.social.internal.utils.OpenShiftUserApiUtils;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIUserApiUtils {
    public static final TraceComponent tc = Tr.register(TAIUserApiUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static SingleTableCache userApiCache = null;
    static final long serialVersionUID = -3589337619905799999L;

    @FFDCIgnore(value={SocialLoginException.class})
    public String getUserApiResponse(OAuthClientUtil clientUtil, SocialLoginConfig clientConfig, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory) {
        UserApiConfig[] userinfoCfg = clientConfig.getUserApis();
        if (userinfoCfg == null || userinfoCfg.length == 0) {
            Tr.warning((TraceComponent)tc, (String)"NO_USER_API_CONFIGS_PRESENT", (Object[])new Object[]{clientConfig.getUniqueId()});
            return null;
        }
        UserApiConfig userApiConfig = userinfoCfg[0];
        String userinfoApi = userApiConfig.getApi();
        try {
            if (SocialUtil.isKubeConfig(clientConfig)) {
                return this.getUserApiResponseFromOpenShift(clientConfig, accessToken, sslSocketFactory);
            }
            if ("introspect".equals(clientConfig.getUserApiType())) {
                return this.getUserApiResponseFromIntrospectEndpoint((Oauth2LoginConfigImpl)clientConfig, accessToken, sslSocketFactory);
            }
            if (this.isTokenExpectedToBeServiceAccountToken(clientConfig)) {
                return this.getUserApiResponseForServiceAccountToken(clientConfig, accessToken, sslSocketFactory);
            }
            return this.getUserApiResponseFromGenericThirdParty(clientUtil, clientConfig, accessToken, sslSocketFactory, userinfoApi);
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"ERROR_GETTING_USER_API_RESPONSE", (Object[])new Object[]{userinfoApi, clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return null;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[4];
            objectArray[0] = clientUtil;
            objectArray[1] = clientConfig;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = sslSocketFactory;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIUserApiUtils", (String)"61", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"ERROR_GETTING_USER_API_RESPONSE", (Object[])new Object[]{userinfoApi, clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return null;
        }
    }

    private String getUserApiResponseFromIntrospectEndpoint(Oauth2LoginConfigImpl config, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        IntrospectUserApiUtils introspectUtils = new IntrospectUserApiUtils(config);
        return introspectUtils.getUserApiResponse(accessToken, sslSocketFactory);
    }

    private String getUserApiResponseFromOpenShift(SocialLoginConfig config, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        OpenShiftUserApiUtils openShiftUtils = new OpenShiftUserApiUtils(config);
        return openShiftUtils.getUserApiResponse(accessToken, sslSocketFactory);
    }

    private boolean isTokenExpectedToBeServiceAccountToken(SocialLoginConfig clientConfig) {
        return SocialUtil.isOkdConfig(clientConfig);
    }

    private String getUserApiResponseForServiceAccountToken(SocialLoginConfig config, @Sensitive String serviceAccountToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        String userApiResponse = this.getUserApiResponseFromCache(config, serviceAccountToken);
        if (userApiResponse == null) {
            OpenShiftUserApiUtils openShiftUtils = new OpenShiftUserApiUtils(config);
            userApiResponse = openShiftUtils.getUserApiResponseForServiceAccountToken(serviceAccountToken, sslSocketFactory);
            this.cacheUserApiResponse(serviceAccountToken + config.getUniqueId(), userApiResponse);
        }
        return userApiResponse;
    }

    private String getUserApiResponseFromCache(SocialLoginConfig config, @Sensitive String serviceAccountToken) {
        this.initializeCache(config);
        return (String)userApiCache.get(serviceAccountToken + config.getUniqueId());
    }

    private synchronized void initializeCache(SocialLoginConfig config) {
        long cacheTime = config.getApiResponseCacheTime();
        if (userApiCache == null) {
            userApiCache = new SingleTableCache(cacheTime);
        } else if (cacheTime != userApiCache.getTimeoutInMilliseconds()) {
            userApiCache.rescheduleCleanup(cacheTime);
        }
    }

    private void cacheUserApiResponse(@Sensitive String serviceAccountToken, String userApiResponse) {
        userApiCache.put(serviceAccountToken, (Object)userApiResponse);
    }

    private String getUserApiResponseFromGenericThirdParty(OAuthClientUtil clientUtil, SocialLoginConfig clientConfig, String accessToken, SSLSocketFactory sslSocketFactory, String userinfoApi) throws Exception {
        String userApiResp = clientUtil.getUserApiResponse(userinfoApi, accessToken, sslSocketFactory, false, clientConfig.getUserApiNeedsSpecialHeader(), clientConfig.getUseSystemPropertiesForHttpClientConnections());
        if (clientConfig instanceof LinkedinLoginConfigImpl) {
            return this.convertLinkedinToJson(userApiResp, clientConfig.getUserNameAttribute());
        }
        if (userApiResp != null && userApiResp.startsWith("[") && userApiResp.endsWith("]")) {
            return this.convertToJson(userApiResp, clientConfig.getUserNameAttribute());
        }
        return userApiResp;
    }

    private String convertLinkedinToJson(String resp, String usernameattr) {
        int end = 0;
        int begin = resp.indexOf(usernameattr) - 1;
        if (begin > 0) {
            end = resp.indexOf("}", begin);
            return resp.substring(begin - 1, end + 1);
        }
        return null;
    }

    private String convertToJson(String userApiResp, String usernameattr) {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"").append(usernameattr).append("\":").append(userApiResp).append("}");
        return sb.toString();
    }
}

