/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATAsynchReadAheadReader;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class CATProxyConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATProxyConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATProxyConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final SendListener INVALIDATE_CONNECTION_ON_ERROR;
    private CATAsynchReadAheadReader callback;
    private CATMainConsumer mainConsumer;
    private int sentBytes = 0;
    private int requestedBytes = 0;

    public CATProxyConsumer(CATMainConsumer mainConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)mainConsumer);
        }
        this.mainConsumer = mainConsumer;
        this.requestedBytes = mainConsumer.getRequestedBytes();
        this.callback = new CATAsynchReadAheadReader(this, mainConsumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    protected ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        ConsumerSession sess = this.mainConsumer.getConsumerSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)sess);
        }
        return sess;
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        Conversation conv = this.mainConsumer.getConversation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)conv);
        }
        return conv;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        int lowestPri = this.mainConsumer.getLowestPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)lowestPri);
        }
        return lowestPri;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        short sessId = this.mainConsumer.getClientSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        return sessId;
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        Reliability rel = this.mainConsumer.getUnrecoverableReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        return rel;
    }

    @Override
    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext, boolean stoppable, int maxSequentialFailures, long hiddenMessageDelay) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay});
        }
        try {
            if (batchsize > 1 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"*** The batch size submitted to CATProxyConsumer was great than 1");
            }
            this.getConsumerSession().registerAsynchConsumerCallback((AsynchConsumerCallback)this.callback, maxActiveMessages, messageLockExpiry, batchsize, null);
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException(e.getMessage(), e);
            throw r;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to delete " + msgHandles.length + " message(s)"));
        }
        try {
            this.getConsumerSession().unlockSet(msgHandles);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0004", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0003", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-021-0003", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2006", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply, boolean incrementLockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply, incrementLockCount});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to delete " + msgHandles.length + " message(s)"));
        }
        try {
            this.getConsumerSession().unlockSet(msgHandles, incrementLockCount);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0012", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0013", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-021-0013", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2006", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void deleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{requestNumber, msgHandles, tran, reply});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to delete " + msgHandles.length + " message(s)"));
            if (reply) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Client is expecting a reply");
            }
        }
        try {
            SITransaction siTran = ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().get(tran);
            if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                this.getConsumerSession().deleteSet(msgHandles, siTran);
            }
            try {
                if (reply) {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 219, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-021-0002", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-021-0001", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-021-0001", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_MSGS_SICO2007", (Object)((Object)e));
            StaticCATHelper.sendAsyncExceptionToClient(e, "3-021-0001", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)requestNumber);
        }
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
                this.started = false;
            }
            this.mainConsumer.incremenetMessageBatchNumber();
            this.getConsumerSession().unlockAll();
            CATProxyConsumer cATProxyConsumer = this;
            synchronized (cATProxyConsumer) {
                this.setSentBytes(0);
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 216, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                if (this.mainConsumer.isStarted()) {
                    this.getConsumerSession().start(false);
                    this.started = true;
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0005", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0006", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-021-0006", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    @Override
    public void flush(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)requestNumber);
        }
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
            }
            this.getConsumerSession().activateAsynchConsumer(true);
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().start(false);
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 215, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-021-0007", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-021-0008", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-021-0008", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
        }
    }

    int sendMessage(SIBusMessage sibMessage) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)sibMessage);
        }
        int msgLen = 0;
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        msgLen = props.getFapLevel() >= 9 ? this.sendChunkedMessage(sibMessage) : this.sendEntireMessage(sibMessage, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)msgLen);
        }
        return msgLen;
    }

    private int sendChunkedMessage(SIBusMessage sibMessage) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)sibMessage);
        }
        int msgLen = 0;
        CommsServerByteBuffer buffer = poolManager.allocate();
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        try {
            List messageSlices = buffer.encodeFast((AbstractMessage)((JsMessage)sibMessage), convState.getCommsConnection(), this.getConversation());
            for (DataSlice slice : messageSlices) {
                msgLen += slice.getLength();
            }
            if (msgLen < 1024000) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
                }
                this.sendEntireMessage(sibMessage, messageSlices);
            } else {
                short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)sibMessage.getPriority());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
                }
                for (int x = 0; x < messageSlices.size(); ++x) {
                    DataSlice slice = (DataSlice)messageSlices.get(x);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                    }
                    boolean first = x == 0;
                    boolean last = x == messageSlices.size() - 1;
                    byte flags = 0;
                    if (first) {
                        flags = (byte)(flags | 1);
                    }
                    if (last) {
                        flags = (byte)(flags | 4);
                    } else if (!first) {
                        flags = (byte)(flags | 2);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                    }
                    if (!first) {
                        buffer = poolManager.allocate();
                    }
                    buffer.putShort(convState.getConnectionObjectId());
                    buffer.putShort(this.mainConsumer.getClientSessionId());
                    buffer.putShort(this.mainConsumer.getMessageBatchNumber());
                    buffer.put(flags);
                    buffer.putDataSlice(slice);
                    this.getConversation().send((JFapByteBuffer)buffer, 247, 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, INVALIDATE_CONNECTION_ON_ERROR);
                }
                ++this.messagesSent;
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"3-021-0011", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
            msgLen = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)msgLen);
        }
        return msgLen;
    }

    private int sendEntireMessage(SIBusMessage sibMessage, List<DataSlice> messageSlices) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{sibMessage, messageSlices});
        }
        int msgLen = 0;
        try {
            CommsServerByteBuffer buffer = poolManager.allocate();
            ConversationState convState = (ConversationState)this.getConversation().getAttachment();
            buffer.putShort(convState.getConnectionObjectId());
            buffer.putShort(this.mainConsumer.getClientSessionId());
            buffer.putShort(this.mainConsumer.getMessageBatchNumber());
            msgLen = messageSlices == null ? buffer.putMessage((JsMessage)sibMessage, convState.getCommsConnection(), this.getConversation()) : buffer.putMessgeWithoutEncode(messageSlices);
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)sibMessage.getPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            this.getConversation().send((JFapByteBuffer)buffer, 220, 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, INVALIDATE_CONNECTION_ON_ERROR);
            ++this.messagesSent;
        }
        catch (SIException e1) {
            FFDCFilter.processException((Throwable)e1, (String)(CLASS_NAME + ".sendEntireMessage"), (String)"3-021-0009", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e1));
            msgLen = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)msgLen);
        }
        return msgLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestMsgs(int requestNumber, int receivedBytes, int reqBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestMsgs", (Object)new Object[]{"" + requestNumber, "" + receivedBytes, "" + reqBytes});
        }
        try {
            CATProxyConsumer cATProxyConsumer = this;
            synchronized (cATProxyConsumer) {
                this.setSentBytes(this.getSentBytes() - receivedBytes);
                this.setRequestedBytes(reqBytes);
                int sent = this.getSentBytes();
                if (sent < reqBytes) {
                    if (!this.started) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting the session (sentBytes < requestedBytes && !started)");
                        }
                        this.getConsumerSession().start(false);
                        this.started = true;
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already started");
                    }
                }
                if (sent >= reqBytes) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping the session (sentBytes >= requestedBytes)");
                    }
                    this.getConsumerSession().stop();
                    this.started = false;
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".requestMsgs"), (String)"3-021-0010", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendAsyncExceptionToClient(e, "3-021-0010", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestMsgs");
        }
    }

    public int getRequestedBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRequestedBytes");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRequestedBytes", (Object)this.requestedBytes);
        }
        return this.requestedBytes;
    }

    public void setRequestedBytes(int newRequestedBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRequestedBytes", (Object)newRequestedBytes);
        }
        this.requestedBytes = newRequestedBytes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRequestedBytes");
        }
    }

    public int getSentBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSentBytes");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSentBytes", (Object)this.sentBytes);
        }
        return this.sentBytes;
    }

    public void setSentBytes(int newSentBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSentBytes", (Object)newSentBytes);
        }
        this.sentBytes = newSentBytes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSentBytes");
        }
    }

    public void setLowestPriority(short pri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLowestPriority", (Object)pri);
        }
        this.mainConsumer.setLowestPriority(pri);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLowestPriority");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(int requestNumber, boolean incrementUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{requestNumber, incrementUnlockCount});
        }
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
                this.started = false;
            }
            this.mainConsumer.incremenetMessageBatchNumber();
            this.getConsumerSession().unlockAll(incrementUnlockCount);
            CATProxyConsumer cATProxyConsumer = this;
            synchronized (cATProxyConsumer) {
                this.setSentBytes(0);
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 135, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                if (this.mainConsumer.isStarted()) {
                    this.getConsumerSession().start(false);
                    this.started = true;
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0014", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2014", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0015", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-021-0015", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    @Override
    public void dump(FormattedWriter writer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump", (Object)new Object[]{writer});
        }
        try {
            writer.newLine();
            writer.startTag(this.getClass().getSimpleName());
            writer.indent();
            writer.newLine();
            writer.taggedValue("toString", (Object)this.toString());
            writer.newLine();
            writer.taggedValue("sentBytes", (long)this.getSentBytes());
            writer.newLine();
            writer.taggedValue("requestedBytes", (long)this.getRequestedBytes());
            ConsumerSession consumerSession = this.getConsumerSession();
            if (consumerSession != null) {
                consumerSession.dump(writer);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag(this.getClass().getSimpleName());
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump " + this + " " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", sentBytes: " + this.sentBytes + ", requestedBytes: " + this.requestedBytes);
        return builder.toString();
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATProxyConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.78.1.2");
        }
        INVALIDATE_CONNECTION_ON_ERROR = new ProxyConsumerSendListener();
    }

    private static class ProxyConsumerSendListener
    implements SendListener {
        private ProxyConsumerSendListener() {
        }

        public void dataSent(Conversation conversation) {
        }

        public void errorOccurred(SIConnectionLostException exception, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Invalidating conversation: " + conversation + " because the send failed due to: " + exception));
            }
            conversation.getConnectionReference().invalidate(false, (Throwable)exception, "errorOccurred when sending SIBus Message");
        }
    }
}

