/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.ServerCommand;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;

public class ServerCommandClient
extends ServerCommand {
    final String serverName;
    private static final char DELIM = '#';

    public ServerCommandClient(BootstrapConfig bootProps) {
        super(bootProps);
        this.serverName = bootProps.getProcessName();
        this.serverUUID = "CLIENT";
    }

    public boolean isValid() {
        return this.commandFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCommand.ServerCommandID createServerCommand(String command) throws IOException {
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            fis = new FileInputStream(this.commandFile);
            reader = new BufferedReader(new InputStreamReader(fis));
            String line = reader.readLine();
            if (line == null) {
                line = "";
            }
            ServerCommand.ServerCommandID serverCommandID = (ServerCommand)this.new ServerCommand.ServerCommandID(line, command);
            return serverCommandID;
        }
        finally {
            if (!Utils.tryToClose(reader)) {
                Utils.tryToClose(fis);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ReturnCode write(String command, ReturnCode notStartedRC, ReturnCode errorRC) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 11[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ReturnCode startStatus(ServerLock lock) {
        while (!this.isValid()) {
            ReturnCode rc = this.startStatusWait(lock);
            if (rc == ReturnCode.START_STATUS_ACTION) continue;
            return rc;
        }
        for (int i = 0; i < 60 && this.isValid(); ++i) {
            ReturnCode rc = this.write("status:start", ReturnCode.START_STATUS_ACTION, ReturnCode.ERROR_SERVER_START);
            if (rc != ReturnCode.START_STATUS_ACTION) {
                return rc;
            }
            rc = this.startStatusWait(lock);
            if (rc == ReturnCode.START_STATUS_ACTION) continue;
            return rc;
        }
        return this.write("status:start", ReturnCode.ERROR_SERVER_START, ReturnCode.ERROR_SERVER_START);
    }

    private ReturnCode startStatusWait(ServerLock lock) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Debug.printStackTrace(ex);
            return ReturnCode.ERROR_SERVER_START;
        }
        if (!lock.testServerRunning()) {
            return ReturnCode.ERROR_SERVER_START;
        }
        return ReturnCode.START_STATUS_ACTION;
    }

    public ReturnCode stopServer(boolean force) {
        return this.write(force ? "forceStop" : "stop", ReturnCode.REDUNDANT_ACTION_STATUS, ReturnCode.ERROR_SERVER_STOP);
    }

    public ReturnCode introspectServer(String dumpTimestamp, Set<JavaDumpAction> javaDumpActions) {
        String command;
        if (javaDumpActions.isEmpty()) {
            command = "introspect#" + dumpTimestamp;
        } else {
            StringBuilder commandBuilder = new StringBuilder().append("introspectJavadump").append('#').append(dumpTimestamp);
            for (JavaDumpAction javaDumpAction : javaDumpActions) {
                commandBuilder.append(',').append(javaDumpAction.name());
            }
            command = commandBuilder.toString();
        }
        return this.write(command, ReturnCode.DUMP_ACTION, ReturnCode.ERROR_SERVER_DUMP);
    }

    public ReturnCode javaDump(Set<JavaDumpAction> javaDumpActions) {
        StringBuilder commandBuilder = new StringBuilder("javadump");
        int sep = 35;
        for (JavaDumpAction javaDumpAction : javaDumpActions) {
            commandBuilder.append((char)sep).append(javaDumpAction.toString());
            sep = 44;
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_DUMP);
    }

    public ReturnCode pause(String targetArg) {
        StringBuilder commandBuilder = new StringBuilder("pause");
        char sep = '#';
        if (targetArg != null) {
            commandBuilder.append(sep).append(targetArg);
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_PAUSE);
    }

    public ReturnCode resume(String targetArg) {
        StringBuilder commandBuilder = new StringBuilder("resume");
        char sep = '#';
        if (targetArg != null) {
            commandBuilder.append(sep).append(targetArg);
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_RESUME);
    }
}

