/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.internal;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.OAuth20Component;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentImpl;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.mediator.impl.OAuth20MediatorDefaultImpl;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.oauth20.store.OAuthStore;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OAuth20ProviderConfiguration;
import com.ibm.ws.security.oauth20.api.OauthConsentStore;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.exception.OAuthProviderException;
import com.ibm.ws.security.oauth20.filter.OAuthResourceProtectionFilter;
import com.ibm.ws.security.oauth20.impl.OAuth20ComponentConfigurationImpl;
import com.ibm.ws.security.oauth20.plugins.BaseCache;
import com.ibm.ws.security.oauth20.plugins.BaseTokenHandler;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore;
import com.ibm.ws.security.oauth20.plugins.custom.OauthConsentStoreImpl;
import com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore;
import com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcClientProvider;
import com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore;
import com.ibm.ws.security.oauth20.plugins.db.DBConsentCache;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.util.OAuth20Parameter;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import io.openliberty.security.oauth20.internal.config.OAuthEndpointSettings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.oauth20.provider"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={OAuth20Provider.class, ConfigurationListener.class, ServerQuiesceListener.class}, immediate=false, property={"service.vendor=IBM", "dataSourceFactory.target=(id=unbound)"})
public class LibertyOAuth20Provider
implements OAuth20Provider,
ConfigurationListener,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(LibertyOAuth20Provider.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private volatile ConfigurationAdmin configAdmin = null;
    private static final String KEY_CLASSLOADING_SVC = "classLoadingSvc";
    private volatile ClassLoadingService classLoadingSvc = null;
    private static final String KEY_OIDC_IDTOKEN_HANDLER = "IDTokenHandler";
    private static volatile OAuth20TokenTypeHandler oidcIDTokenHandler = null;
    private static final String KEY_OIDC_GRANT_TYPE_HANDLER_FACTORY = "OAuth20GrantTypeHandlerFactory";
    private static volatile OAuth20GrantTypeHandlerFactory oidcGrantTypeHandlerFactory = null;
    private static final String KEY_OIDC_RESPONSE_TYPE_HANDLER_FACTORY = "OAuth20ResponseTypeHandlerFactory";
    private static volatile OAuth20ResponseTypeHandlerFactory oidcResponseTypeHandlerFactory = null;
    private static final String KEY_OAUTH_SHARED_LIB = "sharedLib";
    private volatile Library sharedLib = null;
    private static final String KEY_OIDC_SERVER = "oidcServer";
    private static final String KEY_DATA_SOURCE_FACTORY = "dataSourceFactory";
    private ResourceFactory dataSourceFactory = null;
    private static final String KEY_RESOURCE_CONFIG_FACTORY = "resourceConfigFactory";
    private ResourceConfigFactory resourceConfigFactory = null;
    private static final String KEY_JDBC_DATASOURCEREF = "dataSourceRef";
    private static final String KEY_EXECUTOR_SVC = "executorService";
    protected static final String KEY_PROVIDER_ID = "id";
    protected static final String KEY_MAX_AUTHGRANT_LT_SECS = "authorizationGrantLifetime";
    protected static final String KEY_CODE_LT_SECS = "authorizationCodeLifetime";
    protected static final String KEY_CODE_LEN = "authorizationCodeLength";
    protected static final String KEY_TOK_LT_SECS = "accessTokenLifetime";
    protected static final String KEY_ACCESS_TOK_LEN = "accessTokenLength";
    protected static final String KEY_ISSUE_REFRESH_TOK = "issueRefreshToken";
    protected static final String KEY_REFRESH_TOK_LEN = "refreshTokenLength";
    protected static final String KEY_MED_CLASS_NAMES = "mediatorClassname";
    protected static final String KEY_ALLOW_PUBLIC_CLIENTS = "allowPublicClients";
    protected static final String KEY_GRANT_TYPE = "grantType";
    protected static final String KEY_AUTHZ_FORM_TEMP = "authorizationFormTemplate";
    protected static final String KEY_AUTHZ_ERR_TEMP = "authorizationErrorTemplate";
    protected static final String KEY_AUTHZ_LOGIN_URL = "customLoginURL";
    protected static final String KEY_AUTO_AUTHZ_PARAM = "autoAuthorizeParam";
    protected static final String KEY_AUTO_AUTHORIZE = "autoAuthorize";
    protected static final String KEY_AUTO_AUTHZ_CLIENT = "autoAuthorizeClient";
    protected static final String KEY_CL_URI_SUBS = "clientURISubstitutions";
    protected static final String KEY_TOK_USER_CLIENT_LIMIT = "userClientTokenLimit";
    protected static final String KEY_FILTER = "filter";
    protected static final String KEY_CHARACTER_ENCODING = "characterEncoding";
    protected static final String KEY_OUATH_ONLY = "oauthOnly";
    protected static final String KEY_INCLUDE_TOKEN = "includeTokenInSubject";
    protected static final String KEY_CONSENT_CACHE_ENTRY_LIFETIME = "consentCacheEntryLifetime";
    protected static final String KEY_CONSENT_CACHE_SIZE = "consentCacheSize";
    protected static final String KEY_HTTPS_REQUIRED = "httpsRequired";
    protected static final String KEY_CERT_AUTHENTICATION = "certAuthentication";
    protected static final String KEY_ALLOW_CERT_AUTHENTICATION = "allowCertAuthentication";
    protected static final String KEY_ALLOW_SPNEGO_AUTHENTICATION = "allowSpnegoAuthentication";
    protected static final String KEY_CLIENT_ADMIN = "clientAdmin";
    protected static final String KEY_JWT_MAX_JTI_CACHE_SIZE = "maxJtiCacheSize";
    protected static final String KEY_JWT_SKEW = "clockSkew";
    protected static final String KEY_JWT_TOKEN_MAX_LIFETIME = "tokenMaxLifetime";
    protected static final String KEY_JWT_IAT_REQUIRED = "iatRequired";
    protected static final String KEY_SKIP_USER_VALIDATION = "skipResourceOwnerValidation";
    protected static final String KEY_JWT_ACCESS_TOKEN = "jwtAccessToken";
    static final String KEY_STORE_ACCESSTOKEN_ENCODING = "accessTokenEncoding";
    protected static final String KEY_PASSWORD_GRANT_REQUIRES_APP_PASSWORD = "passwordGrantRequiresAppPassword";
    protected static final String KEY_APP_PASSWORD_LIFETIME = "appPasswordLifetime";
    protected static final String KEY_APP_TOKEN_LIFETIME = "appTokenLifetime";
    protected static final String KEY_APP_TOKEN_OR_PASSWORD_LIMIT = "appTokenOrPasswordLimit";
    protected static final String KEY_INTERNAL_CLIENT_ID = "internalClientId";
    protected static final String KEY_INTERNAL_CLIENT_SECRET = "internalClientSecret";
    protected static final String KEY_TOKEN_FORMAT = "tokenFormat";
    protected static final String KEY_logoutRedirectURL = "logoutRedirectURL";
    protected static final String KEY_CACHE_ACCESSTOKEN = "accessTokenCacheEnabled";
    protected static final String KEY_REVOKE_ACCESSTOK_W_REFRESHTOK = "revokeAccessTokensWithRefreshTokens";
    public static final String KEY_TRACK_OAUTH_CLIENTS = "trackOAuthClients";
    public static final String KEY_OAUTH_ENDPOINT = "oauthEndpoint";
    public static final String KEY_REFRESHED_ACCESS_TOKEN_LIMIT = "refreshedAccessTokenLimit";
    protected static final String KEY_COVERAGE_MAP_SESSION_MAX_AGE = "coverageMapSessionMaxAge";
    static final String KEY_JDBC_TOK_TABLE = "tokenTable";
    static final String KEY_JDBC_CLEANUP_INT = "cleanupExpiredTokenInterval";
    static final String KEY_JDBC_LIM_REF_TOK = "limitRefreshToken";
    static final String KEY_JDBC_PASSWORD = "password";
    static final String KEY_JDBC_USER = "user";
    static final String KEY_JDBC_SCHEMA = "schema";
    static final String KEY_CUSTOM_CLEANUP_INT = "cleanupExpiredInterval";
    static final String KEY_TOK_STORE_SIZE = "tokenStoreSize";
    public static final String KEY_CLIENT_ID = "name";
    public static final String KEY_CLIENT_COMPONENT = "component";
    public static final String KEY_CLIENT_SECRET = "secret";
    public static final String KEY_CLIENT_DISPLAYNAME = "displayname";
    public static final String KEY_CLIENT_REDIRECT = "redirect";
    public static final String KEY_CLIENT_ENABLED = "enabled";
    public static final String KEY_CLIENT_TOKEN_EP_AUTH_METHOD = "tokenEndpointAuthMethod";
    public static final String KEY_CLIENT_SCOPE = "scope";
    public static final String KEY_CLIENT_GRANT_TYPES = "grantTypes";
    public static final String KEY_CLIENT_RESPONSE_TYPES = "responseTypes";
    public static final String KEY_CLIENT_APP_TYPE = "applicationType";
    public static final String KEY_CLIENT_SUBJECT_TYPE = "subjectType";
    public static final String KEY_CLIENT_POST_LOGOUT_REDIRECT_URIS = "postLogoutRedirectUris";
    public static final String KEY_CLIENT_PREAUTHORIZED_SCOPE = "preAuthorizedScope";
    public static final String KEY_CLIENT_INTROSPECT_TOKENS = "introspectTokens";
    public static final String KEY_CLIENT_TRUSTED_URI_PREFIXES = "trustedUriPrefixes";
    public static final String KEY_CLIENT_RESOURCE_IDS = "resourceIds";
    public static final String KEY_CLIENT_FUNCTIONAL_USER_ID = "functionalUserId";
    public static final String KEY_CLIENT_FUNCTIONAL_USER_GROUPIDS = "functionalUserGroupIds";
    public static final String KEY_CLIENT_allowRegexpRedirects = "allowRegexpRedirects";
    public static final String KEY_CLIENT_APP_PASSWORD_ALLOWED = "appPasswordAllowed";
    public static final String KEY_CLIENT_APP_TOKEN_ALLOWED = "appTokenAllowed";
    public static final String KEY_CLIENT_SECRET_ENCODING = "clientSecretEncoding";
    public static final String KEY_CLIENT_PROOF_KEY_FOR_CODE_EXCHANGE = "proofKeyForCodeExchange";
    public static final String KEY_CLIENT_PUBLIC_CLIENT = "publicClient";
    public static final String KEY_ROPC_PREFER_USERSECURITYNAME = "ropcPreferUserSecurityName";
    private volatile SecurityService securityService;
    private static final String VALUE_DB_CLIENT_TABLE = ".OAUTH20CLIENTCONFIG";
    private static final String VALUE_DB_TOKEN_TABLE = ".OAUTH20CACHE";
    private static final String CONSENT_CACHE_DB_TABLE = ".OAUTH20CONSENTCACHE";
    private Map<String, Object> properties;
    private OAuthResourceProtectionFilter resourceProtectionFilter;
    private ClassLoader pluginClassLoader;
    private boolean needToCreateCoreClasses = true;
    private OAuth20Component component;
    private OAuth20ProviderConfiguration providerConfig;
    private OidcOAuth20ClientProvider clientProvider;
    private OAuth20EnhancedTokenCache tokenCache;
    private ExecutorService executorService;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    private final CommonConfigUtils configUtils = new CommonConfigUtils();
    private String providerId;
    private long authorizationGrantLifetime;
    private long authorizationCodeLifetime;
    private int authorizationCodeLength;
    private long accessTokenLifetime;
    private int accessTokenLength;
    private boolean issueRefreshToken;
    private int refreshTokenLength;
    private String mediatorClassname;
    private boolean allowPublicClients;
    private String[] grantTypesAllowed;
    private String authorizationFormTemplate;
    private String authorizationErrorTemplate;
    private String customLoginURL;
    private String autoAuthorizeParam;
    private boolean autoAuthorize;
    private String[] autoAuthorizeClients;
    private String clientURISubstitutions;
    private long clientTokenCacheSize;
    private String filter;
    private String characterEncoding;
    private boolean oauthOnly;
    private boolean includeTokenInSubject;
    private long consentCacheEntryLifetime;
    private long consentCacheSize;
    private boolean httpsRequired;
    private boolean certAuthentication;
    private boolean allowCertAuthentication = true;
    private boolean allowSpnegoAuthentication = false;
    private String clientAdmin;
    private long jwtMaxJtiCacheSize;
    private long jwtSkew;
    private long jwtTokenMaxLifetime;
    private boolean jwtIatRequired;
    private boolean jwtAccessToken = false;
    private long coverageMapSessionMaxAge;
    private boolean skipUserValidation;
    private String accessTokenEncoding = "plain";
    private String schemaName;
    private String logoutRedirectURL;
    private boolean passwordGrantRequiresAppPassword = false;
    private long appPasswordLifetime = 0L;
    private long appTokenLifetime = 0L;
    private long appTokenOrPasswordLimit = 0L;
    private String internalClientId;
    @Sensitive
    private String internalClientSecret;
    private String clientSecretEncoding;
    private long refreshedAccessTokenLimit = 100L;
    private boolean isCustomStore;
    private boolean isLocalStore;
    private boolean isDatabaseStore;
    private boolean checkForSharedLib;
    private boolean checkForDataSource;
    private final Set<String> pids = new HashSet<String>();
    private Long cleanupInterval;
    private Boolean limitRefreshToken;
    private String[] providerRewrites;
    private Object[] credentials;
    private Long tokenStoreSize;
    private boolean isValid = false;
    private boolean cacheAccessToken = true;
    private List<OidcBaseClient> clientsList = null;
    private ArrayList<OAuth20Parameter> parameters = null;
    private Set<String> finalGrantTypesAllowedSet;
    private OAuth20TokenTypeHandler tokenTypeHandler;
    private String idTokenTypeHandlerClassname;
    private OAuth20TokenTypeHandler idTokenTypeHandler;
    private String grantTypeHandlerFactoryClassname;
    private OAuth20GrantTypeHandlerFactory grantTypeHandlerFactory;
    private String responseTypeHandlerFactoryClassname;
    private OAuth20ResponseTypeHandlerFactory responseTypeHandlerFactory;
    private OAuthAuditHandler auditHandler;
    private OAuth20Mediator mediator;
    private OauthConsentStore consentCache;
    private byte[] authorizationFormTemplateContent = null;
    private boolean mpJwt = false;
    private String tokenFormat;
    private boolean revokeAccessTokensWithRefreshTokens = true;
    private boolean ropcPreferUserSecurityName = false;
    private boolean trackOAuthClients = false;
    private OAuthEndpointSettings oauthEndpointSettings;
    Pattern patternOauthOidc = null;
    private String bundleLocation;
    static final String OIDC_CTX = "/oidc/";
    static final String OAUTH2_CTX = "/oauth2/";
    private final AtomicReference<OAuthStore> iOAuthStoreRef = new AtomicReference();
    int iSubOidcOauth = 0;
    String[] subOidcOauth = new String[4];
    int iHttps = 0;
    String[] https = new String[3];
    int iIndepends = 0;
    String[] independs = new String[3];
    static final long serialVersionUID = 8949254143340422660L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.writeLock.lock();
        try {
            this.properties = properties;
            this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
            this.setupFields();
            this.processProviderConfig();
            this.validateConfig();
            this.loadAuthFormTemplate(cc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activated provider: " + this.providerId), (Object[])new Object[0]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void loadAuthFormTemplate(ComponentContext cc) {
        if (this.authorizationFormTemplate == null || this.authorizationFormTemplate.compareTo("template.html") != 0) {
            this.authorizationFormTemplateContent = null;
            return;
        }
        try {
            if (cc.getBundleContext() == null || cc.getBundleContext().getBundle() == null) {
                return;
            }
            URL u = cc.getBundleContext().getBundle().getResource("template.html");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (u == null) {
                return;
            }
            InputStream is = u.openConnection().getInputStream();
            byte[] buf = new byte[4096];
            int count = -1;
            while ((count = is.read(buf)) != -1) {
                baos.write(buf, 0, count);
            }
            is.close();
            baos.close();
            this.authorizationFormTemplateContent = baos.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"414", (Object)this, (Object[])new Object[]{cc});
        }
    }

    private void setupFields() {
        this.providerId = (String)this.properties.get(KEY_PROVIDER_ID);
        this.authorizationGrantLifetime = (Long)this.properties.get(KEY_MAX_AUTHGRANT_LT_SECS);
        this.authorizationCodeLifetime = (Long)this.properties.get(KEY_CODE_LT_SECS);
        this.authorizationCodeLength = this.getProperty(KEY_CODE_LEN, 30, 2048);
        this.accessTokenLifetime = (Long)this.properties.get(KEY_TOK_LT_SECS);
        this.accessTokenLength = this.getProperty(KEY_ACCESS_TOK_LEN, 40, 2048);
        this.issueRefreshToken = (Boolean)this.properties.get(KEY_ISSUE_REFRESH_TOK);
        this.refreshTokenLength = this.getProperty(KEY_REFRESH_TOK_LEN, 50, 2048);
        this.allowPublicClients = (Boolean)this.properties.get(KEY_ALLOW_PUBLIC_CLIENTS);
        this.grantTypesAllowed = (String[])this.properties.get(KEY_GRANT_TYPE);
        this.authorizationFormTemplate = (String)this.properties.get(KEY_AUTHZ_FORM_TEMP);
        if (this.authorizationFormTemplate == null || this.authorizationFormTemplate.trim().isEmpty()) {
            this.authorizationFormTemplate = "template.html";
        }
        this.authorizationErrorTemplate = (String)this.properties.get(KEY_AUTHZ_ERR_TEMP);
        this.customLoginURL = (String)this.properties.get(KEY_AUTHZ_LOGIN_URL);
        if (this.customLoginURL == null || "".equals(this.customLoginURL.trim())) {
            this.customLoginURL = "login.jsp";
        }
        this.handlePatterns();
        this.autoAuthorizeParam = (String)this.properties.get(KEY_AUTO_AUTHZ_PARAM);
        this.autoAuthorize = (Boolean)this.properties.get(KEY_AUTO_AUTHORIZE);
        this.autoAuthorizeClients = (String[])this.properties.get(KEY_AUTO_AUTHZ_CLIENT);
        this.clientURISubstitutions = (String)this.properties.get(KEY_CL_URI_SUBS);
        this.clientTokenCacheSize = 0L;
        if (this.properties.containsKey(KEY_TOK_USER_CLIENT_LIMIT)) {
            this.clientTokenCacheSize = (Long)this.properties.get(KEY_TOK_USER_CLIENT_LIMIT);
        }
        this.filter = (String)this.properties.get(KEY_FILTER);
        this.setResourceProtectionFilter(this.filter);
        this.characterEncoding = (String)this.properties.get(KEY_CHARACTER_ENCODING);
        this.oauthOnly = (Boolean)this.properties.get(KEY_OUATH_ONLY);
        this.includeTokenInSubject = (Boolean)this.properties.get(KEY_INCLUDE_TOKEN);
        this.consentCacheEntryLifetime = (Long)this.properties.get(KEY_CONSENT_CACHE_ENTRY_LIFETIME);
        this.consentCacheSize = (Long)this.properties.get(KEY_CONSENT_CACHE_SIZE);
        this.httpsRequired = (Boolean)this.properties.get(KEY_HTTPS_REQUIRED);
        this.certAuthentication = (Boolean)this.properties.get(KEY_CERT_AUTHENTICATION);
        this.allowCertAuthentication = this.configUtils.getBooleanConfigAttribute(this.properties, KEY_ALLOW_CERT_AUTHENTICATION, this.allowCertAuthentication);
        this.allowSpnegoAuthentication = this.configUtils.getBooleanConfigAttribute(this.properties, KEY_ALLOW_SPNEGO_AUTHENTICATION, this.allowSpnegoAuthentication);
        this.clientAdmin = (String)this.properties.get(KEY_CLIENT_ADMIN);
        this.coverageMapSessionMaxAge = (Long)this.properties.get(KEY_COVERAGE_MAP_SESSION_MAX_AGE);
        this.skipUserValidation = (Boolean)this.properties.get(KEY_SKIP_USER_VALIDATION);
        this.accessTokenEncoding = this.getAccessTokenEncodingFromConfig();
        this.schemaName = (String)this.properties.get(KEY_JDBC_SCHEMA);
        String[] buffer = (String[])this.properties.get(KEY_TOKEN_FORMAT);
        this.tokenFormat = buffer == null ? "unspecified" : buffer[0].toLowerCase();
        this.jwtAccessToken = (Boolean)this.properties.get(KEY_JWT_ACCESS_TOKEN);
        this.logoutRedirectURL = (String)this.properties.get(KEY_logoutRedirectURL);
        this.cacheAccessToken = (Boolean)this.properties.get(KEY_CACHE_ACCESSTOKEN);
        this.revokeAccessTokensWithRefreshTokens = (Boolean)this.properties.get(KEY_REVOKE_ACCESSTOK_W_REFRESHTOK);
        this.passwordGrantRequiresAppPassword = this.configUtils.getBooleanConfigAttribute(this.properties, KEY_PASSWORD_GRANT_REQUIRES_APP_PASSWORD, this.passwordGrantRequiresAppPassword);
        this.appPasswordLifetime = (Long)this.properties.get(KEY_APP_PASSWORD_LIFETIME);
        this.appTokenLifetime = (Long)this.properties.get(KEY_APP_TOKEN_LIFETIME);
        this.appTokenOrPasswordLimit = (Long)this.properties.get(KEY_APP_TOKEN_OR_PASSWORD_LIMIT);
        this.clientSecretEncoding = this.getClientSecretEncodingFromConfig();
        this.ropcPreferUserSecurityName = (Boolean)this.properties.get(KEY_ROPC_PREFER_USERSECURITYNAME);
        this.trackOAuthClients = (Boolean)this.properties.get(KEY_TRACK_OAUTH_CLIENTS);
        this.oauthEndpointSettings = this.populateOAuthEndpointSettings(this.properties, KEY_OAUTH_ENDPOINT);
        this.refreshedAccessTokenLimit = this.configUtils.getLongConfigAttribute(this.properties, KEY_REFRESHED_ACCESS_TOKEN_LIMIT, this.refreshedAccessTokenLimit);
        this.setUpInternalClient();
        if (this.tokenFormat.contains("unspecified")) {
            this.mpJwt = false;
        } else if (this.tokenFormat.contains("opaque")) {
            this.mpJwt = false;
            this.jwtAccessToken = false;
        } else if (this.tokenFormat.contains("mpjwt")) {
            this.mpJwt = true;
            this.jwtAccessToken = true;
        } else if (this.tokenFormat.contains("jwt")) {
            this.mpJwt = false;
            this.jwtAccessToken = true;
        } else {
            this.mpJwt = false;
        }
    }

    private String getAccessTokenEncodingFromConfig() {
        return (String)this.properties.get(KEY_STORE_ACCESSTOKEN_ENCODING);
    }

    private String getClientSecretEncodingFromConfig() {
        return (String)this.properties.get(KEY_CLIENT_SECRET_ENCODING);
    }

    private OAuthEndpointSettings populateOAuthEndpointSettings(Map<String, Object> configProps, String endpointSettingsElementName) {
        OAuthEndpointSettings endpointSettings = null;
        String[] endpointSettingsElementPids = this.configUtils.getStringArrayConfigAttribute(configProps, endpointSettingsElementName);
        if (endpointSettingsElementPids != null && endpointSettingsElementPids.length > 0) {
            endpointSettings = this.populateOAuthEndpointSettings(endpointSettingsElementPids);
        }
        return endpointSettings;
    }

    private OAuthEndpointSettings populateOAuthEndpointSettings(String[] endpointSettingsElementPids) {
        OAuthEndpointSettings endpointSettings = new OAuthEndpointSettings();
        for (String elementPid : endpointSettingsElementPids) {
            Configuration config = this.getConfigurationFromConfigAdmin(elementPid);
            endpointSettings.addOAuthEndpointSettings(config);
        }
        return endpointSettings;
    }

    Configuration getConfigurationFromConfigAdmin(String elementPid) {
        Configuration config = null;
        try {
            config = this.configAdmin.getConfiguration(elementPid, "");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"533", (Object)this, (Object[])new Object[]{elementPid});
        }
        return config;
    }

    void setUpInternalClient() {
        this.setUpInternalClientId();
        this.setUpInternalClientSecret();
    }

    private void setUpInternalClientId() {
        this.internalClientId = this.configUtils.getConfigAttribute(this.properties, KEY_INTERNAL_CLIENT_ID);
    }

    private void setUpInternalClientSecret() {
        Object o = this.properties.get(KEY_INTERNAL_CLIENT_SECRET);
        this.internalClientSecret = o != null ? (o instanceof SerializableProtectedString ? new String(((SerializableProtectedString)o).getChars()) : (String)o) : null;
    }

    void handlePatterns() {
        this.iHttps = 0;
        this.iSubOidcOauth = 0;
        this.iIndepends = 0;
        this.handlePattern(this.authorizationFormTemplate);
        this.handlePattern(this.authorizationErrorTemplate);
        this.handlePattern(this.customLoginURL);
        this.subOidcOauth[this.iSubOidcOauth++] = "scripts/oauthForm.js";
        String patterns = null;
        StringBuffer patternOidcOauth = new StringBuffer("(oidc|oauth2)/(");
        for (int iI = 0; iI < this.iSubOidcOauth; ++iI) {
            if (iI > 0) {
                patternOidcOauth.append("|");
            }
            patternOidcOauth.append(this.subOidcOauth[iI]);
        }
        patternOidcOauth.append(")");
        if (this.iIndepends > 0) {
            StringBuffer patternIndepends = new StringBuffer("");
            for (int iI = 0; iI < this.iIndepends; ++iI) {
                if (iI > 0) {
                    patternIndepends.append("|");
                }
                patternIndepends.append(this.independs[iI]);
            }
            patterns = "(/" + patternOidcOauth.toString() + ")|(" + patternIndepends.toString() + ")";
        } else {
            patterns = "/" + patternOidcOauth.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Misc URI patterns: '" + patterns + "'"), (Object[])new Object[0]);
        }
        this.patternOauthOidc = Pattern.compile(patterns);
    }

    void handlePattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        if (pattern.startsWith("http")) {
            this.https[this.iHttps++] = pattern;
        } else if (pattern.startsWith("/")) {
            this.independs[this.iIndepends++] = pattern;
        } else {
            this.subOidcOauth[this.iSubOidcOauth++] = pattern;
        }
    }

    protected int getProperty(String keyCode, int iMin, int iMax) {
        long result = (Long)this.properties.get(keyCode);
        if (result < (long)iMin) {
            Tr.info((TraceComponent)tc, (String)"OAUTH_LENGTH_TOO_SMALL_AND_CHANGED", (Object[])new Object[]{result, iMin});
            result = iMin;
        }
        if (result > (long)iMax) {
            Tr.info((TraceComponent)tc, (String)"OAUTH_LENGTH_TOO_LARGE_AND_CHANGED", (Object[])new Object[]{result, iMax});
            result = iMax;
        }
        return (int)result;
    }

    @Modified
    protected void modify(ComponentContext cc, Map<String, Object> properties) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("modifying provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.removeClients();
            this.invalidateProvider();
            this.properties = properties;
            this.setupFields();
            this.processProviderConfig();
            this.validateConfig();
            this.resetCoreClassesObjects();
            this.loadAuthFormTemplate(cc);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void resetCoreClassesObjects() {
        this.needToCreateCoreClasses = true;
        this.createCoreClasses();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, Map<String, Object> properties) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deactivating provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.removeClients();
            this.invalidateProvider();
            this.providerId = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="configurationAdmin", service=ConfigurationAdmin.class, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationAdmin(ConfigurationAdmin admin) {
        this.writeLock.lock();
        try {
            this.configAdmin = admin;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin admin) {
        this.writeLock.lock();
        try {
            this.configAdmin = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="classLoadingSvc", service=ClassLoadingService.class)
    protected void setClassLoadingSvc(ClassLoadingService cls) {
        this.writeLock.lock();
        try {
            this.classLoadingSvc = cls;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetClassLoadingSvc(ClassLoadingService cls) {
        this.writeLock.lock();
        try {
            this.classLoadingSvc = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="sharedLib", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setSharedLib(Library lib) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setSharedLib for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.sharedLib = lib;
            if (this.providerId != null) {
                this.invalidateProvider();
                this.checkForSharedLib = true;
                this.validateConfig();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetSharedLib(Library lib) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetSharedLib for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.sharedLib = null;
            if (this.providerId != null) {
                this.invalidateProvider();
                this.checkForSharedLib = true;
                this.validateConfig();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="dataSourceFactory", service=ResourceFactory.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setDataSourceFactory(ResourceFactory factory) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setDataSource for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.dataSourceFactory = factory;
            if (this.providerId != null) {
                this.removeClients();
                this.invalidateProvider();
                this.checkForSharedLib = true;
                this.checkForDataSource = true;
                this.validateConfig();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetDataSourceFactory(ResourceFactory factory) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetDataSource for provider: " + this.providerId), (Object[])new Object[0]);
            }
            if (factory == this.dataSourceFactory) {
                this.dataSourceFactory = null;
                if (this.providerId != null) {
                    this.removeClients();
                    this.invalidateProvider();
                    this.checkForDataSource = true;
                    this.validateConfig();
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetDataSource - wrong ResourceFactory for provider: " + this.providerId), (Object[])new Object[0]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="resourceConfigFactory", service=ResourceConfigFactory.class)
    protected void setResourceConfigFactory(ResourceConfigFactory svc) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setResourceConfigFactory for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.resourceConfigFactory = svc;
            if (this.providerId != null) {
                this.removeClients();
                this.invalidateProvider();
                this.checkForDataSource = true;
                this.validateConfig();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetResourceConfigFactory(ResourceConfigFactory svc) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetResourceConfigFactory for provider: " + this.providerId), (Object[])new Object[0]);
            }
            if (svc == this.resourceConfigFactory) {
                this.resourceConfigFactory = null;
                if (this.providerId != null) {
                    this.removeClients();
                    this.invalidateProvider();
                    this.checkForDataSource = true;
                    this.validateConfig();
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetResourceConfigFactory - wrong ResourceConfigFactory for provider: " + this.providerId), (Object[])new Object[0]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="oidcServer", service=OidcServer.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setOidcServer(ServiceReference<OidcServer> oidcServerRef) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setOidcServer for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.grantTypeHandlerFactoryClassname = "com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerFactoryImpl";
            this.responseTypeHandlerFactoryClassname = "com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerFactoryImpl";
            this.idTokenTypeHandlerClassname = "com.ibm.ws.security.openidconnect.server.plugins.IDTokenHandler";
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetOidcServer(ServiceReference<OidcServer> oidcServerRef) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetOidcServer for provider: " + this.providerId), (Object[])new Object[0]);
            }
            this.grantTypeHandlerFactoryClassname = null;
            this.responseTypeHandlerFactoryClassname = null;
            this.idTokenTypeHandlerClassname = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setSecurityService(SecurityService securityService) {
        this.writeLock.lock();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setSecurityService: " + this.providerId + ":" + securityService), (Object[])new Object[0]);
            }
            if (this.providerId != null) {
                ConfigUtils.addSecurityService(this.providerId, securityService);
            }
            this.securityService = securityService;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetSecurityService(SecurityService securityService) {
        this.writeLock.lock();
        try {
            if (this.securityService == securityService) {
                this.securityService = null;
                ConfigUtils.removeSecurityService(this.providerId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Reference(name="executorService", service=ExecutorService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setExecutorService(ExecutorService executorService) {
        this.writeLock.lock();
        try {
            this.executorService = executorService;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this.writeLock.lock();
        try {
            if (this.executorService == executorService) {
                this.executorService = null;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void configurationEvent(ConfigurationEvent event) {
        this.writeLock.lock();
        try {
            if (event.getType() == 1 && this.pids.contains(event.getPid())) {
                this.processProviderConfig();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void processProviderConfig() {
        this.writeLock.lock();
        try {
            this.clientsList = ConfigUtils.getClients();
            this.pids.clear();
            this.parameters = new ArrayList();
            Object mediatorClassnameArray = this.properties.get(KEY_MED_CLASS_NAMES);
            if (mediatorClassnameArray != null) {
                String[] mediatorClassNames = (String[])mediatorClassnameArray;
                this.mediatorClassname = mediatorClassNames[0];
                if (mediatorClassNames.length > 1 || !this.mediatorClassname.equals("com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator")) {
                    this.checkForSharedLib = true;
                }
            } else {
                this.mediatorClassname = null;
            }
            this.loadProviderParams();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void validateConfig() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validateConfig entry \n  checkForDataSource: " + this.checkForDataSource + "\n  checkForSharedLib: " + this.checkForSharedLib + "\n  dataSourceFactory: " + this.dataSourceFactory + "\n  resourceConfigFactory: " + this.resourceConfigFactory + "\n  mediatorClassname: " + this.mediatorClassname + "\n  sharedLib: " + this.sharedLib + "\n  isValid: " + this.isValid), (Object[])new Object[0]);
        }
        if (this.checkForDataSource) {
            if (!this.isDatabaseStore) {
                this.checkForDataSource = false;
            } else if (this.dataSourceFactory != null && this.resourceConfigFactory != null) {
                this.checkForDataSource = false;
            }
        }
        if (this.checkForSharedLib) {
            if (this.mediatorClassname == null) {
                this.checkForSharedLib = false;
                this.setSharedLibClassLoader();
            } else if (this.sharedLib != null) {
                this.checkForSharedLib = false;
                this.setSharedLibClassLoader();
            }
        }
        if (!this.checkForDataSource && !this.checkForSharedLib) {
            if (!this.isValid) {
                Tr.info((TraceComponent)tc, (String)"OAUTH_PROVIDER_CONFIG_PROCESSED", (Object[])new Object[]{this.providerId});
            }
            this.isValid = true;
        } else {
            if (this.isValid) {
                Tr.info((TraceComponent)tc, (String)"OAUTH_PROVIDER_CONFIG_INVALID", (Object[])new Object[]{this.providerId});
            }
            this.isValid = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validateConfig exit \n  checkForDataSource: " + this.checkForDataSource + "\n  checkForSharedLib: " + this.checkForSharedLib + "\n  dataSourceFactory: " + this.dataSourceFactory + "\n  resourceConfigFactory: " + this.resourceConfigFactory + "\n  mediatorClassname: " + this.mediatorClassname + "\n  sharedLib: " + this.sharedLib + "\n  isValid: " + this.isValid), (Object[])new Object[0]);
        }
    }

    private void processJwtGrantTypeConfig() {
        Configuration config;
        block8: {
            String[] jwtGrantTypes = (String[])this.properties.get("jwtGrantType");
            config = null;
            if (jwtGrantTypes != null && jwtGrantTypes.length > 0) {
                String jwtGrantType = jwtGrantTypes[0];
                try {
                    config = this.configAdmin.getConfiguration(jwtGrantType, this.bundleLocation);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1062", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"Invalid Jwt Grant Type:", (Object[])new Object[]{jwtGrantType});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Config of jwtGrantType", (Object[])new Object[]{config});
        }
        if (config != null) {
            Dictionary props = config.getProperties();
            if (props != null) {
                this.jwtMaxJtiCacheSize = (Long)props.get(KEY_JWT_MAX_JTI_CACHE_SIZE);
                this.jwtSkew = (Long)props.get(KEY_JWT_SKEW);
                this.jwtTokenMaxLifetime = (Long)props.get(KEY_JWT_TOKEN_MAX_LIFETIME);
                this.jwtIatRequired = (Boolean)props.get(KEY_JWT_IAT_REQUIRED);
            } else {
                this.resetJwtProps();
            }
        } else {
            this.resetJwtProps();
        }
    }

    private void resetJwtProps() {
        this.jwtMaxJtiCacheSize = 10000L;
        this.jwtSkew = 300L;
        this.jwtTokenMaxLifetime = 7200L;
        this.jwtIatRequired = false;
    }

    private void processClientConfig() {
        String customStore = (String)this.properties.get("customStore.0.storeId");
        String[] localStores = (String[])this.properties.get("localStore");
        this.isCustomStore = customStore != null;
        boolean bl = this.isLocalStore = !this.isCustomStore && localStores != null && localStores.length > 0;
        if (this.isCustomStore) {
            Map<String, Object> customStoreProps;
            List<Map<String, Object>> listOfPropMaps;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using customStore in provider " + this.providerId), (Object[])new Object[0]);
            }
            if (!(listOfPropMaps = Nester.nest("customStore", this.properties)).isEmpty() && (customStoreProps = listOfPropMaps.get(0)) != null) {
                this.cleanupInterval = (Long)customStoreProps.get(KEY_CUSTOM_CLEANUP_INT);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)KEY_CUSTOM_CLEANUP_INT, (Object[])new Object[]{this.cleanupInterval});
                }
                if (this.cleanupInterval != null && (this.cleanupInterval < 0L || this.cleanupInterval > Integer.MAX_VALUE)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The cleanupExpiredInterval spedified by the customStore in the " + this.providerId + " is invalid. The acceptable value is 0 to 2,147,483,647."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"OAUTH_PROVIDER_CUSTOMSTORE_INVALID_ATTRIBUTE", (Object[])new Object[]{this.providerId, KEY_CUSTOM_CLEANUP_INT});
                }
                if (this.cleanupInterval == null) {
                    this.cleanupInterval = new Long(3600L);
                }
            }
        } else if (this.isLocalStore) {
            this.processLocalStoreConfig(localStores[0]);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No localStore in provider " + this.providerId), (Object[])new Object[0]);
            }
            List<Map<String, Object>> listOfPropMaps = Nester.nest("databaseStore", this.properties);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("listOfPropMaps: " + listOfPropMaps), (Object[])new Object[0]);
            }
            if (!listOfPropMaps.isEmpty()) {
                this.isDatabaseStore = true;
                this.checkForDataSource = true;
                this.processDatabaseStoreConfig(listOfPropMaps);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No databaseStore in the provider " + this.providerId), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processLocalStoreConfig(String localStore) {
        String[] stringArray;
        this.pids.add(localStore);
        Configuration config = null;
        try {
            config = this.configAdmin.getConfiguration(localStore, this.bundleLocation);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1160", (Object)this, (Object[])new Object[]{localStore});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid oauth localStore configuration", (Object[])new Object[]{localStore});
            }
            return;
        }
        Dictionary localStoreProps = config.getProperties();
        this.tokenStoreSize = (Long)localStoreProps.get(KEY_TOK_STORE_SIZE);
        if (this.tokenStoreSize == null) {
            this.tokenStoreSize = new Long(2000L);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("tokenStoreSize " + this.tokenStoreSize), (Object[])new Object[0]);
        }
        if (this.clientURISubstitutions != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.clientURISubstitutions;
        } else {
            stringArray = null;
        }
        this.providerRewrites = stringArray;
        String[] clients = (String[])localStoreProps.get("client");
        if (clients == null || clients.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No oauth clients were defined in the provider. ", (Object[])new Object[0]);
            }
        } else {
            for (String clientPid : clients) {
                OidcBaseClient validatedClient;
                OidcBaseClient newClient;
                block16: {
                    this.pids.add(clientPid);
                    Configuration clientConfig = null;
                    try {
                        clientConfig = this.configAdmin.getConfiguration(clientPid, this.bundleLocation);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1189", (Object)this, (Object[])new Object[]{localStore});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Invalid oauth client configuration", (Object[])new Object[]{clientPid});
                        continue;
                    }
                    if (clientConfig == null || clientConfig.getProperties() == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"NULL oauth client configuration", (Object[])new Object[]{clientPid});
                        continue;
                    }
                    newClient = this.getClientFromLocalStore(clientConfig.getProperties());
                    newClient.setClientSecret(PasswordUtil.passwordDecode((String)newClient.getClientSecret()));
                    validatedClient = newClient;
                    try {
                        validatedClient = OidcBaseClientValidator.getInstance(validatedClient).validateCreateUpdate();
                    }
                    catch (OidcServerException oidcServerException) {
                        void e;
                        FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1212", (Object)this, (Object[])new Object[]{localStore});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                        String errorPrefix = "ClientId: " + (OidcOAuth20Util.isNullEmpty(validatedClient.getClientId()) ? "Unknown" : validatedClient.getClientId()) + ", Provider: " + this.providerId + ", ";
                        Tr.debug((TraceComponent)tc, (String)(errorPrefix + e.getErrorDescription()), (Object[])new Object[]{clientPid});
                    }
                }
                validatedClient.setEnabled(newClient.isEnabled());
                validatedClient.setComponentId(this.providerId);
                this.clientsList.add(validatedClient);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Added client: " + validatedClient.getClientId() + " for provider: " + this.providerId), (Object[])new Object[0]);
            }
        }
    }

    private OidcBaseClient getClientFromLocalStore(Dictionary<String, Object> props) {
        Object o = props.get(KEY_CLIENT_SECRET);
        String secret = o != null ? (o instanceof SerializableProtectedString ? new String(((SerializableProtectedString)o).getChars()) : (String)o) : null;
        OidcBaseClient newClient = new OidcBaseClient((String)props.get(KEY_CLIENT_ID), secret, OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_REDIRECT)), (String)props.get(KEY_CLIENT_DISPLAYNAME), this.providerId, (boolean)((Boolean)props.get(KEY_CLIENT_ENABLED)));
        newClient.setTokenEndpointAuthMethod((String)props.get(KEY_CLIENT_TOKEN_EP_AUTH_METHOD));
        newClient.setScope((String)props.get(KEY_CLIENT_SCOPE));
        newClient.setGrantTypes(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_GRANT_TYPES)));
        newClient.setResponseTypes(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_RESPONSE_TYPES)));
        newClient.setApplicationType((String)props.get(KEY_CLIENT_APP_TYPE));
        newClient.setSubjectType((String)props.get(KEY_CLIENT_SUBJECT_TYPE));
        newClient.setPostLogoutRedirectUris(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_POST_LOGOUT_REDIRECT_URIS)));
        newClient.setPreAuthorizedScope((String)props.get(KEY_CLIENT_PREAUTHORIZED_SCOPE));
        newClient.setIntrospectTokens((Boolean)props.get(KEY_CLIENT_INTROSPECT_TOKENS));
        newClient.setAllowRegexpRedirects((Boolean)props.get(KEY_CLIENT_allowRegexpRedirects));
        newClient.setTrustedUriPrefixes(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_TRUSTED_URI_PREFIXES)));
        newClient.setResourceIds(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_RESOURCE_IDS)));
        newClient.setFunctionalUserId((String)props.get(KEY_CLIENT_FUNCTIONAL_USER_ID));
        newClient.setFunctionalUserGroupIds(OidcOAuth20Util.initJsonArray((String[])props.get(KEY_CLIENT_FUNCTIONAL_USER_GROUPIDS)));
        newClient.setAppPasswordAllowed((Boolean)props.get(KEY_CLIENT_APP_PASSWORD_ALLOWED));
        newClient.setAppTokenAllowed((Boolean)props.get(KEY_CLIENT_APP_TOKEN_ALLOWED));
        newClient.setProofKeyForCodeExchange((Boolean)props.get(KEY_CLIENT_PROOF_KEY_FOR_CODE_EXCHANGE));
        boolean publicClient = false;
        if (props.get(KEY_CLIENT_PUBLIC_CLIENT) != null) {
            publicClient = (Boolean)props.get(KEY_CLIENT_PUBLIC_CLIENT);
        }
        newClient.setPublicClient(publicClient);
        return newClient;
    }

    private void processDatabaseStoreConfig(List<Map<String, Object>> listOfPropMaps) {
        Map<String, Object> databaseStoreProps = listOfPropMaps.get(0);
        if (databaseStoreProps != null) {
            String[] stringArray;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("databaseStore elementProps for " + this.providerId + ": " + databaseStoreProps), (Object[])new Object[0]);
            }
            this.cleanupInterval = (Long)databaseStoreProps.get(KEY_JDBC_CLEANUP_INT);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)KEY_JDBC_CLEANUP_INT, (Object[])new Object[]{this.cleanupInterval});
            }
            if (this.cleanupInterval != null && (this.cleanupInterval < 0L || this.cleanupInterval > Integer.MAX_VALUE)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The cleanupExpiredTokenInterval spedified by the databaseStore in the " + this.providerId + " is invalid. The acceptable value is 0 to 2,147,483,647."), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"OAUTH_PROVIDER_DATABASESTORE_INVALID_ATTRIBUTE", (Object[])new Object[]{this.providerId, KEY_JDBC_CLEANUP_INT});
            }
            if (this.cleanupInterval == null) {
                this.cleanupInterval = new Long(3600L);
            }
            this.limitRefreshToken = (Boolean)databaseStoreProps.get(KEY_JDBC_LIM_REF_TOK);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)KEY_JDBC_LIM_REF_TOK, (Object[])new Object[]{this.limitRefreshToken});
            }
            if (this.limitRefreshToken == null) {
                this.limitRefreshToken = true;
            }
            SerializableProtectedString password = null;
            Object o = databaseStoreProps.get(KEY_JDBC_PASSWORD);
            if (o != null) {
                password = o instanceof SerializableProtectedString ? (SerializableProtectedString)o : new SerializableProtectedString(((String)o).toCharArray());
            }
            String user = (String)databaseStoreProps.get(KEY_JDBC_USER);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user password", (Object[])new Object[]{user, password});
            }
            if (user != null || password != null) {
                this.credentials = new Object[]{user, password};
            }
            this.schemaName = (String)databaseStoreProps.get(KEY_JDBC_SCHEMA);
            if (this.clientURISubstitutions != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.clientURISubstitutions;
            } else {
                stringArray = null;
            }
            this.providerRewrites = stringArray;
            String[] dataSourceRef = (String[])databaseStoreProps.get(KEY_JDBC_DATASOURCEREF);
            if (dataSourceRef == null || dataSourceRef.length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("dataSourceRef in " + this.providerId + " is null."), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"OAUTH_PROVIDER_DATABASESTORE_INVALID_DATASOURCEREF", (Object[])new Object[]{this.providerId});
            }
        }
    }

    private void loadProviderParams() {
        this.processJwtGrantTypeConfig();
        this.processClientConfig();
    }

    private void setSharedLibClassLoader() {
        if (this.sharedLib != null) {
            this.pluginClassLoader = this.classLoadingSvc.getSharedLibraryClassLoader(this.sharedLib);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cl: " + this.pluginClassLoader), (Object[])new Object[0]);
            }
            if (this.mediatorClassname != null) {
                Tr.info((TraceComponent)tc, (String)"OAUTH_PROVIDER_CONFIG_MEDIATOR_LIBRARYREF_ACTIVE", (Object[])new Object[]{this.providerId, this.mediatorClassname});
            }
        } else {
            this.pluginClassLoader = null;
            if (this.mediatorClassname != null) {
                Tr.info((TraceComponent)tc, (String)"OAUTH_PROVIDER_CONFIG_NO_LIBRARYREF", (Object[])new Object[]{this.providerId});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeClients() {
        if (this.isLocalStore) {
            block8: {
                OidcBaseClientProvider clientProvider = (OidcBaseClientProvider)this.getClientProvider();
                if (clientProvider != null) {
                    Collection<OidcBaseClient> clients;
                    block7: {
                        clients = null;
                        try {
                            clients = clientProvider.getAll();
                        }
                        catch (OidcServerException oidcServerException) {
                            void e;
                            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1378", (Object)this, (Object[])new Object[0]);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                            Tr.debug((TraceComponent)tc, (String)("Exception getting all clients from localstore while trying to removing clients:" + e), (Object[])new Object[0]);
                        }
                    }
                    try {
                        for (OidcBaseClient client : clients) {
                            clientProvider.deleteOverride(client.getClientId());
                        }
                    }
                    catch (OidcServerException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1389", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)e.getErrorDescription(), (Object[])new Object[0]);
                    }
                }
            }
            ConfigUtils.deleteClients(this.providerId);
        }
    }

    private void invalidateProvider() {
        if (this.providerId != null) {
            this.pluginClassLoader = null;
            if (this.consentCache != null) {
                this.consentCache.stopCleanupThread();
            }
            if (this.tokenCache != null) {
                this.tokenCache.stopCleanupThread();
            }
            this.isValid = false;
        }
    }

    @Override
    public OAuth20Component getComponent() {
        this.readLock.lock();
        try {
            OAuth20Component oAuth20Component = this.component;
            return oAuth20Component;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getID() {
        this.readLock.lock();
        try {
            String string = this.providerId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OidcOAuth20ClientProvider getClientProvider() {
        this.readLock.lock();
        try {
            OidcOAuth20ClientProvider oidcOAuth20ClientProvider = this.clientProvider;
            return oidcOAuth20ClientProvider;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20EnhancedTokenCache getTokenCache() {
        this.readLock.lock();
        try {
            OAuth20EnhancedTokenCache oAuth20EnhancedTokenCache = this.tokenCache;
            return oAuth20EnhancedTokenCache;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OauthConsentStore getConsentCache() {
        this.readLock.lock();
        try {
            OauthConsentStore oauthConsentStore = this.consentCache;
            return oauthConsentStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createCoreClasses() {
        if (!this.needToCreateCoreClasses) {
            return;
        }
        this.writeLock.lock();
        try {
            if (this.isValid && this.needToCreateCoreClasses) {
                this.createComponentConfiguration();
                this.createInitializedStores(this.providerConfig);
                this.createCommonComponentRuntime(this.providerConfig);
                this.needToCreateCoreClasses = false;
            }
        }
        catch (OAuthProviderException oAuthProviderException) {
            FFDCFilter.processException((Throwable)oAuthProviderException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1484", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Exception creating the OAuth20 common component configuration: " + e), (Object[])new Object[0]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void createComponentConfiguration() {
        this.providerConfig = new OAuth20ComponentConfigurationImpl(this.providerId, this.parameters, this.pluginClassLoader);
    }

    /*
     * WARNING - void declaration
     */
    private void createCommonComponentRuntime(OAuthComponentConfiguration providerConfig) throws OAuthProviderException {
        try {
            this.createTokenTypeHandler();
            this.createIDTokenTypeHandler();
            this.createGrantTypeHandlerFactory();
            this.createResponseTypeHandlerFactory();
            this.createMediators();
            this.processGrantTypes();
            this.component = new OAuth20ComponentImpl(this, providerConfig, this);
        }
        catch (OAuthException oAuthException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthException, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1507", (Object)this, (Object[])new Object[]{providerConfig});
            throw new OAuthProviderException((Exception)e);
        }
    }

    private void createInitializedStores(OAuthComponentConfiguration providerConfig) throws OAuthProviderException {
        this.clientProvider = null;
        this.tokenCache = null;
        this.consentCache = null;
        if (this.isCustomStore) {
            this.createCustomStores();
        } else if (this.isLocalStore) {
            this.createLocalStores();
        } else {
            this.createDatabaseStores();
        }
        if (this.clientProvider != null) {
            this.clientProvider.initialize();
        }
        if (this.tokenCache != null) {
            this.tokenCache.initialize();
        }
        if (this.consentCache != null) {
            this.consentCache.initialize();
        }
    }

    private void createCustomStores() {
        OAuthStore oauthStore = this.iOAuthStoreRef.get();
        if (oauthStore != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Custom store is enabled: " + oauthStore.getClass().getName()), (Object[])new Object[0]);
            }
            this.clientProvider = new OauthClientStore(this.providerId, oauthStore, this.clientSecretEncoding);
            this.tokenCache = new OauthTokenStore(this.providerId, oauthStore, this.cleanupInterval * 1000L, this.getAccessTokenEncoding(), this.getAccessTokenLength());
            this.consentCache = new OauthConsentStoreImpl(this.providerId, oauthStore, this.cleanupInterval * 1000L);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The custom store service reference has not been registered with this OAuth provider.", (Object[])new Object[0]);
        }
    }

    private void createLocalStores() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Local store is enabled.", (Object[])new Object[0]);
        }
        this.clientProvider = new OidcBaseClientProvider(this.providerId, this.providerRewrites);
        this.tokenCache = new BaseCache(this.tokenStoreSize.intValue(), this.getAccessTokenEncoding(), this.getAccessTokenLength());
    }

    /*
     * WARNING - void declaration
     */
    private void createDatabaseStores() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Database store is enabled.", (Object[])new Object[0]);
            }
            try {
                ResourceConfig resourceConfig = this.resourceConfigFactory.createResourceConfig(DataSource.class.getName());
                resourceConfig.setResAuthType(0);
                if (this.dataSourceFactory == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("dataSourceFactory in " + this.providerId + " is null."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"OAUTH_PROVIDER_DATABASESTORE_INVALID_DATASOURCEFACTORY", (Object[])new Object[]{this.providerId});
                    throw new OAuthProviderException("OAUTH_PROVIDER_DATABASESTORE_INVALID_DATASOURCEFACTORY");
                }
                DataSource dataSource = (DataSource)this.dataSourceFactory.createResource((ResourceInfo)resourceConfig);
                this.clientProvider = new CachedDBOidcClientProvider(this.providerId, dataSource, this.getSchemaName() + VALUE_DB_CLIENT_TABLE, this.credentials, null, this.providerRewrites, this.clientSecretEncoding);
                this.tokenCache = new CachedDBOidcTokenStore(this.providerId, this.executorService, dataSource, this.getSchemaName() + VALUE_DB_TOKEN_TABLE, this.credentials, null, this.cleanupInterval.intValue(), 250, this.limitRefreshToken, this.getAccessTokenEncoding(), this.getAccessTokenLength());
                this.consentCache = new DBConsentCache(this.providerId, this.executorService, dataSource, this.getSchemaName() + CONSENT_CACHE_DB_TABLE, this.credentials, null, this.cleanupInterval.intValue(), 250);
            }
            catch (Exception resourceConfig) {
                void e;
                FFDCFilter.processException((Throwable)resourceConfig, (String)"com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider", (String)"1587", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Internal error accessing database store", (Object[])new Object[]{e});
            }
        }
    }

    private void setResourceProtectionFilter(String filter) {
        this.resourceProtectionFilter = filter != null ? new OAuthResourceProtectionFilter(filter, false) : new OAuthResourceProtectionFilter(false);
    }

    @Override
    public boolean isRequestAccepted(HttpServletRequest request) {
        return this.getResourceProtectionFilter().isAccepted(request);
    }

    private OAuthResourceProtectionFilter getResourceProtectionFilter() {
        return this.resourceProtectionFilter;
    }

    @Override
    public OAuthResult processResourceRequest(HttpServletRequest request) {
        this.readLock.lock();
        try {
            OAuthResult oAuthResult = this.component.processResourceRequest(request);
            return oAuthResult;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthResult processAuthorization(HttpServletRequest request, HttpServletResponse response, AttributeList options) {
        this.readLock.lock();
        try {
            OAuthResult oAuthResult = this.component.processAuthorization(request, response, options);
            return oAuthResult;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthResult processTokenRequest(String authenticatedClient, HttpServletRequest request, HttpServletResponse response) {
        this.readLock.lock();
        try {
            OAuthResult oAuthResult = this.component.processTokenRequest(authenticatedClient, request, response);
            return oAuthResult;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getAuthorizationGrantLifetime() {
        this.readLock.lock();
        try {
            long l = this.authorizationGrantLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getAuthorizationCodeLifetime() {
        this.readLock.lock();
        try {
            long l = this.authorizationCodeLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getAuthorizationCodeLength() {
        this.readLock.lock();
        try {
            int n = this.authorizationCodeLength;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getAccessTokenLifetime() {
        this.readLock.lock();
        try {
            long l = this.accessTokenLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getAccessTokenLength() {
        this.readLock.lock();
        try {
            int n = this.accessTokenLength;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isIssueRefreshToken() {
        this.readLock.lock();
        try {
            boolean bl = this.issueRefreshToken;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getRefreshTokenLength() {
        this.readLock.lock();
        try {
            int n = this.refreshTokenLength;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getRefreshedAccessTokenLimit() {
        this.readLock.lock();
        try {
            long l = this.refreshedAccessTokenLimit;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getMediatorClassname() {
        this.readLock.lock();
        try {
            String string = this.mediatorClassname;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isAllowPublicClients() {
        this.readLock.lock();
        try {
            boolean bl = this.allowPublicClients;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String[] getGrantTypesAllowed() {
        this.readLock.lock();
        try {
            if (this.grantTypesAllowed != null) {
                String[] stringArray = (String[])this.grantTypesAllowed.clone();
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAuthorizationFormTemplate() {
        this.readLock.lock();
        try {
            String string = this.authorizationFormTemplate;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAuthorizationErrorTemplate() {
        this.readLock.lock();
        try {
            String string = this.authorizationErrorTemplate;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getSchemaName() {
        this.readLock.lock();
        try {
            String string = this.schemaName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getCustomLoginURL() {
        this.readLock.lock();
        try {
            String string = this.customLoginURL;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAutoAuthorizeParam() {
        this.readLock.lock();
        try {
            String string = this.autoAuthorizeParam;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isAutoAuthorize() {
        this.readLock.lock();
        try {
            boolean bl = this.autoAuthorize;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String[] getAutoAuthorizeClients() {
        this.readLock.lock();
        try {
            if (this.autoAuthorizeClients != null) {
                String[] stringArray = (String[])this.autoAuthorizeClients.clone();
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getClientURISubstitutions() {
        this.readLock.lock();
        try {
            String string = this.clientURISubstitutions;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getClientTokenCacheSize() {
        this.readLock.lock();
        try {
            long l = this.clientTokenCacheSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getFilter() {
        this.readLock.lock();
        try {
            String string = this.filter;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getCharacterEncoding() {
        this.readLock.lock();
        try {
            String string = this.characterEncoding;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isOauthOnly() {
        this.readLock.lock();
        try {
            boolean bl = this.oauthOnly;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isIncludeTokenInSubject() {
        this.readLock.lock();
        try {
            boolean bl = this.includeTokenInSubject;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getConsentCacheEntryLifetime() {
        this.readLock.lock();
        try {
            long l = this.consentCacheEntryLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getConsentCacheSize() {
        this.readLock.lock();
        try {
            long l = this.consentCacheSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isHttpsRequired() {
        this.readLock.lock();
        try {
            boolean bl = this.httpsRequired;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isCertAuthentication() {
        this.readLock.lock();
        try {
            boolean bl = this.certAuthentication;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isAllowCertAuthentication() {
        this.readLock.lock();
        try {
            boolean bl = this.allowCertAuthentication;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isAllowSpnegoAuthentication() {
        this.readLock.lock();
        try {
            boolean bl = this.allowSpnegoAuthentication;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isSkipUserValidation() {
        this.readLock.lock();
        try {
            boolean bl = this.skipUserValidation;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getClientAdmin() {
        this.readLock.lock();
        try {
            String string = this.clientAdmin;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getJwtMaxJtiCacheSize() {
        this.readLock.lock();
        try {
            long l = this.jwtMaxJtiCacheSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getJwtClockSkew() {
        this.readLock.lock();
        try {
            long l = this.jwtSkew;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getJwtTokenMaxLifetime() {
        this.readLock.lock();
        try {
            long l = this.jwtTokenMaxLifetime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean getJwtIatRequired() {
        this.readLock.lock();
        try {
            boolean bl = this.jwtIatRequired;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getCoverageMapSessionMaxAge() {
        this.readLock.lock();
        try {
            long l = this.coverageMapSessionMaxAge;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getMaxAuthGrantLifetimeSeconds() {
        this.readLock.lock();
        try {
            int n = (int)this.authorizationGrantLifetime;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getCodeLifetimeSeconds() {
        this.readLock.lock();
        try {
            int n = (int)this.authorizationCodeLifetime;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getCodeLength() {
        this.readLock.lock();
        try {
            int n = this.authorizationCodeLength;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getTokenLifetimeSeconds() {
        this.readLock.lock();
        try {
            int n = (int)this.accessTokenLifetime;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20TokenTypeHandler getTokenTypeHandler() {
        this.readLock.lock();
        try {
            OAuth20TokenTypeHandler oAuth20TokenTypeHandler = this.tokenTypeHandler;
            return oAuth20TokenTypeHandler;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20TokenTypeHandler getIDTokenTypeHandler() {
        this.readLock.lock();
        try {
            OAuth20TokenTypeHandler oAuth20TokenTypeHandler = this.idTokenTypeHandler;
            return oAuth20TokenTypeHandler;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20GrantTypeHandlerFactory getGrantTypeHandlerFactory() {
        this.readLock.lock();
        try {
            OAuth20GrantTypeHandlerFactory oAuth20GrantTypeHandlerFactory = this.grantTypeHandlerFactory;
            return oAuth20GrantTypeHandlerFactory;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20ResponseTypeHandlerFactory getResponseTypeHandlerFactory() {
        this.readLock.lock();
        try {
            OAuth20ResponseTypeHandlerFactory oAuth20ResponseTypeHandlerFactory = this.responseTypeHandlerFactory;
            return oAuth20ResponseTypeHandlerFactory;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20Mediator getMediators() {
        this.readLock.lock();
        try {
            OAuth20Mediator oAuth20Mediator = this.mediator;
            return oAuth20Mediator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isGrantTypeAllowed(String grantType) {
        this.readLock.lock();
        try {
            boolean bl = this.finalGrantTypesAllowedSet.contains(grantType);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void createTokenTypeHandler() {
        this.tokenTypeHandler = new BaseTokenHandler();
    }

    private void createIDTokenTypeHandler() throws OAuthException {
        if (this.idTokenTypeHandlerClassname != null) {
            this.idTokenTypeHandler = "com.ibm.ws.security.openidconnect.server.plugins.IDTokenHandler".equals(this.idTokenTypeHandlerClassname) && oidcIDTokenHandler != null ? oidcIDTokenHandler : (OAuth20TokenTypeHandler)this.createInstance(this.idTokenTypeHandlerClassname, "oauth20.id.tokentypehandler.classname", OAuth20TokenTypeHandler.class);
        }
    }

    private void createGrantTypeHandlerFactory() throws OAuthException {
        if (this.grantTypeHandlerFactoryClassname != null) {
            this.grantTypeHandlerFactory = "com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerFactoryImpl".equals(this.grantTypeHandlerFactoryClassname) && oidcGrantTypeHandlerFactory != null ? oidcGrantTypeHandlerFactory : (OAuth20GrantTypeHandlerFactory)this.createInstance(this.grantTypeHandlerFactoryClassname, "oauth20.grant.type.handler.factory.classname", OAuth20GrantTypeHandlerFactory.class);
        }
    }

    private void createResponseTypeHandlerFactory() throws OAuthException {
        if (this.responseTypeHandlerFactoryClassname != null) {
            this.responseTypeHandlerFactory = "com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerFactoryImpl".equals(this.responseTypeHandlerFactoryClassname) && oidcResponseTypeHandlerFactory != null ? oidcResponseTypeHandlerFactory : (OAuth20ResponseTypeHandlerFactory)this.createInstance(this.responseTypeHandlerFactoryClassname, "oauth20.response.type.handler.factory.classname", OAuth20ResponseTypeHandlerFactory.class);
        }
    }

    private void createMediators() throws OAuthException {
        this.mediator = this.mediatorClassname == null ? new OAuth20MediatorDefaultImpl() : (OAuth20Mediator)this.createInstance(this.mediatorClassname, "oauth20.mediator.classnames", OAuth20Mediator.class);
    }

    private Object createInstance(String className, String configConstant, Class interfaceClass) throws OAuthException {
        ClassLoader cl = null;
        cl = !ConfigUtils.isBuiltinClass(className) ? this.pluginClassLoader : OAuth20ProviderUtils.class.getClassLoader();
        return OAuth20ProviderUtils.processClass(className, configConstant, interfaceClass, cl);
    }

    protected void processGrantTypes() throws OAuthException {
        if (this.grantTypesAllowed == null || this.grantTypesAllowed.length == 0) {
            throw new OAuthConfigurationException("security.oauth.error.config.notspecified.exception", "oauth20.grant.types.allowed", "null", null);
        }
        this.finalGrantTypesAllowedSet = new HashSet<String>();
        for (String name : this.grantTypesAllowed) {
            String[] grantTypesList;
            for (String grant : grantTypesList = name.split(",")) {
                if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(grant)) {
                    throw new OAuthConfigurationException("security.oauth.error.invalidconfig.exception", "oauth20.grant.types.allowed", name, null);
                }
                this.finalGrantTypesAllowedSet.add(grant);
            }
        }
    }

    @Override
    public OAuthAuditHandler getAuditHandler() {
        this.readLock.lock();
        try {
            OAuthAuditHandler oAuthAuditHandler = this.auditHandler;
            return oAuthAuditHandler;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getInstanceId() {
        this.readLock.lock();
        try {
            String string = this.providerId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public OAuth20Component getOAuth20Component() {
        this.readLock.lock();
        try {
            OAuth20Component oAuth20Component = this.component;
            return oAuth20Component;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isLocalStoreUsed() {
        return this.isLocalStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMiscUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        Matcher m = null;
        Pattern pattern = this.patternOauthOidc;
        synchronized (pattern) {
            m = this.patternOauthOidc.matcher(uri);
        }
        if (m.matches()) {
            return true;
        }
        if (this.iHttps > 0) {
            String url = request.getRequestURL().toString();
            for (int iI = 0; iI < this.iHttps; ++iI) {
                if (!url.equals(this.https[iI])) continue;
                return true;
            }
        }
        return false;
    }

    public static void setOidcIDTokenTypeHandler(OAuth20TokenTypeHandler handler) {
        oidcIDTokenHandler = handler;
    }

    public static void setOidcGrantTypeHandlerFactory(OAuth20GrantTypeHandlerFactory handler) {
        oidcGrantTypeHandlerFactory = handler;
    }

    public static void setOidcResponseTypeHandlerFactory(OAuth20ResponseTypeHandlerFactory handler) {
        oidcResponseTypeHandlerFactory = handler;
    }

    @Override
    public boolean isJwtAccessToken() {
        return this.jwtAccessToken;
    }

    @Override
    public byte[] getDefaultAuthorizationFormTemplateContent() {
        return this.authorizationFormTemplateContent == null ? null : (byte[])this.authorizationFormTemplateContent.clone();
    }

    @Override
    public boolean isMpJwt() {
        return this.mpJwt;
    }

    @Override
    public String getLogoutRedirectURL() {
        return this.logoutRedirectURL;
    }

    @Override
    public boolean cacheAccessToken() {
        return this.cacheAccessToken;
    }

    @Override
    public boolean getRevokeAccessTokensWithRefreshTokens() {
        return this.revokeAccessTokensWithRefreshTokens;
    }

    @Override
    public boolean isPasswordGrantRequiresAppPassword() {
        this.readLock.lock();
        try {
            boolean bl = this.passwordGrantRequiresAppPassword;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getAppPasswordLifetime() {
        return this.appPasswordLifetime;
    }

    @Override
    public long getAppTokenLifetime() {
        return this.appTokenLifetime;
    }

    @Override
    public long getAppTokenOrPasswordLimit() {
        return this.appTokenOrPasswordLimit;
    }

    public void serverStopping() {
        this.invalidateProvider();
    }

    @Override
    public String getInternalClientId() {
        return this.internalClientId;
    }

    @Override
    @Sensitive
    public String getInternalClientSecret() {
        return this.internalClientSecret;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setCustomStore(OAuthStore store) throws OAuthProviderException {
        this.iOAuthStoreRef.set(store);
        this.writeLock.lock();
        try {
            if (this.isCustomStore) {
                this.createInitializedStores(this.providerConfig);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unsetCustomStore(OAuthStore store) throws OAuthProviderException {
        boolean cleared = this.iOAuthStoreRef.compareAndSet(store, null);
        if (cleared) {
            this.writeLock.lock();
            try {
                this.createInitializedStores(this.providerConfig);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public String getAccessTokenEncoding() {
        return this.accessTokenEncoding;
    }

    @Override
    public boolean isROPCPreferUserSecurityName() {
        return this.ropcPreferUserSecurityName;
    }

    @Override
    public boolean isTrackOAuthClients() {
        return this.trackOAuthClients;
    }

    @Override
    public OAuthEndpointSettings getOAuthEndpointSettings() {
        return this.oauthEndpointSettings;
    }
}

