/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.token.impl;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.token.impl.WSOAuth20TokenImpl;
import com.ibm.ws.security.oauth20.util.UTC;
import com.ibm.wsspi.security.oauth20.token.WSOAuth20Token;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSOAuth20TokenHelper {
    static final long serialVersionUID = -2118137172451505472L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static WSOAuth20Token createToken(HttpServletRequest req, HttpServletResponse res, OAuthResult oResult, String providerName) {
        WSOAuth20TokenImpl oauthToken = new WSOAuth20TokenImpl();
        String token = null;
        String expireUTC = null;
        Date expire = null;
        AttributeList attributeList = oResult.getAttributeList();
        String clientId = attributeList.getAttributeValueByName("oauth_token_client_id");
        oauthToken.setClientID(clientId);
        String username = attributeList.getAttributeValueByName("username");
        oauthToken.setUser(username);
        String[] scope = attributeList.getAttributeValuesByName("scope");
        oauthToken.setScope(scope);
        token = attributeList.getAttributeValueByName("access_token");
        oauthToken.setTokenString(token);
        expireUTC = attributeList.getAttributeValueByName("expires");
        try {
            expire = UTC.parse(expireUTC);
            oauthToken.setExpirationTime(expire.getTime());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.token.impl.WSOAuth20TokenHelper", (String)"54", null, (Object[])new Object[]{req, res, oResult, providerName});
        }
        oauthToken.setProvider(providerName);
        int hash = token.hashCode();
        String cacheKey = new StringBuffer().append(providerName).append(hash).toString();
        oauthToken.setCacheKey(cacheKey);
        return oauthToken;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.token.impl.WSOAuth20TokenHelper", WSOAuth20TokenHelper.class, null, null);
    }
}

