/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class OXMSystemProperties {
    public static final String JSON_TYPE_COMPATIBILITY = "org.eclipse.persistence.json.type-compatibility";
    public static final String JSON_USE_XSD_TYPES_PREFIX = "org.eclipse.persistence.json.use-xsd-types-prefix";
    public static final Boolean jsonTypeCompatiblity = OXMSystemProperties.getBoolean("org.eclipse.persistence.json.type-compatibility");
    public static final Boolean jsonUseXsdTypesPrefix = OXMSystemProperties.getBoolean("org.eclipse.persistence.json.use-xsd-types-prefix");

    private OXMSystemProperties() {
    }

    private static Boolean getBoolean(final String propertyName) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        return Boolean.getBoolean(propertyName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (RuntimeException)e.getCause();
            }
        }
        return Boolean.getBoolean(propertyName);
    }
}

