/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http2.GrpcServletServices;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.servlet.ServletServerBuilder;
import io.openliberty.grpc.annotation.GrpcService;
import io.openliberty.grpc.internal.GrpcManagedObjectProvider;
import io.openliberty.grpc.internal.config.GrpcServiceConfigHolder;
import io.openliberty.grpc.internal.servlet.GrpcServerComponent;
import io.openliberty.grpc.internal.servlet.LibertyAuthorizationInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class GrpcServletUtils {
    private static final TraceComponent tc = Tr.register(GrpcServletUtils.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    private static final LibertyAuthorizationInterceptor authInterceptor = new LibertyAuthorizationInterceptor();
    static final long serialVersionUID = 4799053662055835155L;

    public static String translateLibertyPath(String requestPath) {
        int count = requestPath.length() - requestPath.replace("/", "").length();
        if (count == 2) {
            int index = requestPath.indexOf(47);
            requestPath = requestPath.substring(index + 1);
        }
        return requestPath;
    }

    public static Method getTargetMethod(String requestPath) {
        Class clazz;
        GrpcServletServices.ServiceInformation info;
        int index = requestPath.indexOf(47);
        String service = requestPath.substring(0, index);
        Map services = GrpcServletServices.getServletGrpcServices();
        if (services != null && (info = (GrpcServletServices.ServiceInformation)services.get(service)) != null && (clazz = info.getServiceClass()) != null) {
            Method[] methods;
            index = requestPath.indexOf(47);
            String methodName = requestPath.substring(index + 1);
            if (methodName.contains("_")) {
                methodName = GrpcServletUtils.convertToCamelCase(methodName);
            }
            for (Method m : methods = clazz.getMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void getServerXmlInterceptors(List<String> interceptorClassNames, List<ServerInterceptor> interceptors) {
        for (String className : interceptorClassNames) {
            try {
                ServerInterceptor interceptor = (ServerInterceptor)GrpcManagedObjectProvider.createObjectFromClassName(className);
                if (interceptor == null) continue;
                interceptors.add(interceptor);
            }
            catch (ManagedObjectException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException interceptor) {
                void e;
                FFDCFilter.processException((Throwable)interceptor, (String)"io.openliberty.grpc.internal.servlet.GrpcServletUtils", (String)"109", null, (Object[])new Object[]{interceptorClassNames, interceptors});
                Tr.warning((TraceComponent)tc, (String)"invalid.serverinterceptor", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void getAnnotationInterceptors(Class<? extends ServerInterceptor>[] annotationInterceptors, List<ServerInterceptor> interceptors) {
        for (Class<? extends ServerInterceptor> interceptorClass : annotationInterceptors) {
            try {
                ServerInterceptor interceptor = (ServerInterceptor)GrpcManagedObjectProvider.createObjectFromClass(interceptorClass);
                interceptors.add(interceptor);
            }
            catch (ManagedObjectException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.grpc.internal.servlet.GrpcServletUtils", (String)"127", null, (Object[])new Object[]{annotationInterceptors, interceptors});
                Tr.warning((TraceComponent)tc, (String)"invalid.serverinterceptor", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    private static List<ServerInterceptor> getUserInterceptors(String serviceName, BindableService service) {
        ArrayList<String> items;
        LinkedList<ServerInterceptor> interceptors = new LinkedList<ServerInterceptor>();
        String interceptorListString = GrpcServiceConfigHolder.getServiceInterceptors(serviceName);
        Class[] annotationInterceptors = null;
        if (service.getClass().getAnnotation(GrpcService.class) != null) {
            annotationInterceptors = service.getClass().getAnnotation(GrpcService.class).interceptors();
        }
        if (interceptorListString != null && (items = new ArrayList<String>(Arrays.asList(interceptorListString.split("\\s*,\\s*")))) != null && !items.isEmpty()) {
            if (annotationInterceptors != null) {
                for (Class clazz : annotationInterceptors) {
                    String className = clazz.getName();
                    if (!items.contains(className)) continue;
                    items.remove(className);
                }
            }
            GrpcServletUtils.getServerXmlInterceptors(items, interceptors);
        }
        if (annotationInterceptors != null && annotationInterceptors.length > 0) {
            GrpcServletUtils.getAnnotationInterceptors(annotationInterceptors, interceptors);
        }
        if (!interceptors.isEmpty()) {
            Collections.reverse(interceptors);
        }
        return interceptors;
    }

    public static void addServices(List<? extends BindableService> bindableServices, ServletServerBuilder serverBuilder, String appName) {
        for (BindableService bindableService : bindableServices) {
            String serviceName = bindableService.bindService().getServiceDescriptor().getName();
            List<ServerInterceptor> interceptors = GrpcServletUtils.getUserInterceptors(serviceName, bindableService);
            interceptors.add(authInterceptor);
            ServerInterceptor monitoringInterceptor = GrpcServletUtils.createMonitoringServerInterceptor(serviceName, appName);
            if (monitoringInterceptor != null) {
                interceptors.add(monitoringInterceptor);
            }
            serverBuilder.addService(ServerInterceptors.intercept((BindableService)bindableService, interceptors));
            int maxInboundMsgSize = GrpcServiceConfigHolder.getMaxInboundMessageSize(serviceName);
            if (maxInboundMsgSize != -1) {
                serverBuilder.maxInboundMessageSize(maxInboundMsgSize);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"gRPC service {0} has been registered", (Object[])new Object[]{serviceName});
        }
    }

    private static ServerInterceptor createMonitoringServerInterceptor(String serviceName, String appName) {
        ServerInterceptor interceptor = GrpcServerComponent.getMonitoringServerInterceptor(serviceName, appName);
        if (interceptor != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"monitoring interceptor has been added to service {0}", (Object[])new Object[]{serviceName});
        }
        return interceptor;
    }

    private static String convertToCamelCase(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        boolean firstSection = true;
        for (String section : name.split("_")) {
            if (section.isEmpty()) continue;
            if (firstSection) {
                firstSection = false;
                builder.append(Character.toLowerCase(section.charAt(0)));
            } else {
                builder.append(Character.toUpperCase(section.charAt(0)));
            }
            if (section.length() <= 1) continue;
            builder.append(section.substring(1));
        }
        return builder.toString();
    }
}

