/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.w3c.dom.Element;

public final class SAAJUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SAAJUtils.class);

    private SAAJUtils() {
    }

    public static SOAPHeader getHeader(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPHeader();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getHeader();
        }
    }

    public static SOAPBody getBody(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPBody();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getBody();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static void setFaultCode(SOAPFault f, QName code) throws SOAPException {
        try {
            f.setFaultCode(code);
        }
        catch (Throwable t) {
            int count = 1;
            String pfx = "fc1";
            while (!StringUtils.isEmpty((String)f.getNamespaceURI(pfx))) {
                pfx = "fc" + ++count;
            }
            String xmlNS = code.getNamespaceURI();
            if (xmlNS == null || xmlNS.length() == 0) {
                LOG.log(Level.FINE, "The prefix is: " + pfx + "  but there is no namespace.");
            } else {
                f.addNamespaceDeclaration(pfx, xmlNS);
            }
            f.setFaultCode(pfx + ":" + code.getLocalPart());
        }
    }

    public static Element adjustPrefix(Element e, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            String s = e.getPrefix();
            if (!prefix.equals(s)) {
                e.setPrefix(prefix);
                if (e instanceof SOAPElement) {
                    ((SOAPElement)e).removeNamespaceDeclaration(s);
                } else if (e.getClass().getName().equals("com.sun.org.apache.xerces.internal.dom.ElementNSImpl")) {
                    try {
                        Method method = e.getClass().getMethod("removeAttribute", String.class);
                        method.invoke((Object)e, "xmlns:" + s);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return e;
    }
}

