/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.collaborator;

import com.ibm.ws.webcontainer.collaborator.CollaboratorService;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.webcontainer.collaborator.IConnectionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInitializationCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInvocationCollaborator;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CollaboratorServiceImpl
implements CollaboratorService {
    private static final String DEFAULT_SECURITY_TYPE = "default";
    private static final String WEBAPP_SECURITY_COLLABORATOR = "webAppSecurityCollaborator";
    private static final String SECURITY_TYPE = "com.ibm.ws.security.type";
    private static final AtomicReference<CollaboratorServiceImpl> instance = new AtomicReference();
    private IWebAppTransactionCollaborator watcService;
    private final ConcurrentServiceReferenceMap<String, IWebAppSecurityCollaborator> webAppSecurityCollaborators = new ConcurrentServiceReferenceMap("webAppSecurityCollaborator");
    private IConnectionCollaborator ccServ;
    private final Set<WebAppInvocationCollaborator> webAppInvocationCollaborators = new CopyOnWriteArraySet<WebAppInvocationCollaborator>();
    private final Set<WebAppInitializationCollaborator> webAppInitializationCollaborator = new CopyOnWriteArraySet<WebAppInitializationCollaborator>();

    protected void activate(ComponentContext context) {
        this.webAppSecurityCollaborators.activate(context);
        instance.set(this);
    }

    protected void deactivate(ComponentContext context) {
        instance.compareAndSet(this, null);
    }

    public void setWebAppTransactionCollaborator(IWebAppTransactionCollaborator watc) {
        this.watcService = watc;
    }

    public void unsetWebAppTransactionCollaborator(IWebAppTransactionCollaborator watc) {
        if (watc == this.watcService) {
            this.watcService = null;
        }
    }

    public static IWebAppTransactionCollaborator getWebAppTransactionCollaborator() {
        CollaboratorServiceImpl thisService = instance.get();
        if (thisService != null) {
            return thisService.watcService;
        }
        return null;
    }

    public void setWebAppSecurityCollaborator(ServiceReference<IWebAppSecurityCollaborator> ref) {
        String securityType = this.getSecurityType(ref);
        this.webAppSecurityCollaborators.putReference((Object)securityType, ref);
    }

    private String getSecurityType(ServiceReference<IWebAppSecurityCollaborator> ref) {
        Object secTypeObj = ref.getProperty(SECURITY_TYPE);
        String securityType = null;
        if (secTypeObj instanceof String) {
            securityType = (String)secTypeObj;
        }
        if (securityType == null || securityType.length() == 0) {
            securityType = DEFAULT_SECURITY_TYPE;
        }
        return securityType;
    }

    public void unsetWebAppSecurityCollaborator(ServiceReference<IWebAppSecurityCollaborator> ref) {
        String securityType = this.getSecurityType(ref);
        this.webAppSecurityCollaborators.removeReference((Object)securityType, ref);
    }

    public static IWebAppSecurityCollaborator getWebAppSecurityCollaborator(String securityType) {
        IWebAppSecurityCollaborator collab = null;
        CollaboratorServiceImpl thisService = instance.get();
        if (securityType == null) {
            securityType = DEFAULT_SECURITY_TYPE;
        }
        if (!securityType.equals(DEFAULT_SECURITY_TYPE) && !securityType.equals("com.ibm.ws.management")) {
            securityType = "com.ibm.ws.feature";
        }
        if (thisService != null) {
            collab = (IWebAppSecurityCollaborator)thisService.webAppSecurityCollaborators.getService((Object)securityType);
        }
        return collab;
    }

    public void setWebAppConnectionCollaborator(IConnectionCollaborator cc) {
        this.ccServ = cc;
    }

    public void unsetWebAppConnectionCollaborator(IConnectionCollaborator cc) {
        if (this.ccServ == cc) {
            this.ccServ = null;
        }
    }

    public static IConnectionCollaborator getWebAppConnectionCollaborator() {
        CollaboratorServiceImpl thisService = instance.get();
        if (thisService != null) {
            return thisService.ccServ;
        }
        return null;
    }

    public void setWebAppInitializationCollaborator(WebAppInitializationCollaborator waic) {
        this.webAppInitializationCollaborator.add(waic);
    }

    public void unsetWebAppInitializationCollaborator(WebAppInitializationCollaborator waic) {
        this.webAppInitializationCollaborator.remove(waic);
    }

    public static Set<WebAppInitializationCollaborator> getWebAppInitializationCollaborator() {
        CollaboratorServiceImpl thisService = instance.get();
        if (thisService != null) {
            return Collections.unmodifiableSet(thisService.webAppInitializationCollaborator);
        }
        return null;
    }

    public void setWebAppInvocationCollaborator(WebAppInvocationCollaborator waic) {
        this.webAppInvocationCollaborators.add(waic);
    }

    public void unsetWebAppInvocationCollaborator(WebAppInvocationCollaborator waic) {
        this.webAppInvocationCollaborators.remove(waic);
    }

    public static Set<WebAppInvocationCollaborator> getWebAppInvocationCollaborators() {
        CollaboratorServiceImpl thisService = instance.get();
        if (thisService != null) {
            return Collections.unmodifiableSet(thisService.webAppInvocationCollaborators);
        }
        return null;
    }
}

