/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;

public class CommsByteBufferPool {
    private static final TraceComponent tc = SibTr.register(CommsByteBufferPool.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static CommsByteBufferPool instance = null;
    private ObjectPool pool = null;

    public static synchronized CommsByteBufferPool getInstance() {
        if (instance == null) {
            instance = new CommsByteBufferPool();
        }
        return instance;
    }

    protected CommsByteBufferPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.pool = new ObjectPool(this.getPoolName(), 100);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized CommsByteBuffer allocate() {
        CommsByteBuffer buff;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocate");
        }
        if ((buff = (CommsByteBuffer)this.pool.remove()) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No buffer available from pool - creating a new one");
            }
            buff = this.createNew();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocate", (Object)buff);
        }
        return buff;
    }

    protected CommsByteBuffer createNew() {
        return new CommsByteBuffer(this);
    }

    protected String getPoolName() {
        return "CommsByteBufferPool";
    }

    synchronized void release(CommsByteBuffer buff) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release", (Object)buff);
        }
        buff.reset();
        this.pool.add((Object)buff);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }
}

