/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BurstDateFormat {
    private final SimpleDateFormat formatter;
    private long refTimestamp = 0L;
    private String refBeginning;
    private String refEnding;
    private long refMilli = 0L;
    private long pdiff = 0L;
    private long ndiff = 0L;
    private final FieldPosition position = new FieldPosition(DateFormat.Field.MILLISECOND);
    boolean invalidFormat = false;
    private StringBuffer sb;

    public BurstDateFormat(SimpleDateFormat formatter) {
        this(formatter, BurstDateFormat.isFormatInvalid(formatter));
    }

    public BurstDateFormat(SimpleDateFormat formatter, boolean isInvalid) {
        this.formatter = formatter;
        this.invalidFormat = isInvalid;
        if (!this.invalidFormat) {
            this.sb = new StringBuffer();
        }
    }

    static boolean isFormatInvalid(SimpleDateFormat formatter) {
        FieldPosition position = new FieldPosition(DateFormat.Field.MILLISECOND);
        boolean invalidFormat = false;
        try {
            StringBuffer refTime = new StringBuffer();
            String pattern = formatter.toLocalizedPattern();
            if (pattern.lastIndexOf(83) - pattern.indexOf(83) != 2) {
                invalidFormat = true;
            }
            formatter.format(new Date().getTime(), refTime, position);
            if (position.getEndIndex() - position.getBeginIndex() != 3) {
                invalidFormat = true;
            }
            String str = refTime.substring(position.getBeginIndex(), position.getEndIndex());
            for (int i = str.length() - 1; i >= 0; --i) {
                char a = str.charAt(i);
                if (a >= '0' && a <= '9') continue;
                invalidFormat = true;
                break;
            }
        }
        catch (Exception e) {
            invalidFormat = true;
        }
        return invalidFormat;
    }

    public String format(long timestamp) {
        if (this.invalidFormat) {
            return this.formatter.format(timestamp);
        }
        try {
            long delta = timestamp - this.refTimestamp;
            this.sb.setLength(0);
            if (delta >= this.pdiff || delta < this.ndiff) {
                this.refTimestamp = timestamp;
                this.formatter.format(timestamp, this.sb, this.position);
                this.refMilli = Long.parseLong(this.sb.substring(this.position.getBeginIndex(), this.position.getEndIndex()));
                this.refBeginning = this.sb.substring(0, this.position.getBeginIndex());
                this.refEnding = this.sb.substring(this.position.getEndIndex());
                this.pdiff = 1000L - this.refMilli;
                this.ndiff = -this.refMilli;
                return this.sb.toString();
            }
            long newMilli = delta + this.refMilli;
            if (newMilli >= 100L) {
                this.sb.append(this.refBeginning).append(newMilli).append(this.refEnding);
            } else if (newMilli >= 10L) {
                this.sb.append(this.refBeginning).append('0').append(newMilli).append(this.refEnding);
            } else {
                this.sb.append(this.refBeginning).append("00").append(newMilli).append(this.refEnding);
            }
            return this.sb.toString();
        }
        catch (Exception e) {
            this.invalidFormat = true;
            this.sb = null;
            return this.formatter.format(timestamp);
        }
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.formatter;
    }
}

