/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.AssertException;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLScalarType;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.DirectiveIllegalArgumentTypeError;
import graphql.util.LogKit;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Internal
class ArgValueOfAllowedTypeChecker {
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ArgValueOfAllowedTypeChecker.class);
    private final Directive directive;
    private final Node element;
    private final String elementName;
    private final Argument argument;
    private final TypeDefinitionRegistry typeRegistry;
    private final RuntimeWiring runtimeWiring;

    ArgValueOfAllowedTypeChecker(Directive directive, Node element, String elementName, Argument argument, TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        this.directive = directive;
        this.element = element;
        this.elementName = elementName;
        this.argument = argument;
        this.typeRegistry = typeRegistry;
        this.runtimeWiring = runtimeWiring;
    }

    void checkArgValueMatchesAllowedType(List<GraphQLError> errors, Value instanceValue, Type allowedArgType) {
        if (allowedArgType instanceof TypeName) {
            this.checkArgValueMatchesAllowedTypeName(errors, instanceValue, allowedArgType);
        } else if (allowedArgType instanceof ListType) {
            this.checkArgValueMatchesAllowedListType(errors, instanceValue, (ListType)allowedArgType);
        } else if (allowedArgType instanceof NonNullType) {
            this.checkArgValueMatchesAllowedNonNullType(errors, instanceValue, (NonNullType)allowedArgType);
        } else {
            Assert.assertShouldNeverHappen("Unsupported Type '%s' was added. ", allowedArgType);
        }
    }

    private void addValidationError(List<GraphQLError> errors, String message, Object ... args) {
        errors.add(new DirectiveIllegalArgumentTypeError(this.element, this.elementName, this.directive.getName(), this.argument.getName(), String.format(message, args)));
    }

    private void checkArgValueMatchesAllowedTypeName(List<GraphQLError> errors, Value instanceValue, Type allowedArgType) {
        if (instanceValue instanceof NullValue) {
            return;
        }
        String allowedTypeName = ((TypeName)allowedArgType).getName();
        TypeDefinition allowedTypeDefinition = this.typeRegistry.getType(allowedTypeName).orElseThrow(() -> new AssertException("Directive unknown argument type '%s'. This should have been validated before."));
        if (allowedTypeDefinition instanceof ScalarTypeDefinition) {
            this.checkArgValueMatchesAllowedScalar(errors, instanceValue, allowedTypeName);
        } else if (allowedTypeDefinition instanceof EnumTypeDefinition) {
            this.checkArgValueMatchesAllowedEnum(errors, instanceValue, (EnumTypeDefinition)allowedTypeDefinition);
        } else if (allowedTypeDefinition instanceof InputObjectTypeDefinition) {
            this.checkArgValueMatchesAllowedInputType(errors, instanceValue, (InputObjectTypeDefinition)allowedTypeDefinition);
        } else {
            Assert.assertShouldNeverHappen("'%s' must be an input type. It is %s instead. ", allowedTypeName, allowedTypeDefinition.getClass());
        }
    }

    private void checkArgValueMatchesAllowedInputType(List<GraphQLError> errors, Value instanceValue, InputObjectTypeDefinition allowedTypeDefinition) {
        if (!(instanceValue instanceof ObjectValue)) {
            this.addValidationError(errors, "Argument value is of type '%s', expected an Object value.", instanceValue.getClass().getSimpleName());
            return;
        }
        ObjectValue objectValue = (ObjectValue)instanceValue;
        List<ObjectField> fields = objectValue.getObjectFields();
        List<InputValueDefinition> inputValueDefinitions = allowedTypeDefinition.getInputValueDefinitions();
        Map fieldsToOccurrenceMap = fields.stream().map(ObjectField::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        if (fieldsToOccurrenceMap.values().stream().anyMatch(count -> count > 1L)) {
            this.addValidationError(errors, "Argument value object keys [%s] appear more than once.", fieldsToOccurrenceMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",")));
            return;
        }
        Map<String, InputValueDefinition> nameToInputValueDefMap = inputValueDefinitions.stream().collect(Collectors.toMap(InputValueDefinition::getName, inputValueDef -> inputValueDef));
        List unknownFields = fields.stream().filter(field -> !nameToInputValueDefMap.containsKey(field.getName())).collect(Collectors.toList());
        if (!unknownFields.isEmpty()) {
            this.addValidationError(errors, "Fields ['%s'] not present in type '%s'.", unknownFields.stream().map(ObjectField::getName).collect(Collectors.joining(",")), allowedTypeDefinition.getName());
            return;
        }
        Map<String, ObjectField> nameToFieldsMap = fields.stream().collect(Collectors.toMap(ObjectField::getName, objectField -> objectField));
        inputValueDefinitions.forEach(allowedValueDef -> {
            ObjectField objectField = (ObjectField)nameToFieldsMap.get(allowedValueDef.getName());
            this.checkArgInputObjectValueFieldMatchesAllowedDefinition(errors, objectField, (InputValueDefinition)allowedValueDef);
        });
    }

    private void checkArgValueMatchesAllowedEnum(List<GraphQLError> errors, Value instanceValue, EnumTypeDefinition allowedTypeDefinition) {
        if (!(instanceValue instanceof EnumValue)) {
            this.addValidationError(errors, "Argument value is of type '%s', expected an enum value.", instanceValue.getClass().getSimpleName());
            return;
        }
        EnumValue enumValue = (EnumValue)instanceValue;
        boolean noneMatchAllowedEnumValue = allowedTypeDefinition.getEnumValueDefinitions().stream().noneMatch(enumAllowedValue -> enumAllowedValue.getName().equals(enumValue.getName()));
        if (noneMatchAllowedEnumValue) {
            this.addValidationError(errors, "Argument value '%s' doesn't match any of the allowed enum values ['%s']", enumValue.getName(), allowedTypeDefinition.getEnumValueDefinitions().stream().map(EnumValueDefinition::getName).collect(Collectors.joining(",")));
        }
    }

    private void checkArgValueMatchesAllowedScalar(List<GraphQLError> errors, Value instanceValue, String allowedTypeName) {
        if (instanceValue instanceof ArrayValue || instanceValue instanceof EnumValue || instanceValue instanceof ObjectValue) {
            this.addValidationError(errors, "Argument value is of type '%s', expected a scalar.", instanceValue.getClass().getSimpleName());
            return;
        }
        GraphQLScalarType scalarType = this.runtimeWiring.getScalars().get(allowedTypeName);
        if (!this.isArgumentValueScalarLiteral(scalarType, instanceValue)) {
            this.addValidationError(errors, "Argument value is not a valid value of scalar '%s'.", allowedTypeName);
        }
    }

    private void checkArgInputObjectValueFieldMatchesAllowedDefinition(List<GraphQLError> errors, ObjectField objectField, InputValueDefinition allowedValueDef) {
        if (objectField != null) {
            this.checkArgValueMatchesAllowedType(errors, objectField.getValue(), allowedValueDef.getType());
            return;
        }
        if (allowedValueDef.getType() instanceof NonNullType && allowedValueDef.getDefaultValue() == null) {
            this.addValidationError(errors, "Missing required field '%s'.", allowedValueDef.getName());
        }
    }

    private void checkArgValueMatchesAllowedNonNullType(List<GraphQLError> errors, Value instanceValue, NonNullType allowedArgType) {
        if (instanceValue instanceof NullValue) {
            this.addValidationError(errors, "Argument value is 'null', expected a non-null value.", new Object[0]);
            return;
        }
        Type unwrappedAllowedType = allowedArgType.getType();
        this.checkArgValueMatchesAllowedType(errors, instanceValue, unwrappedAllowedType);
    }

    private void checkArgValueMatchesAllowedListType(List<GraphQLError> errors, Value instanceValue, ListType allowedArgType) {
        if (instanceValue instanceof NullValue) {
            return;
        }
        if (!(instanceValue instanceof ArrayValue)) {
            this.addValidationError(errors, "Argument value is '%s', expected a list value.", instanceValue.getClass().getSimpleName());
            return;
        }
        ArrayValue arrayValue = (ArrayValue)instanceValue;
        Type unwrappedAllowedType = allowedArgType.getType();
        arrayValue.getValues().forEach(value -> this.checkArgValueMatchesAllowedType(errors, (Value)value, unwrappedAllowedType));
    }

    private boolean isArgumentValueScalarLiteral(GraphQLScalarType scalarType, Value instanceValue) {
        try {
            scalarType.getCoercing().parseLiteral(instanceValue);
            return true;
        }
        catch (CoercingParseLiteralException ex) {
            logNotSafe.debug("Attempted parsing literal into '{}' but got the following error: ", (Object)scalarType.getName(), (Object)ex);
            return false;
        }
    }
}

