/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaGeneratorDirectiveHelper;
import graphql.schema.idl.SchemaGeneratorHelper;
import graphql.schema.idl.SchemaGeneratorPostProcessing;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public class SchemaGenerator {
    private final SchemaTypeChecker typeChecker = new SchemaTypeChecker();
    private final SchemaGeneratorHelper schemaGeneratorHelper = new SchemaGeneratorHelper();
    private final SchemaGeneratorDirectiveHelper directiveBehaviour = new SchemaGeneratorDirectiveHelper();

    public GraphQLSchema makeExecutableSchema(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        return this.makeExecutableSchema(Options.defaultOptions(), typeRegistry, wiring);
    }

    public GraphQLSchema makeExecutableSchema(Options options, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        TypeDefinitionRegistry typeRegistryCopy = new TypeDefinitionRegistry();
        typeRegistryCopy.merge(typeRegistry);
        this.schemaGeneratorHelper.addDeprecatedDirectiveDefinition(typeRegistryCopy);
        List<GraphQLError> errors = this.typeChecker.checkTypeRegistry(typeRegistryCopy, wiring, options.enforceSchemaDirectives);
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        Map<String, OperationTypeDefinition> operationTypeDefinitions = SchemaExtensionsChecker.gatherOperationDefs(typeRegistry);
        BuildContext buildCtx = new BuildContext(typeRegistryCopy, wiring, operationTypeDefinitions);
        return this.makeExecutableSchemaImpl(buildCtx);
    }

    private GraphQLSchema makeExecutableSchemaImpl(BuildContext buildCtx) {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        Set<GraphQLDirective> additionalDirectives = this.buildAdditionalDirectives(buildCtx);
        schemaBuilder.additionalDirectives(additionalDirectives);
        buildCtx.setDirectiveDefinitions(additionalDirectives);
        this.buildSchemaDirectivesAndExtensions(buildCtx, schemaBuilder);
        this.buildOperations(buildCtx, schemaBuilder);
        Set<GraphQLType> additionalTypes = this.buildAdditionalTypes(buildCtx);
        schemaBuilder.additionalTypes(additionalTypes);
        buildCtx.getCodeRegistry().fieldVisibility(buildCtx.getWiring().getFieldVisibility());
        GraphQLCodeRegistry codeRegistry = buildCtx.getCodeRegistry().build();
        schemaBuilder.codeRegistry(codeRegistry);
        GraphQLSchema graphQLSchema = schemaBuilder.build();
        Collection<SchemaGeneratorPostProcessing> schemaTransformers = buildCtx.getWiring().getSchemaGeneratorPostProcessings();
        for (SchemaGeneratorPostProcessing postProcessing : schemaTransformers) {
            graphQLSchema = postProcessing.process(graphQLSchema);
        }
        return graphQLSchema;
    }

    private void buildSchemaDirectivesAndExtensions(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        List<Directive> schemaDirectiveList = SchemaExtensionsChecker.gatherSchemaDirectives(typeRegistry);
        schemaBuilder.withSchemaDirectives(this.buildDirectives(schemaDirectiveList, Collections.emptyList(), Introspection.DirectiveLocation.SCHEMA, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        schemaBuilder.definition(typeRegistry.schemaDefinition().orElse(null));
        schemaBuilder.extensionDefinitions(typeRegistry.getSchemaExtensionDefinitions());
    }

    private void buildOperations(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Map<String, OperationTypeDefinition> operationTypeDefs = buildCtx.operationTypeDefs;
        Optional<OperationTypeDefinition> queryOperation = this.getOperationNamed("query", operationTypeDefs);
        if (!queryOperation.isPresent()) {
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            GraphQLObjectType query = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(queryTypeDef.getName()).build());
            schemaBuilder.query(query);
        } else {
            GraphQLObjectType query = this.buildOperation(buildCtx, queryOperation.get());
            schemaBuilder.query(query);
        }
        Optional<OperationTypeDefinition> mutationOperation = this.getOperationNamed("mutation", operationTypeDefs);
        if (!mutationOperation.isPresent()) {
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(mutationTypeDef.get().getName()).build());
                schemaBuilder.mutation(mutation);
            }
        } else {
            GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOperation.get());
            schemaBuilder.mutation(mutation);
        }
        Optional<OperationTypeDefinition> subscriptionOperation = this.getOperationNamed("subscription", operationTypeDefs);
        if (!subscriptionOperation.isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef = typeRegistry.getType("Subscription");
            if (subscriptionTypeDef.isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(subscriptionTypeDef.get().getName()).build());
                schemaBuilder.subscription(subscription);
            }
        } else {
            GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOperation.get());
            schemaBuilder.subscription(subscription);
        }
    }

    private Optional<OperationTypeDefinition> getOperationNamed(String name, Map<String, OperationTypeDefinition> operationTypeDefs) {
        return Optional.ofNullable(operationTypeDefs.get(name));
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        TypeName type = operation.getTypeName();
        return (GraphQLObjectType)this.buildOutputType(buildCtx, type);
    }

    private Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        LinkedHashSet<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        typeRegistry.types().values().forEach(typeDefinition -> {
            TypeName typeName = TypeName.newTypeName().name(typeDefinition.getName()).build();
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition)typeDefinition) == null) {
                    additionalTypes.add(this.buildInputType(buildCtx, typeName));
                }
            } else if (buildCtx.hasOutputType((TypeDefinition)typeDefinition) == null) {
                additionalTypes.add((GraphQLType)this.buildOutputType(buildCtx, typeName));
            }
        });
        return additionalTypes;
    }

    private Set<GraphQLDirective> buildAdditionalDirectives(BuildContext buildCtx) {
        LinkedHashSet<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        typeRegistry.getDirectiveDefinitions().values().forEach(directiveDefinition -> {
            Function<Type, GraphQLInputType> inputTypeFactory = inputType -> this.buildInputType(buildCtx, (Type)inputType);
            GraphQLDirective directive = this.schemaGeneratorHelper.buildDirectiveFromDefinition((DirectiveDefinition)directiveDefinition, inputTypeFactory);
            additionalDirectives.add(directive);
        });
        return additionalDirectives;
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(rawType, typeDefinition);
        }
        buildCtx.putOutputType((GraphQLNamedOutputType)outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    private GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(rawType, typeDefinition);
        }
        buildCtx.putInputType((GraphQLNamedInputType)inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    private GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<ObjectTypeExtensionDefinition> extensions = this.objectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        GraphQLObjectType objectType = builder.build();
        objectType = this.directiveBehaviour.onObject(objectType, buildCtx.mkBehaviourParams());
        return objectType;
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<ObjectTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    private GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InterfaceTypeExtensionDefinition> extensions = this.interfaceTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        GraphQLInterfaceType interfaceType = builder.build();
        if (!buildCtx.codeRegistry.hasTypeResolver(interfaceType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForInterface(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(interfaceType, typeResolver);
        }
        interfaceType = this.directiveBehaviour.onInterface(interfaceType, buildCtx.mkBehaviourParams());
        return interfaceType;
    }

    private GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<UnionTypeExtensionDefinition> extensions = this.unionTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.UNION, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        extensions.forEach(extension -> extension.getMemberTypes().forEach(mt -> {
            GraphQLNamedOutputType outputType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)mt);
            if (!builder.containType(outputType.getName())) {
                if (outputType instanceof GraphQLTypeReference) {
                    builder.possibleType((GraphQLTypeReference)outputType);
                } else {
                    builder.possibleType((GraphQLObjectType)outputType);
                }
            }
        }));
        GraphQLUnionType unionType = builder.build();
        if (!buildCtx.codeRegistry.hasTypeResolver(unionType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForUnion(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(unionType, typeResolver);
        }
        unionType = this.directiveBehaviour.onUnion(unionType, buildCtx.mkBehaviourParams());
        return unionType;
    }

    private GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<EnumTypeExtensionDefinition> extensions = this.enumTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            builder.value(enumValueDefinition);
        });
        extensions.forEach(extension -> extension.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            if (!builder.hasValue(enumValueDefinition.getName())) {
                builder.value(enumValueDefinition);
            }
        }));
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.ENUM, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        GraphQLEnumType enumType = builder.build();
        enumType = this.directiveBehaviour.onEnum(enumType, buildCtx.mkBehaviourParams());
        return enumType;
    }

    private GraphQLEnumValueDefinition buildEnumValue(BuildContext buildCtx, EnumTypeDefinition typeDefinition, EnumValuesProvider enumValuesProvider, EnumValueDefinition evd) {
        Object value;
        String description = this.schemaGeneratorHelper.buildDescription(evd, evd.getDescription());
        String deprecation = this.schemaGeneratorHelper.buildDeprecationReason(evd.getDirectives());
        if (enumValuesProvider != null) {
            value = enumValuesProvider.getValue(evd.getName());
            Assert.assertNotNull(value, "EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName());
        } else {
            value = evd.getName();
        }
        return GraphQLEnumValueDefinition.newEnumValueDefinition().name(evd.getName()).value(value).description(description).deprecationReason(deprecation).definition(evd).comparatorRegistry(buildCtx.getComparatorRegistry()).withDirectives(this.buildDirectives(evd.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ENUM_VALUE, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry())).build();
    }

    private GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        List<ScalarTypeExtensionDefinition> extensions;
        ScalarWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLScalarType scalar = wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, typeDefinition, extensions = this.scalarTypeExtensions(typeDefinition, buildCtx))) ? wiringFactory.getScalar(environment) : buildCtx.getWiring().getScalars().get(typeDefinition.getName());
        if (!ScalarInfo.isStandardScalar(scalar) && !ScalarInfo.isGraphqlSpecifiedScalar(scalar)) {
            scalar = scalar.transform(builder -> builder.definition(typeDefinition).comparatorRegistry(buildCtx.getComparatorRegistry()).withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.SCALAR, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry())));
            scalar = this.directiveBehaviour.onScalar(scalar, buildCtx.mkBehaviourParams());
        }
        return scalar;
    }

    private GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(fieldDef);
        builder.name(fieldDef.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(fieldDef, fieldDef.getDescription()));
        builder.deprecate(this.schemaGeneratorHelper.buildDeprecationReason(fieldDef.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLDirective[] directives = this.buildDirectives(fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.FIELD_DEFINITION, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry());
        builder.withDirectives(directives);
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object fieldType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)fieldType);
        GraphQLFieldDefinition fieldDefinition = builder.build();
        FieldCoordinates coordinates = FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName());
        if (!buildCtx.codeRegistry.hasDataFetcher(coordinates)) {
            DataFetcherFactory dataFetcherFactory = this.buildDataFetcherFactory(buildCtx, parentType, fieldDef, (GraphQLOutputType)fieldType, Arrays.asList(directives));
            buildCtx.getCodeRegistry().dataFetcher(coordinates, dataFetcherFactory);
        }
        return fieldDefinition;
    }

    private DataFetcherFactory buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef, GraphQLOutputType fieldType, List<GraphQLDirective> directives) {
        DataFetcherFactory dataFetcherFactory;
        FieldWiringEnvironment wiringEnvironment;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef, fieldType, directives))) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, "The WiringFactory indicated it provides a data fetcher factory but then returned null", new Object[0]);
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, "The WiringFactory indicated it provides a data fetcher but then returned null", new Object[0]);
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null && (dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment)) == null) {
                    dataFetcher = this.dataFetcherOfLastResort(wiringEnvironment);
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    private DataFetcher<?> dataFetcherOfLastResort(FieldWiringEnvironment environment) {
        String fieldName = environment.getFieldDefinition().getName();
        return new PropertyDataFetcher(fieldName);
    }

    private GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InputObjectTypeExtensionDefinition> extensions = this.inputObjectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.INPUT_OBJECT, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        typeDefinition.getInputValueDefinitions().forEach(inputValue -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)inputValue)));
        extensions.forEach(extension -> extension.getInputValueDefinitions().forEach(inputValueDefinition -> {
            GraphQLInputObjectField inputField = this.buildInputField(buildCtx, (InputValueDefinition)inputValueDefinition);
            if (!builder.hasField(inputField.getName())) {
                builder.field(inputField);
            }
        }));
        GraphQLInputObjectType inputObjectType = builder.build();
        inputObjectType = this.directiveBehaviour.onInputObjectType(inputObjectType, buildCtx.mkBehaviourParams());
        return inputObjectType;
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(fieldDef);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(this.schemaGeneratorHelper.buildDescription(fieldDef, fieldDef.getDescription()));
        fieldBuilder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        Value defaultValue = fieldDef.getDefaultValue();
        if (defaultValue != null) {
            fieldBuilder.defaultValue(this.schemaGeneratorHelper.buildValue(defaultValue, inputType));
        }
        fieldBuilder.withDirectives(this.buildDirectives(fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        return fieldBuilder.build();
    }

    private GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(valueDefinition);
        builder.name(valueDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(valueDefinition, valueDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        Value defaultValue = valueDefinition.getDefaultValue();
        if (defaultValue != null) {
            builder.defaultValue(this.schemaGeneratorHelper.buildValue(defaultValue, inputType));
        }
        builder.withDirectives(this.buildDirectives(valueDefinition.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ARGUMENT_DEFINITION, buildCtx.getDirectiveDefinitions(), buildCtx.getComparatorRegistry()));
        return builder.build();
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it union provides a type resolver but then returned null", new Object[0]);
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it provides a interface type resolver but then returned null", new Object[0]);
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private GraphQLDirective[] buildDirectives(List<Directive> directives, List<Directive> extensionDirectives, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> directiveDefinitions, GraphqlTypeComparatorRegistry comparatorRegistry) {
        directives = directives == null ? Collections.emptyList() : directives;
        extensionDirectives = extensionDirectives == null ? Collections.emptyList() : extensionDirectives;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        ArrayList<GraphQLDirective> output = new ArrayList<GraphQLDirective>();
        for (Directive directive : directives) {
            if (names.contains(directive.getName())) continue;
            names.add(directive.getName());
            output.add(this.schemaGeneratorHelper.buildDirective(directive, directiveDefinitions, directiveLocation, comparatorRegistry));
        }
        for (Directive directive : extensionDirectives) {
            if (names.contains(directive.getName())) continue;
            names.add(directive.getName());
            output.add(this.schemaGeneratorHelper.buildDirective(directive, directiveDefinitions, directiveLocation, comparatorRegistry));
        }
        return output.toArray(new GraphQLDirective[0]);
    }

    private List<ObjectTypeExtensionDefinition> objectTypeExtensions(ObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.objectTypeExtensions().get(typeDefinition.getName()));
    }

    private List<InterfaceTypeExtensionDefinition> interfaceTypeExtensions(InterfaceTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.interfaceTypeExtensions().get(typeDefinition.getName()));
    }

    private List<UnionTypeExtensionDefinition> unionTypeExtensions(UnionTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.unionTypeExtensions().get(typeDefinition.getName()));
    }

    private List<EnumTypeExtensionDefinition> enumTypeExtensions(EnumTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.enumTypeExtensions().get(typeDefinition.getName()));
    }

    private List<ScalarTypeExtensionDefinition> scalarTypeExtensions(ScalarTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.scalarTypeExtensions().get(typeDefinition.getName()));
    }

    private List<InputObjectTypeExtensionDefinition> inputObjectTypeExtensions(InputObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.inputObjectTypeExtensions().get(typeDefinition.getName()));
    }

    private <T> List<T> nvl(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private List<Directive> directivesOf(List<? extends TypeDefinition> typeDefinition) {
        Stream directiveStream = typeDefinition.stream().map(DirectivesContainer::getDirectives).filter(Objects::nonNull).flatMap(Collection::stream);
        return directiveStream.collect(Collectors.toList());
    }

    class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Deque<String> typeStack = new ArrayDeque<String>();
        private final Map<String, GraphQLOutputType> outputGTypes = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new LinkedHashMap<String, GraphQLInputType>();
        private final Map<String, Object> directiveBehaviourContext = new LinkedHashMap<String, Object>();
        private final Set<GraphQLDirective> directiveDefinitions = new LinkedHashSet<GraphQLDirective>();
        private final GraphQLCodeRegistry.Builder codeRegistry;
        public final Map<String, OperationTypeDefinition> operationTypeDefs;

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
            this.codeRegistry = GraphQLCodeRegistry.newCodeRegistry(wiring.getCodeRegistry());
            this.operationTypeDefs = operationTypeDefinitions;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition getTypeDefinition(Type type) {
            Optional<TypeDefinition> optionalTypeDefinition = this.typeRegistry.getType(type);
            Assert.assertTrue(optionalTypeDefinition.isPresent(), " type definition for type '" + type + "' not found", new Object[0]);
            return optionalTypeDefinition.get();
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.typeStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.typeStack.push(typeInfo.getName());
        }

        void pop() {
            this.typeStack.pop();
        }

        SchemaGeneratorDirectiveHelper.Parameters mkBehaviourParams() {
            return new SchemaGeneratorDirectiveHelper.Parameters(this.typeRegistry, this.wiring, this.directiveBehaviourContext, this.codeRegistry);
        }

        GraphQLOutputType hasOutputType(TypeDefinition typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void putOutputType(GraphQLNamedOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void putInputType(GraphQLNamedInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }

        GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.wiring.getComparatorRegistry();
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public void setDirectiveDefinitions(Set<GraphQLDirective> directiveDefinitions) {
            this.directiveDefinitions.addAll(directiveDefinitions);
        }

        public Set<GraphQLDirective> getDirectiveDefinitions() {
            return this.directiveDefinitions;
        }
    }

    public static class Options {
        private final boolean enforceSchemaDirectives;

        Options(boolean enforceSchemaDirectives) {
            this.enforceSchemaDirectives = enforceSchemaDirectives;
        }

        public boolean isEnforceSchemaDirectives() {
            return this.enforceSchemaDirectives;
        }

        public static Options defaultOptions() {
            return new Options(true);
        }

        public Options enforceSchemaDirectives(boolean flag) {
            return new Options(flag);
        }
    }
}

