/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import graphql.validation.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

@Internal
public class AbstractRule {
    private final ValidationContext validationContext;
    private final ValidationErrorCollector validationErrorCollector;
    private boolean visitFragmentSpreads;
    private ValidationUtil validationUtil = new ValidationUtil();

    public AbstractRule(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        this.validationContext = validationContext;
        this.validationErrorCollector = validationErrorCollector;
    }

    public boolean isVisitFragmentSpreads() {
        return this.visitFragmentSpreads;
    }

    public void setVisitFragmentSpreads(boolean visitFragmentSpreads) {
        this.visitFragmentSpreads = visitFragmentSpreads;
    }

    public ValidationUtil getValidationUtil() {
        return this.validationUtil;
    }

    public void addError(ValidationErrorType validationErrorType, List<? extends Node<?>> locations, String description) {
        ArrayList<SourceLocation> locationList = new ArrayList<SourceLocation>();
        for (Node<?> node : locations) {
            locationList.add(node.getSourceLocation());
        }
        this.addError(ValidationError.newValidationError().validationErrorType(validationErrorType).sourceLocations(locationList).description(description));
    }

    public void addError(ValidationErrorType validationErrorType, SourceLocation location, String description) {
        this.addError(ValidationError.newValidationError().validationErrorType(validationErrorType).sourceLocation(location).description(description));
    }

    public void addError(ValidationError.Builder validationError) {
        this.validationErrorCollector.addError(validationError.queryPath(this.getQueryPath()).build());
    }

    public List<ValidationError> getErrors() {
        return this.validationErrorCollector.getErrors();
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public ValidationErrorCollector getValidationErrorCollector() {
        return this.validationErrorCollector;
    }

    protected List<String> getQueryPath() {
        return this.validationContext.getQueryPath();
    }

    public void checkDocument(Document document) {
    }

    public void checkArgument(Argument argument) {
    }

    public void checkTypeName(TypeName typeName) {
    }

    public void checkVariableDefinition(VariableDefinition variableDefinition) {
    }

    public void checkField(Field field) {
    }

    public void checkInlineFragment(InlineFragment inlineFragment) {
    }

    public void checkDirective(Directive directive, List<Node> ancestors) {
    }

    public void checkFragmentSpread(FragmentSpread fragmentSpread) {
    }

    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
    }

    public void checkOperationDefinition(OperationDefinition operationDefinition) {
    }

    public void leaveOperationDefinition(OperationDefinition operationDefinition) {
    }

    public void checkSelectionSet(SelectionSet selectionSet) {
    }

    public void leaveSelectionSet(SelectionSet selectionSet) {
    }

    public void checkVariable(VariableReference variableReference) {
    }

    public void documentFinished(Document document) {
    }

    public String toString() {
        return "Rule{" + this.validationContext + "}";
    }
}

