/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.monitor.pmi.application;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.container.pmi.ApplicationModuleInterface;
import com.ibm.ws.sip.container.pmi.listener.ApplicationsPMIListener;
import com.ibm.ws.sip.monitor.pmi.application.ApplicationModule;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="s_logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ApplicationsModule
implements ApplicationsPMIListener {
    private static final Logger s_logger = Logger.getLogger(ApplicationsModule.class.getName());
    private final ConcurrentMap<String, ApplicationModuleInterface> appModules;
    private static ApplicationsModule s_singleton = null;
    static final long serialVersionUID = 2927968981475952915L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ApplicationsModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "<init>", new Object[0]);
        }
        this.appModules = new ConcurrentHashMap<String, ApplicationModuleInterface>();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ApplicationsModule getInstance() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "getInstance", new Object[0]);
        }
        ApplicationsModule applicationsModule = s_singleton;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            applicationsModule = applicationsModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "getInstance", applicationsModule);
        }
        return applicationsModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(Map<String, Object> componentConfig) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "activate", new Object[]{componentConfig});
        }
        s_singleton = this;
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "ApplicationsModule activated", componentConfig);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Modified
    protected void modified(Map<String, Object> properties) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "modified", new Object[]{properties});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "modified");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate(int reason) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "deactivate", new Object[]{reason});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateCounters(String appName) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "updateCounters", new Object[]{appName});
        }
        ApplicationModule appModule = (ApplicationModule)this.appModules.get(appName);
        if (appModule != null) {
            appModule.updateCounters();
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "updateCounters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ApplicationModuleInterface getApplicationModule(String appName) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "getApplicationModule", new Object[]{appName});
        }
        if (this.appModules.containsKey(appName)) {
            ApplicationModuleInterface applicationModuleInterface = (ApplicationModuleInterface)this.appModules.get(appName);
            if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
                applicationModuleInterface = applicationModuleInterface;
                s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "getApplicationModule", applicationModuleInterface);
            }
            return applicationModuleInterface;
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, ApplicationModule.class.getName(), "getApplicationModule", "creating new ApplicationModule for " + appName);
        }
        ApplicationModule appModule = new ApplicationModule(appName);
        this.appModules.put(appName, appModule);
        ApplicationModule applicationModule = appModule;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            applicationModule = applicationModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationsModule", "getApplicationModule", applicationModule);
        }
        return applicationModule;
    }
}

