/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql;

import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.execution.resolver.ConcreteImplementationNotFoundException;
import io.smallrye.graphql.schema.model.Operation;
import java.time.DateTimeException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRGQL")
public interface SmallRyeGraphQLServerMessages {
    public static final SmallRyeGraphQLServerMessages msg = (SmallRyeGraphQLServerMessages)Messages.getBundle(SmallRyeGraphQLServerMessages.class);

    @Message(id=0, value="No concrete class named [%s] found for interface [%s]")
    public ConcreteImplementationNotFoundException concreteClassNotFoundForInterface(String var1, String var2);

    @Message(id=1, value="Unknown primitive type [%s]")
    public ClassNotFoundException unknownPrimitiveType(String var1);

    @Message(id=2, value="Data fetching failed for operation [%s]")
    public DataFetcherException dataFetcherException(Operation var1, @Cause Throwable var2);

    @Message(id=5, value="Could not get Instance using the default lookup service")
    public RuntimeException countNotGetInstance(@Cause Throwable var1);

    @Message(id=6, value="Metrics are not supported without CDI")
    public UnsupportedOperationException metricsNotSupportedWithoutCDI();

    @Message(id=8, value="OpenTracing is not supported without CDI")
    public UnsupportedOperationException openTracingNotSupportedWithoutCDI();

    @Message(id=9, value="Can not load class [%s]")
    public RuntimeException canNotLoadClass(String var1, @Cause Exception var2);

    @Message(id=10, value="[%s] is not a valid number type")
    public RuntimeException notAValidNumberType(String var1);

    @Message(id=11, value="Can not parse a number from [%s]")
    public NumberFormatException numberFormatException(String var1);

    @Message(id=12, value="Expected type [%s] but was [%s].")
    public CoercingSerializeException coercingSerializeException(String var1, String var2, @Cause Exception var3);

    @Message(id=13, value="Expected type [%s] but was [%s].")
    public CoercingParseValueException coercingParseValueException(String var1, String var2, @Cause Exception var3);

    @Message(id=14, value="Expected value to be in the %s range but it was '%s'")
    public CoercingParseLiteralException coercingParseLiteralException(String var1, String var2);

    @Message(id=15, value="Expected AST type 'IntValue' or 'StringValue' but was '%s'.")
    public CoercingParseLiteralException coercingParseLiteralException(String var1);

    @Message(id=16, value="Can't parse [%s] into [%s]")
    public RuntimeException cantParseDate(String var1, String var2);

    @Message(id=17, value="[%s] is no valid date or time-type")
    public RuntimeException notValidDateOrTimeType(String var1);

    @Message(id=18, value="Unknown date format [%s]")
    public DateTimeException unknownDateFormat(String var1);

    @Message(id=19, value="Unsupported wrapped type. SmallRye only support DataFetchingEnvironment and not %s")
    public IllegalArgumentException unsupportedWrappedClass(String var1);
}

