/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.config;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.RuntimeMetaDataProvider;
import com.ibm.tx.jta.util.alarm.AlarmManagerImpl;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.wsspi.resource.ResourceFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static AlarmManager _alarmManager;
    private byte[] _applId;
    private static final RuntimeMetaDataProvider _runtimeMetaDataProvider;
    protected static int _heuristicCompletionDirction;
    protected static int _heuristicRetryInterval;
    protected static int _heuristicRetryLimit;
    public int _totalTransactionLifetimeTimeout = 120;
    protected static String _logDir;
    protected static int _logSize;
    protected static boolean _logForHeuristicReporting;
    protected static Level _level;
    protected static int _defaultMaximumShutdownDelay;
    protected static boolean _acceptHeuristicHazard;
    protected static boolean _auditRecovery;
    protected static boolean _recoverOnStartup;
    protected static boolean _shutdownOnLogFailure;
    protected static boolean _OnePCOptimization;
    protected static boolean _waitForRecovery;
    protected boolean _propagateXAResourceTransactionTimeout = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.websphere.tx.propagateXAResourceTransactionTimeout");
        }
    });

    public DefaultConfigurationProvider() {
        _alarmManager = new AlarmManagerImpl();
    }

    public AlarmManager getAlarmManager() {
        return _alarmManager;
    }

    public int getClientInactivityTimeout() {
        return 60;
    }

    public int getHeuristicCompletionDirection() {
        return _heuristicCompletionDirction;
    }

    public String getHeuristicCompletionDirectionAsString() {
        String hcd = "ROLLBACK";
        switch (_heuristicCompletionDirction) {
            case 0: {
                hcd = "COMMIT";
                break;
            }
            case 2: {
                hcd = "MANUAL";
                break;
            }
        }
        return hcd;
    }

    public int getHeuristicRetryInterval() {
        return _heuristicRetryInterval;
    }

    public int getHeuristicRetryLimit() {
        return _heuristicRetryLimit;
    }

    public int getMaximumTransactionTimeout() {
        return 300;
    }

    public RuntimeMetaDataProvider getRuntimeMetaDataProvider() {
        return _runtimeMetaDataProvider;
    }

    public int getTotalTransactionLifetimeTimeout() {
        return this._totalTransactionLifetimeTimeout;
    }

    public String getTransactionLogDirectory() {
        return _logDir;
    }

    public String getServerName() {
        return "default";
    }

    public int getTransactionLogSize() {
        return _logSize;
    }

    public boolean isLoggingForHeuristicReportingEnabled() {
        return _logForHeuristicReporting;
    }

    public Level getTraceLevel() {
        String level = System.getProperty("com.ibm.tx.traceLevel");
        if (level != null) {
            return Level.parse(level);
        }
        return _level;
    }

    public int getDefaultMaximumShutdownDelay() {
        return _defaultMaximumShutdownDelay;
    }

    public boolean isAcceptHeuristicHazard() {
        return _acceptHeuristicHazard;
    }

    public boolean getAuditRecovery() {
        String flag = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.tx.auditRecovery");
            }
        });
        if (flag != null) {
            return Boolean.parseBoolean(flag);
        }
        return _auditRecovery;
    }

    public boolean isRecoverOnStartup() {
        return _recoverOnStartup;
    }

    public boolean isShutdownOnLogFailure() {
        return _shutdownOnLogFailure;
    }

    public boolean isOnePCOptimization() {
        return _OnePCOptimization;
    }

    public boolean isWaitForRecovery() {
        return _waitForRecovery;
    }

    public ResourceFactory getResourceFactory() {
        return null;
    }

    public boolean getPropagateXAResourceTransactionTimeout() {
        return this._propagateXAResourceTransactionTimeout;
    }

    public String getRecoveryIdentity() {
        return null;
    }

    public String getRecoveryGroup() {
        return null;
    }

    public void setApplId(byte[] name) {
        this._applId = name;
    }

    public byte[] getApplId() {
        byte[] result = this._applId;
        return result;
    }

    public void shutDownFramework() {
    }

    public String getLeaseCheckStrategy() {
        return null;
    }

    public int getLeaseCheckInterval() {
        return 0;
    }

    public int getLeaseLength() {
        return 0;
    }

    public boolean isSQLRecoveryLog() {
        return false;
    }

    public boolean needToCoordinateServices() {
        return false;
    }

    public boolean enableHADBPeerLocking() {
        return false;
    }

    public int getTimeBetweenHeartbeats() {
        return 5;
    }

    public int getPeerTimeBeforeStale() {
        return 10;
    }

    public int getLightweightTransientErrorRetryTime() {
        return 1;
    }

    public int getLightweightTransientErrorRetryAttempts() {
        return 2;
    }

    public int getStandardTransientErrorRetryTime() {
        return 10;
    }

    public int getStandardTransientErrorRetryAttempts() {
        return 180;
    }

    public int getLeaseRenewalThreshold() {
        return 90;
    }

    static {
        _runtimeMetaDataProvider = new RuntimeMetaDataProvider(){

            public int getTransactionTimeout() {
                return 0;
            }

            public boolean isClientSideJTADemarcationAllowed() {
                return false;
            }

            public boolean isHeuristicHazardAccepted() {
                return _acceptHeuristicHazard;
            }

            public boolean isUserTransactionLookupPermitted(String name) {
                return true;
            }
        };
        _heuristicCompletionDirction = 1;
        _heuristicRetryInterval = 0;
        _heuristicRetryLimit = 0;
        _logDir = "logs/recovery";
        _logSize = 1024;
        _logForHeuristicReporting = false;
        _level = Level.OFF;
        _defaultMaximumShutdownDelay = 2;
        _acceptHeuristicHazard = true;
        _auditRecovery = false;
        _shutdownOnLogFailure = true;
    }
}

