/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAP11Constants;
import org.apache.ws.security.SOAP12Constants;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.StringUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSSecurityUtil {
    private static boolean isJava9SAAJ = false;
    private static Log log = LogFactory.getLog(WSSecurityUtil.class);
    private static SecureRandom random;
    private static MessageDigest digest;

    private WSSecurityUtil() {
    }

    public static Element getSecurityHeader(Document doc, String actor) throws WSSecurityException {
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        Element soapHeaderElement = WSSecurityUtil.getDirectChildElement(doc.getDocumentElement(), "Header", soapNamespace);
        if (soapHeaderElement == null) {
            return null;
        }
        String actorLocal = "actor";
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace)) {
            actorLocal = "role";
        }
        Element foundSecurityHeader = null;
        for (Node currentChild = soapHeaderElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String hActor;
            if (1 != currentChild.getNodeType() || !"Security".equals(currentChild.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI())) continue;
            Element elem = (Element)currentChild;
            Attr attr = elem.getAttributeNodeNS(soapNamespace, actorLocal);
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            if (foundSecurityHeader != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Two or more security headers have the same actor name: " + actor));
                }
                throw new WSSecurityException(3);
            }
            foundSecurityHeader = elem;
        }
        return foundSecurityHeader;
    }

    public static boolean isActorEqual(String actor, String hActor) {
        if (!(hActor != null && hActor.length() != 0 || actor != null && actor.length() != 0)) {
            return true;
        }
        return hActor != null && actor != null && hActor.equalsIgnoreCase(actor);
    }

    public static Element getDirectChildElement(Node parentNode, String localName, String namespace) {
        if (parentNode == null) {
            return null;
        }
        for (Node currentChild = parentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType() || !localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public static List<Element> getDirectChildElements(Node fNode, String localName, String namespace) {
        ArrayList<Element> children = new ArrayList<Element>();
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType() || !localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            children.add((Element)currentChild);
        }
        return children;
    }

    public static Element findBodyElement(Document doc) {
        Element docElement = doc.getDocumentElement();
        String ns = docElement.getNamespaceURI();
        return WSSecurityUtil.getDirectChildElement(docElement, "Body", ns);
    }

    public static List<Element> findElements(WSEncryptionPart part, CallbackLookup callbackLookup, Document doc) throws WSSecurityException {
        if (part.getElement() != null) {
            return Collections.singletonList(part.getElement());
        }
        String id = part.getId();
        if (id != null) {
            Element foundElement = callbackLookup.getElement(id, null, false);
            return Collections.singletonList(foundElement);
        }
        return callbackLookup.getElements(part.getName(), part.getNamespace());
    }

    public static Element findElement(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    return (Element)startNode;
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    return (Element)startNode;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return null;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return null;
    }

    public static List<Element> findElements(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        ArrayList<Element> foundNodes = new ArrayList<Element>();
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    foundNodes.add((Element)startNode);
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    foundNodes.add((Element)startNode);
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundNodes;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundNodes;
    }

    public static Element findSAMLAssertionElementById(Node startNode, String value) {
        Element foundElement = null;
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            Element se;
            if (startNode.getNodeType() == 1 && ((se = (Element)startNode).hasAttributeNS(null, "ID") && value.equals(se.getAttributeNS(null, "ID")) || se.hasAttributeNS(null, "AssertionID") && value.equals(se.getAttributeNS(null, "AssertionID")))) {
                if (foundElement == null) {
                    foundElement = se;
                } else {
                    log.warn((Object)"Multiple elements with the same 'ID' attribute value!");
                    return null;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static Element findElementById(Node startNode, String value, boolean checkMultipleElements) {
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        Element foundElement = null;
        String id = WSSecurityUtil.getIDFromReference(value);
        while (startNode != null) {
            if (startNode.getNodeType() == 1) {
                Element se = (Element)startNode;
                String attributeNS = se.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if ("".equals(attributeNS) || !id.equals(attributeNS)) {
                    attributeNS = se.getAttributeNS(null, "Id");
                }
                if (!"".equals(attributeNS) && id.equals(attributeNS)) {
                    if (!checkMultipleElements) {
                        return se;
                    }
                    if (foundElement == null) {
                        foundElement = se;
                    } else {
                        log.warn((Object)"Multiple elements with the same 'Id' attribute value!");
                        return null;
                    }
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static String setNamespace(Element element, String namespace, String prefix) {
        String pre = WSSecurityUtil.getPrefixNS(namespace, element);
        if (pre != null) {
            return pre;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return prefix;
    }

    public static String getPrefixNS(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring("xmlns:".length());
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = null;
            attr = prefix == null ? ((Element)e).getAttributeNodeNS(null, "xmlns") : ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, false);
    }

    public static QName getFullQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, true);
    }

    private static QName getQNameFromString(String str, Node e, boolean defaultNS) {
        String ns;
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns2 = WSSecurityUtil.getNamespace(prefix, e);
            if (ns2 == null) {
                return null;
            }
            return new QName(ns2, str.substring(idx + 1));
        }
        if (defaultNS && (ns = WSSecurityUtil.getNamespace(null, e)) != null) {
            return new QName(ns, str);
        }
        return new QName("", str);
    }

    public static String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = WSSecurityUtil.getPrefixNS(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (WSSecurityUtil.getNamespace(prefix, e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return prefix + ":" + qname.getLocalPart();
    }

    public static String getIDFromReference(String ref) {
        if (ref == null) {
            return null;
        }
        String id = ref.trim();
        if (id.length() == 0) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        return id;
    }

    private static Element createElementInSameNamespace(Node parent, String localName) {
        String qName = localName;
        String prefix = parent.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            qName = prefix + ":" + localName;
        }
        String nsUri = parent.getNamespaceURI();
        return parent.getOwnerDocument().createElementNS(nsUri, qName);
    }

    public static Element prependChildElement(Element parent, Element child) {
        Node firstChild = parent.getFirstChild();
        Element domChild = null;
        try {
            domChild = (Element)WSSecurityUtil.getDomElement(child);
        }
        catch (WSSecurityException e) {
            log.debug((Object)"Error trying to get Dom Element from the child");
        }
        if (firstChild == null) {
            return (Element)parent.appendChild(domChild);
        }
        return (Element)parent.insertBefore(domChild, firstChild);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, boolean doCreate) throws WSSecurityException {
        return WSSecurityUtil.findWsseSecurityHeaderBlock(doc, envelope, null, doCreate);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, String actor, boolean doCreate) throws WSSecurityException {
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        Element header = WSSecurityUtil.getDirectChildElement(doc.getDocumentElement(), "Header", soapNamespace);
        log.info((Object)("@TJJ findWsseSecurityHeaderBlockl header == " + header));
        System.out.println("@TJJ findWsseSecurityHeaderBlockl header == " + header);
        if (header == null) {
            if (doCreate) {
                log.info((Object)("@TJJ findWsseSecurityHeaderBlockl doCreate == " + doCreate));
                System.out.println("@TJJ findWsseSecurityHeaderBlockl doCreate == " + doCreate);
                if (isJava9SAAJ) {
                    log.info((Object)("@TJJ findWsseSecurityHeaderBlockl isJava9SAAJ == " + isJava9SAAJ));
                    System.out.println("@TJJ findWsseSecurityHeaderBlockl isJava9SAAJ == " + isJava9SAAJ);
                    try {
                        Node node = null;
                        try {
                            Method method = doc.getClass().getMethod("getEnvelope", new Class[0]);
                            node = (Node)method.invoke((Object)doc, new Object[0]);
                        }
                        catch (NoSuchMethodException nsme) {
                            node = null;
                        }
                        header = node != null ? WSSecurityUtil.createElementInSameNamespace(node, "Header") : WSSecurityUtil.createElementInSameNamespace(doc.getDocumentElement(), "Header");
                        doc.importNode(header, true);
                        header = (Element)WSSecurityUtil.getDomElement(header);
                        header = WSSecurityUtil.prependChildElement(envelope, header);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new WSSecurityException(3);
                    }
                }
                header = WSSecurityUtil.createElementInSameNamespace(envelope, "Header");
                header = WSSecurityUtil.prependChildElement(envelope, header);
            } else {
                return null;
            }
        }
        String actorLocal = "actor";
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace)) {
            actorLocal = "role";
        }
        Element foundSecurityHeader = null;
        for (Node currentChild = header.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String hActor;
            if (1 != currentChild.getNodeType() || !"Security".equals(currentChild.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI())) continue;
            Element elem = (Element)currentChild;
            Attr attr = elem.getAttributeNodeNS(soapNamespace, actorLocal);
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            if (foundSecurityHeader != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Two or more security headers have the same actor name: " + actor));
                    System.out.println("Two or more security headers have the same actor name: " + actor);
                }
                throw new WSSecurityException(3);
            }
            foundSecurityHeader = elem;
        }
        if (foundSecurityHeader != null) {
            log.info((Object)("@TJJ findWsseSecurityHeaderBlockl foundSecurityHeader == " + foundSecurityHeader));
            System.out.println("@TJJ findWsseSecurityHeaderBlockl foundSecurityHeader == " + foundSecurityHeader);
            return foundSecurityHeader;
        }
        if (doCreate) {
            log.info((Object)("@TJJ findWsseSecurityHeaderBlockl doCreate == " + doCreate));
            System.out.println("@TJJ findWsseSecurityHeaderBlockl doCreate == " + doCreate);
            foundSecurityHeader = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            foundSecurityHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            doc.importNode(foundSecurityHeader, true);
            foundSecurityHeader = (Element)WSSecurityUtil.getDomElement(foundSecurityHeader);
            return WSSecurityUtil.prependChildElement(header, foundSecurityHeader);
        }
        return null;
    }

    public static Text createBase64EncodedTextNode(Document doc, byte[] data) {
        return doc.createTextNode(Base64.encode(data));
    }

    public static SOAPConstants getSOAPConstants(Element startElement) {
        Document doc = startElement.getOwnerDocument();
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
            return new SOAP12Constants();
        }
        return new SOAP11Constants();
    }

    public static String getSOAPNamespace(Element startElement) {
        return WSSecurityUtil.getSOAPConstants(startElement).getEnvelopeURI();
    }

    public static SecretKey prepareSecretKey(String symEncAlgo, byte[] rawKey) {
        int size;
        block2: {
            size = 0;
            try {
                size = JCEMapper.getKeyLengthFromURI((String)symEncAlgo) / 8;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)e.getMessage());
            }
        }
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo);
        SecretKeySpec keySpec = size > 0 ? new SecretKeySpec(rawKey, 0, rawKey.length > size ? size : rawKey.length, keyAlgorithm) : new SecretKeySpec(rawKey, keyAlgorithm);
        return keySpec;
    }

    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)cipherAlgo);
            return Cipher.getInstance(keyAlgorithm);
        }
        catch (NoSuchPaddingException ex) {
            throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such padding: " + cipherAlgo}, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(cipherAlgo)) {
                try {
                    return Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                }
                catch (Exception e) {
                    throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo}, e);
                }
            }
            throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo}, ex);
        }
    }

    public static WSSecurityEngineResult fetchActionResult(List<WSSecurityEngineResult> resultList, int action) {
        WSSecurityEngineResult returnResult = null;
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get("action");
            if (resultAction != action) continue;
            returnResult = result;
        }
        return returnResult;
    }

    public static List<WSSecurityEngineResult> fetchAllActionResults(List<WSSecurityEngineResult> resultList, int action, List<WSSecurityEngineResult> actionResultList) {
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get("action");
            if (resultAction != action) continue;
            actionResultList.add(result);
        }
        return actionResultList;
    }

    public static int decodeAction(String action, List<Integer> actions) throws WSSecurityException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions.add(1);
                continue;
            }
            if (single[i].equals("UsernameTokenNoPassword")) {
                doAction |= 0x2000;
                actions.add(8192);
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions.add(2);
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions.add(4);
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions.add(8);
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions.add(16);
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions.add(32);
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions.add(64);
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                doAction |= 0x80;
                actions.add(128);
                continue;
            }
            throw new WSSecurityException("Unknown action defined: " + single[i]);
        }
        return doAction;
    }

    public static int decodeAction(String action, List<Integer> actions, WSSConfig wssConfig) throws WSSecurityException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions.add(1);
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions.add(2);
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions.add(4);
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions.add(8);
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions.add(16);
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions.add(32);
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions.add(64);
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                doAction |= 0x80;
                actions.add(128);
                continue;
            }
            try {
                int parsedAction = Integer.parseInt(single[i]);
                if (wssConfig.getAction(parsedAction) == null) {
                    throw new WSSecurityException("Unknown action defined: " + single[i]);
                }
                actions.add(parsedAction);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new WSSecurityException("Unknown action defined: " + single[i]);
            }
        }
        return doAction;
    }

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return 16;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return 32;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(algorithm)) {
            return 20;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256".equals(algorithm)) {
            return 32;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384".equals(algorithm)) {
            return 48;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512".equals(algorithm)) {
            return 64;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-md5".equals(algorithm)) {
            return 16;
        }
        throw new WSSecurityException(2, null, null, null);
    }

    public static synchronized byte[] generateNonce(int length) throws WSSecurityException {
        try {
            if (random == null) {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            byte[] temp = new byte[length];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception ex) {
            throw new WSSecurityException("Error in generating nonce of length " + length, ex);
        }
    }

    public static synchronized byte[] generateDigest(byte[] inputBytes) throws WSSecurityException {
        try {
            if (digest == null) {
                digest = MessageDigest.getInstance("SHA-1");
            }
            return digest.digest(inputBytes);
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in generating digest", e);
        }
    }

    public static void checkAllElementsProtected(List<WSSecurityEngineResult> results, int action, QName[] requiredParts) throws WSSecurityException {
        if (requiredParts != null) {
            for (int i = 0; i < requiredParts.length; ++i) {
                QName requiredPart = requiredParts[i];
                boolean found = false;
                Iterator<WSSecurityEngineResult> iter = results.iterator();
                block1: while (iter.hasNext() && !found) {
                    List refList;
                    WSSecurityEngineResult result = iter.next();
                    int resultAction = (Integer)result.get("action");
                    if (resultAction != action || (refList = (List)result.get("data-ref-uris")) == null) continue;
                    for (WSDataRef dataRef : refList) {
                        if (!dataRef.getName().equals(requiredPart)) continue;
                        found = true;
                        continue block1;
                    }
                }
                if (found) continue;
                throw new WSSecurityException(6, "requiredElementNotProtected", new Object[]{requiredPart});
            }
            log.debug((Object)"All required elements are protected");
        }
    }

    public static void checkSignsAllElements(WSSecurityEngineResult resultItem, String[] requiredIDs) throws WSSecurityException {
        int resultAction = (Integer)resultItem.get("action");
        if (resultAction != 2) {
            throw new IllegalArgumentException("Not a SIGN result");
        }
        List signedElemsRefList = (List)resultItem.get("data-ref-uris");
        if (signedElemsRefList == null) {
            throw new WSSecurityException("WSSecurityEngineResult does not contain any references to signed elements");
        }
        log.debug((Object)"Checking required elements are in the signature...");
        for (int i = 0; i < requiredIDs.length; ++i) {
            boolean found = false;
            for (int j = 0; j < signedElemsRefList.size(); ++j) {
                WSDataRef dataRef = (WSDataRef)signedElemsRefList.get(j);
                String wsuId = dataRef.getWsuId();
                if (wsuId.charAt(0) == '#') {
                    wsuId = wsuId.substring(1);
                }
                if (!wsuId.equals(requiredIDs[i])) continue;
                found = true;
            }
            if (!found) {
                throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{requiredIDs[i]});
            }
            log.debug((Object)("Element with ID " + requiredIDs[i] + " was correctly signed"));
        }
        log.debug((Object)"All required elements are signed");
    }

    public static List<Node> listChildren(Node parent) {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (parent != null) {
            for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
                ret.add(node);
            }
        }
        return ret;
    }

    public static List<Node> newNodes(List<Node> a, List<Node> b) {
        if (a.size() == 0) {
            return b;
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        if (b.size() == 0) {
            return ret;
        }
        for (Node bnode : b) {
            String bns = bnode.getNamespaceURI();
            String bln = bnode.getLocalName();
            boolean found = false;
            Iterator<Node> apos = a.iterator();
            while (apos.hasNext() && !found) {
                boolean lnmatch;
                boolean nsmatch;
                Node anode = apos.next();
                String ans = anode.getNamespaceURI();
                String aln = anode.getLocalName();
                boolean bl = ans == null ? bns == null : (nsmatch = bns == null ? false : ans.equals(bns));
                boolean bl2 = aln == null ? bln == null : (lnmatch = bln == null ? false : aln.equals(bln));
                if (!nsmatch || !lnmatch) continue;
                found = true;
            }
            if (found) continue;
            ret.add(bnode);
        }
        return ret;
    }

    public static void storeElementInContext(DOMCryptoContext context, String uri, Element element) {
        String id = uri;
        if (!"".equals(uri) && uri.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") && id.equals(element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) {
            context.setIdAttributeNS(element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (element.hasAttributeNS(null, "Id") && id.equals(element.getAttributeNS(null, "Id"))) {
            context.setIdAttributeNS(element, null, "Id");
        }
        if (element.hasAttributeNS(null, "id") && id.equals(element.getAttributeNS(null, "id"))) {
            context.setIdAttributeNS(element, null, "id");
        }
        if (element.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "id") && id.equals(element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id"))) {
            context.setIdAttributeNS(element, "http://www.w3.org/XML/1998/namespace", "id");
        }
        if (element.hasAttributeNS(null, "ID") && id.equals(element.getAttributeNS(null, "ID"))) {
            context.setIdAttributeNS(element, null, "ID");
        }
        if (element.hasAttributeNS(null, "AssertionID") && id.equals(element.getAttributeNS(null, "AssertionID"))) {
            context.setIdAttributeNS(element, null, "AssertionID");
        }
    }

    public static void storeElementInContext(DOMCryptoContext context, Element element) {
        if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
            context.setIdAttributeNS(element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (element.hasAttributeNS(null, "Id")) {
            context.setIdAttributeNS(element, null, "Id");
        }
        if (element.hasAttributeNS(null, "ID")) {
            context.setIdAttributeNS(element, null, "ID");
        }
        if (element.hasAttributeNS(null, "AssertionID")) {
            context.setIdAttributeNS(element, null, "AssertionID");
        }
    }

    public static void verifySignedElement(Element elem, WSDocInfo wsDocInfo) throws WSSecurityException {
        List<WSSecurityEngineResult> signedResults = wsDocInfo.getResultsByTag(2);
        if (signedResults != null) {
            for (WSSecurityEngineResult signedResult : signedResults) {
                List dataRefs = (List)signedResult.get("data-ref-uris");
                if (dataRefs == null) continue;
                for (WSDataRef dataRef : dataRefs) {
                    if (!WSSecurityUtil.isElementOrAncestorSigned(elem, dataRef.getProtectedElement())) continue;
                    return;
                }
            }
        }
        throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{elem});
    }

    private static boolean isElementOrAncestorSigned(Element elem, Element signedElement) throws WSSecurityException {
        Element envelope = elem.getOwnerDocument().getDocumentElement();
        Node cur = elem;
        while (!cur.isSameNode(envelope)) {
            if (cur.getNodeType() == 1 && cur.equals(signedElement)) {
                return true;
            }
            cur = cur.getParentNode();
        }
        return false;
    }

    public static Element cloneElement(Document doc, Element clonedElement) throws WSSecurityException {
        clonedElement = (Element)clonedElement.cloneNode(true);
        if (isJava9SAAJ) {
            clonedElement = (Element)doc.importNode(clonedElement, true);
            clonedElement = (Element)WSSecurityUtil.getDomElement(clonedElement);
        }
        return clonedElement;
    }

    public static Node getDomElement(Node node) throws WSSecurityException {
        log.info((Object)("@TJJ getDomElement node == " + node));
        log.info((Object)("@TJJ getDomElement isJava9SAAJ == " + isJava9SAAJ));
        if (!System.getProperty("java.version").startsWith("1.")) {
            try {
                Method method = node.getClass().getMethod("getDomElement", new Class[0]);
                node = (Node)method.invoke((Object)node, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.info((Object)"@TJJ Not a saaj node with java9");
            }
            catch (Exception e) {
                throw new WSSecurityException(3);
            }
        }
        return node;
    }

    static {
        if (!System.getProperty("java.specification.version").startsWith("1.")) {
            Method[] methods;
            log.debug((Object)"@TJJ its java9 or >");
            try {
                for (Method method : methods = WSSecurityUtil.class.getClassLoader().loadClass("com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl").getMethods()) {
                    if (!method.getName().equals("register")) continue;
                    isJava9SAAJ = true;
                    break;
                }
            }
            catch (ClassNotFoundException cnfe1) {
                log.debug((Object)"can't load class com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl");
                System.out.println("can't load class com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl");
                cnfe1.printStackTrace();
            }
            try {
                for (Method method : methods = WSSecurityUtil.class.getClassLoader().loadClass("com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl").getMethods()) {
                    if (!method.getName().equals("register")) continue;
                    isJava9SAAJ = true;
                    break;
                }
            }
            catch (ClassNotFoundException cnfe1) {
                log.debug((Object)"can't load class com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl");
            }
        }
        random = null;
        digest = null;
    }
}

