/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.jandex.internal.Jandex_Utils;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileStamp;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_MappedJar;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_MappedJar
extends ClassSourceImpl
implements ClassSource_MappedJar {
    public static final String CLASS_NAME;
    protected int opens;
    protected final String jarPath;
    protected final String absJarPath;
    protected final File rawJarFile;
    protected JarFile jarFile;
    static final long serialVersionUID = -5398736880338722283L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_MappedJar(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, String jarPath) {
        this(factory, internMap, name, jarPath, NO_ENTRY_PREFIX);
    }

    public ClassSourceImpl_MappedJar(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, String jarPath, String entryPrefix) {
        super(factory, internMap, entryPrefix, name, jarPath);
        String methodName = "<init>";
        this.jarPath = jarPath;
        this.absJarPath = ClassSourceImpl_MappedJar.getAbsolutePath(jarPath);
        this.rawJarFile = new File(jarPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Exists [ {2} ] IsDir [ {3} ]", new Object[]{this.hashText, this.jarPath, this.rawJarFile.exists(), this.rawJarFile.isFile()});
        }
    }

    @Override
    protected String computeStamp() {
        String methodName = "computeStamp";
        File useJarFile = this.getRawJarFile();
        String useStamp = UtilImpl_FileStamp.computeStamp(useJarFile);
        if (useStamp == null) {
            useStamp = "** UNAVAILABLE **";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, MessageFormat.format("[ {0} ] File [ {1} ] Stamp [ {2} ]", this.getHashText(), useJarFile, useStamp));
        }
        return useStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), this.opens});
        }
        if (this.opens == 0) {
            try {
                this.jarFile = UtilImpl_FileUtils.createJarFile(this.jarPath);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"142", (Object)this, (Object[])new Object[0]);
                String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + this.getAbsJarPath() + " ]";
                throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
            }
        }
        ++this.opens;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ]", new Object[]{this.getHashText(), this.opens});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), this.opens});
        }
        if (this.opens != 0) {
            --this.opens;
            if (this.opens == 0) {
                JarFile useJarFile = this.jarFile;
                this.jarFile = null;
                try {
                    useJarFile.close();
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"179", (Object)this, (Object[])new Object[0]);
                    String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + this.getAbsJarPath() + " ]";
                    throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ]", new Object[]{this.getHashText(), this.opens});
        }
    }

    @Override
    public String getJarPath() {
        return this.jarPath;
    }

    @Trivial
    public String getAbsJarPath() {
        return this.absJarPath;
    }

    public File getRawJarFile() {
        return this.rawJarFile;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected boolean hasPrefix(String resourceName) {
        String useEntryPrefix = this.getEntryPrefix();
        if (useEntryPrefix == null) {
            return true;
        }
        int prefixLen = useEntryPrefix.length();
        int entryLen = resourceName.length();
        if (entryLen < prefixLen + 1) {
            return false;
        }
        return resourceName.regionMatches(0, useEntryPrefix, 0, entryLen);
    }

    protected String removePrefix(String resourceName) {
        String useEntryPrefix = this.getEntryPrefix();
        if (useEntryPrefix == null) {
            return resourceName;
        }
        return resourceName.substring(useEntryPrefix.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        JarFile useJarFile = this.getJarFile();
        if (useJarFile == null) {
            String eMsg = "[ " + this.getHashText() + " ] is closed; processing [ " + resourceName + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        JarEntry jarEntry = useJarFile.getJarEntry(resourceName);
        if (jarEntry == null) {
            return null;
        }
        try {
            result = useJarFile.getInputStream(jarEntry);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"278", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] for class [ " + className + " ] in [ " + this.getAbsJarPath() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"302", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_CLOSE6_EXCEPTION", new Object[]{this.getHashText(), resourceName, className, this.getAbsJarPath(), e});
        }
    }

    @Override
    public void log(Logger useLogger) {
        String methodName = "log";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source [ {0} ]", this.getHashText());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int processFromScratch(ClassSource_Streamer streamer) throws ClassSource_Exception {
        String methodName = "processFromScratch";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        JarFile useJarFile = this.getJarFile();
        int numClasses = 0;
        int numEntries = 0;
        Enumeration<JarEntry> jarEntries = useJarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            String nextEntryName = nextEntry.getName();
            ++numEntries;
            if (!this.hasPrefix(nextEntryName) || this.isDirectoryResource(nextEntryName) || !this.isClassResource(nextEntryName)) continue;
            ++numClasses;
            String nextClassName = this.getClassNameFromResourceName(this.removePrefix(nextEntryName));
            if (ClassSourceImpl.isJava9PackageName(nextClassName)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Java9 class name [ {0} ]", nextClassName);
                continue;
            }
            String i_nextClassName = this.internClassName(nextClassName);
            try {
                this.scan(streamer, i_nextClassName, nextEntryName);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"364", (Object)this, (Object[])new Object[]{streamer});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION [ {0} ]", (Throwable)e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN Entries [ {1} ] Classes [ {2} ]", new Object[]{this.getHashText(), numEntries, numClasses});
        }
        return numClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processSpecific(ClassSource_Streamer streamer, Set<String> i_classNames) throws ClassSource_Exception {
        String methodName = "processSpecific";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), i_classNames.size()});
        }
        long scanStart = System.nanoTime();
        JarFile useJarFile = this.getJarFile();
        Enumeration<JarEntry> jarEntries = useJarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            String nextEntryName = nextEntry.getName();
            if (!this.hasPrefix(nextEntryName) || this.isDirectoryResource(nextEntryName) || !this.isClassResource(nextEntryName)) continue;
            String nextClassName = this.getClassNameFromResourceName(this.removePrefix(nextEntryName));
            if (ClassSourceImpl.isJava9PackageName(nextClassName)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Java9 class name [ {0} ]", nextClassName);
                continue;
            }
            String i_className = this.internClassName(nextClassName, false);
            if (i_className == null || !i_classNames.contains(i_className)) continue;
            try {
                this.scan(streamer, i_className, nextEntryName);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"420", (Object)this, (Object[])new Object[]{streamer, i_classNames});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION [ {0} ]", (Throwable)e);
            }
        }
        long scanTime = System.nanoTime() - scanStart;
        this.setProcessTime(scanTime);
        this.setProcessCount(i_classNames.size());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(ClassSource_Streamer streamer, String i_className, String resourceName) throws ClassSource_Exception {
        BufferedInputStream inputStream = this.openClassResourceStream(i_className, resourceName);
        try {
            streamer.process(i_className, inputStream);
        }
        finally {
            this.closeResourceStream(i_className, resourceName, inputStream);
        }
    }

    @Override
    protected boolean basicHasJandexIndex() {
        return this.getJarFile().getJarEntry(this.getJandexIndexPath()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Index basicGetJandexIndex() {
        BufferedInputStream jandexStream;
        String methodName = "basicGetJandexIndex";
        String useJandexIndexPath = this.getJandexIndexPath();
        try {
            jandexStream = this.openResourceStream(null, useJandexIndexPath, 32768);
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"466", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.SEVERE, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ENTRY_JANDEX_OPEN_EXCEPTION", new Object[]{this.getHashText(), useJandexIndexPath, ClassSourceImpl_MappedJar.getAbsolutePath(this.getRawJarFile().getAbsolutePath()), e});
            return null;
        }
        if (jandexStream == null) {
            return null;
        }
        try {
            Index jandexIndex = Jandex_Utils.basicReadIndex(jandexStream);
            if (logger.isLoggable(Level.FINER)) {
                String message = MessageFormat.format("[ {0} ] Read JANDEX index [ {1} ] from [ {2} ] Classes  [ {3} ]", this.getHashText(), ClassSourceImpl_MappedJar.getAbsolutePath(useJandexIndexPath), this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size()));
                logger.logp(Level.FINER, CLASS_NAME, methodName, message);
            }
            return jandexIndex;
        }
        catch (IOException jandexIndex) {
            void e;
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"494", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.SEVERE, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ENTRY_JANDEX_READ_EXCEPTION", new Object[]{this.getHashText(), useJandexIndexPath, ClassSourceImpl_MappedJar.getAbsolutePath(this.getRawJarFile().getAbsolutePath()), e});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SparseIndex basicGetSparseJandexIndex() {
        BufferedInputStream jandexStream;
        String methodName = "basicGetSparseJandexIndex";
        String useJandexIndexPath = this.getJandexIndexPath();
        try {
            jandexStream = this.openResourceStream(null, useJandexIndexPath, 32768);
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"520", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.SEVERE, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ENTRY_JANDEX_OPEN_EXCEPTION", new Object[]{this.getHashText(), useJandexIndexPath, ClassSourceImpl_MappedJar.getAbsolutePath(this.getRawJarFile().getAbsolutePath()), e});
            return null;
        }
        if (jandexStream == null) {
            return null;
        }
        try {
            SparseIndex jandexIndex = Jandex_Utils.basicReadSparseIndex(jandexStream);
            if (logger.isLoggable(Level.FINER)) {
                String message = MessageFormat.format("[ {0} ] Read sparse JANDEX index [ {1} ] from [ {2} ] Classes  [ {3} ]", this.getHashText(), ClassSourceImpl_MappedJar.getAbsolutePath(useJandexIndexPath), this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size()));
                logger.logp(Level.FINER, CLASS_NAME, methodName, message);
            }
            return jandexIndex;
        }
        catch (IOException jandexIndex) {
            void e;
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", (String)"549", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.SEVERE, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ENTRY_JANDEX_READ_EXCEPTION", new Object[]{this.getHashText(), useJandexIndexPath, ClassSourceImpl_MappedJar.getAbsolutePath(this.getRawJarFile().getAbsolutePath()), e});
            return null;
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent tc) {
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.logCounts(tc);
    }

    @Override
    public void setParentSource(ClassSource classSource) {
    }

    @Override
    public void scanClasses(com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanSpecificSeedClass(String specificClassName, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanReferencedClass(String referencedClassNam, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        return null;
    }

    @Override
    public String outconvertResourceName(String internalResourceName) {
        return null;
    }

    @Override
    public InputStream openClassStream(String className) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return null;
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
    }

    @Override
    public ClassSource_ScanCounts getScanResults() {
        return null;
    }

    @Override
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return 0;
    }

    @Override
    public int getResourceExclusionCount() {
        return 0;
    }

    @Override
    public int getClassExclusionCount() {
        return 0;
    }

    @Override
    public int getClassInclusionCount() {
        return 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar", ClassSourceImpl_MappedJar.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_MappedJar.class.getSimpleName();
    }
}

