/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.schema.GraphQLSchemaElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

@PublicApi
public class GraphqlElementParentTree {
    private final GraphQLSchemaElement element;
    private final GraphqlElementParentTree parent;

    @Internal
    public GraphqlElementParentTree(Deque<GraphQLSchemaElement> nodeStack) {
        Assert.assertNotNull(nodeStack, "You MUST have a non null stack of elements", new Object[0]);
        Assert.assertTrue(!nodeStack.isEmpty(), "You MUST have a non empty stack of element", new Object[0]);
        ArrayDeque<GraphQLSchemaElement> copy = new ArrayDeque<GraphQLSchemaElement>(nodeStack);
        this.element = (GraphQLSchemaElement)copy.pop();
        this.parent = !copy.isEmpty() ? new GraphqlElementParentTree(copy) : null;
    }

    public GraphQLSchemaElement getElement() {
        return this.element;
    }

    public Optional<GraphqlElementParentTree> getParentInfo() {
        return Optional.ofNullable(this.parent);
    }

    public List<GraphQLSchemaElement> toList() {
        ArrayList<GraphQLSchemaElement> types = new ArrayList<GraphQLSchemaElement>();
        types.add(this.element);
        Optional<GraphqlElementParentTree> parentInfo = this.getParentInfo();
        while (parentInfo.isPresent()) {
            types.add(parentInfo.get().getElement());
            parentInfo = parentInfo.get().getParentInfo();
        }
        return types;
    }

    public String toString() {
        return String.valueOf(this.element) + " - parent : " + this.parent;
    }
}

