/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.probeExtensionImpl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.interrupt.InterruptibleRequestLifecycle;
import com.ibm.ws.request.timing.internal.config.HungRequestTimingConfig;
import com.ibm.ws.request.timing.manager.HungRequestManager;
import com.ibm.ws.request.timing.manager.ProbationaryRequestManager;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.HungRequest;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class HungRequestProbeExtension
implements ProbeExtension,
Introspector {
    private static final TraceComponent tc = Tr.register(HungRequestProbeExtension.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private volatile HungRequestTimingConfig config = new HungRequestTimingConfig();
    public final ConcurrentHashMap<String, AtomicLong> requestCounts = new ConcurrentHashMap();
    private final DelayedRequestQueue<HungRequest> requestQueue = new DelayedRequestQueue();
    private final ProbationaryRequestManager<HungRequestTimingConfig, HungRequest> probHungReqMgr = new ProbationaryRequestManager<HungRequestTimingConfig, HungRequest>(this.config, this.requestQueue, HungRequest.class);
    private final HungRequestManager hungReqMgr = new HungRequestManager(this.requestQueue);
    private InterruptibleRequestLifecycle interruptLifecycle = null;
    private volatile boolean hasStopped = false;

    public void processEntryEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processEntryEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            this.probHungReqMgr.setLastRequestTime(System.nanoTime());
            this.probHungReqMgr.startTimer();
            this.hungReqMgr.startHandler();
            this.config.incrementTimingConfigForRequest(requestContext, this.requestCounts);
            if (this.config.isRequestInterruptEnabled()) {
                this.interruptLifecycle.newRequestEntry(requestContext.getRequestId().getId());
            }
        }
    }

    public void processExitEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processExitEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            this.hungReqMgr.logMessageIfHung(requestContext);
            if (this.config.isRequestInterruptEnabled()) {
                this.interruptLifecycle.completedRequestExit(requestContext.getRequestId().getId());
            }
        }
    }

    public void setConfig(HungRequestTimingConfig config) {
        this.config = config;
        this.probHungReqMgr.setConfig(config);
        this.hungReqMgr.setInterruptibleRequestLifecycle(config.isRequestInterruptEnabled() ? this.interruptLifecycle : null);
    }

    public void updateConfig(HungRequestTimingConfig config) {
        this.config = config;
        this.probHungReqMgr.resetTimer(this.config);
        this.hungReqMgr.setInterruptibleRequestLifecycle(config.isRequestInterruptEnabled() ? this.interruptLifecycle : null);
    }

    public void stop() {
        if (!this.hasStopped) {
            this.hasStopped = true;
            this.probHungReqMgr.stopTimer();
            this.hungReqMgr.stopHandler();
            this.requestQueue.clear();
            this.requestCounts.clear();
        }
    }

    public void processCounter(Event event) {
    }

    public int getRequestSampleRate() {
        return this.config.getSampleRate();
    }

    public boolean invokeForRootEventsOnly() {
        return true;
    }

    public boolean invokeForEventEntry() {
        return true;
    }

    public boolean invokeForEventExit() {
        return true;
    }

    public List<String> invokeForEventTypes() {
        return null;
    }

    public boolean invokeForCounter() {
        return false;
    }

    public int getContextInfoRequirement() {
        return this.config.getContextInfoRequirement();
    }

    public String getIntrospectorName() {
        return "HungRequestProbeExtensionIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Provides information on how requestTiming-1.0 is assigning timing thresholds to requests";
    }

    public void introspect(PrintWriter out) throws Exception {
        this.config.writeIntrospectionData(out);
    }

    protected void setInterruptibleRequestLifecycle(InterruptibleRequestLifecycle lifecycle) {
        this.interruptLifecycle = lifecycle;
    }

    protected void unsetInterruptibleRequestLifecycle(InterruptibleRequestLifecycle lifecycle) {
        this.interruptLifecycle = null;
    }

    public long getTotalRequestCount(String type) {
        AtomicLong requestCount = this.requestCounts.get(type);
        if (requestCount != null) {
            return requestCount.get();
        }
        return 0L;
    }

    public long getHungRequestCount(String type) {
        return this.hungReqMgr.countHungRequests(type);
    }
}

