/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CORBANameParser;
import org.apache.yoko.orb.OB.CorbalocURLScheme;
import org.apache.yoko.orb.OB.CorbalocURLSchemeHelper;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.TypeCodeFactory;
import org.apache.yoko.orb.OB.URLRegistry;
import org.apache.yoko.orb.OB.URLScheme;
import org.apache.yoko.orb.OB.URLUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;

public class CorbanameURLScheme_impl
extends LocalObject
implements URLScheme {
    private ORB orb_;
    private CorbalocURLScheme corbaloc_;

    public CorbanameURLScheme_impl(ORB orb, URLRegistry registry) {
        this.orb_ = orb;
        URLScheme scheme = registry.find_scheme("corbaloc");
        Assert.ensure(scheme != null);
        this.corbaloc_ = CorbalocURLSchemeHelper.narrow(scheme);
        Assert.ensure(this.corbaloc_ != null);
    }

    @Override
    public String name() {
        return "corbaname";
    }

    @Override
    public Object parse_url(String url) {
        Throwable failureCause;
        int slash = url.indexOf(47);
        int fragmentStart = url.indexOf(35);
        String keyStr = slash != -1 && fragmentStart == -1 ? url.substring(slash + 1) : (slash == -1 || fragmentStart - 1 == slash || fragmentStart < slash ? "NameService" : url.substring(slash + 1, fragmentStart));
        int addrStart = 10;
        if (addrStart == slash) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": no protocol address", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int addrEnd = slash == -1 && fragmentStart == -1 ? url.length() - 1 : (slash != -1 && fragmentStart == -1 || slash != -1 && fragmentStart != -1 && slash < fragmentStart ? slash - 1 : fragmentStart - 1);
        String corbaloc = "corbaloc:" + url.substring(addrStart, addrEnd + 1) + "/" + keyStr;
        Object nc = this.corbaloc_.parse_url(corbaloc);
        if (fragmentStart == -1 || url.substring(fragmentStart).length() == 0) {
            return nc;
        }
        try {
            StructMember[] contents = new StructMember[2];
            contents[0] = new StructMember();
            contents[0].name = "id";
            contents[0].type = TypeCodeFactory.createStringTC(0);
            contents[1] = new StructMember();
            contents[1].name = "kind";
            contents[1].type = TypeCodeFactory.createStringTC(0);
            TypeCode tcNameComponent = TypeCodeFactory.createStructTC("IDL:omg.org/CosNaming/NameComponent:1.0", "NameComponent", contents);
            TypeCode tcName = TypeCodeFactory.createSequenceTC(0, tcNameComponent);
            String fragment = URLUtil.unescapeURL(url.substring(fragmentStart + 1));
            CORBANameParser parser = new CORBANameParser(fragment);
            if (!parser.isValid()) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": invalid stringified name \"" + fragment + "\"", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            String[] content = parser.getContents();
            Assert.ensure(content.length % 2 == 0);
            Object factoryObj = this.orb_.resolve_initial_references("DynAnyFactory");
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow((Object)factoryObj);
            Any[] as = new Any[content.length / 2];
            for (int i = 0; i < content.length; i += 2) {
                DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcNameComponent);
                DynStruct name = DynStructHelper.narrow((Object)dynAny);
                name.insert_string(content[i]);
                name.next();
                name.insert_string(content[i + 1]);
                Any nany = name.to_any();
                name.destroy();
                as[i / 2] = nany;
            }
            DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcName);
            DynSequence seq = DynSequenceHelper.narrow((Object)dynAny);
            seq.set_length(as.length);
            seq.set_elements(as);
            Any any = seq.to_any();
            seq.destroy();
            Request request = nc._request("resolve");
            Any arg = request.add_in_arg();
            arg.read_value(any.create_input_stream(), any.type());
            request.set_return_type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_objref));
            request.invoke();
            failureCause = request.env().exception();
            if (failureCause == null) {
                return request.return_value().extract_Object();
            }
        }
        catch (SystemException ex) {
            failureCause = ex;
        }
        catch (UserException ex) {
            failureCause = ex;
        }
        BAD_PARAM bp = new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": corbaname evaluation error:" + failureCause.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO);
        throw (BAD_PARAM)bp.initCause(failureCause);
    }

    @Override
    public void destroy() {
        this.orb_ = null;
    }
}

