/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.InternalError;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo_impl;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;

public final class Transport_impl
extends LocalObject
implements Transport {
    public final Socket socket_;
    private final InputStream in_;
    private final OutputStream out_;
    private volatile boolean shutdown_;
    private int soTimeout_ = 0;
    private final TransportInfo_impl info_;
    private static final Logger logger = Logger.getLogger(Transport.class.getName());

    private void setSoTimeout(int t) {
        if (this.soTimeout_ != t) {
            this.soTimeout_ = t;
            try {
                this.socket_.setSoTimeout(this.soTimeout_);
            }
            catch (SocketException ex) {
                logger.log(Level.FINE, "Socket setup error", ex);
                throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974938) + ": socket error during setSoTimeout: " + ex.getMessage(), 1095974938, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket setup error", ex);
                throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974938) + ": NullPointerException error during setSoTimeout: " + ex.getMessage(), 1095974938, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
            }
        }
    }

    private void setBlock(boolean block) {
        if (block) {
            this.setSoTimeout(0);
        } else {
            this.setSoTimeout(1);
        }
    }

    private void shutdownSocket() {
        try {
            try {
                this.socket_.shutdownInput();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                this.socket_.shutdownOutput();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        catch (SocketException socketException) {
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket shutdown error", ex);
            throw (InternalError)new InternalError().initCause(ex);
        }
    }

    @Override
    public SendReceiveMode mode() {
        return SendReceiveMode.SendReceive;
    }

    @Override
    public void close() {
        this.shutdownSocket();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        logger.info("shutdown: " + this);
        this.shutdown_ = true;
        this.shutdownSocket();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void receive(WriteBuffer writeBuffer, boolean block) {
        this.setBlock(block);
        logger.fine("receiving a buffer of " + writeBuffer.available() + " from " + this.socket_ + " using transport " + this);
        while (!writeBuffer.isComplete()) {
            try {
                if (writeBuffer.readFrom(this.in_)) continue;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
            }
            catch (InterruptedIOException ex) {
                logger.log(Level.FINE, "Received interrupted exception", ex);
                if (!block) {
                    return;
                }
                if (!this.shutdown_) continue;
                throw Exceptions.asCommFailure(ex, 1095974913, "Interrupted I/O exception during shutdown");
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "I/O error during read");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "NullPointerException during read");
            }
        }
    }

    @Override
    public void send(ReadBuffer readBuffer, boolean block) {
        this.setBlock(block);
        logger.fine("Sending buffer of size " + readBuffer.available() + " to " + this.socket_);
        while (!readBuffer.isComplete()) {
            try {
                readBuffer.writeTo(this.out_);
            }
            catch (InterruptedIOException ex) {
                if (block) continue;
                return;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "I/O error during write");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "NullPointerException during write");
            }
        }
    }

    @Override
    public boolean send_detect(ReadBuffer readBuffer, boolean block) {
        this.setBlock(block);
        while (!readBuffer.isComplete()) {
            try {
                readBuffer.writeTo(this.out_);
            }
            catch (InterruptedIOException ex) {
                if (block) continue;
                return true;
            }
            catch (IOException | NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void send_timeout(ReadBuffer readBuffer, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            this.send(readBuffer, false);
            return;
        }
        this.setSoTimeout(t);
        while (!readBuffer.isComplete()) {
            try {
                readBuffer.writeTo(this.out_);
            }
            catch (InterruptedIOException ex) {
                return;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "I/O error during write");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "NullPointerException during write");
            }
        }
    }

    @Override
    public TransportInfo get_info() {
        return this.info_;
    }

    public Transport_impl(Socket socket, ListenerMap lm) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            throw Exceptions.asCommFailure(ex, 1095974917, "unable to obtain socket InputStream");
        }
        this.info_ = new TransportInfo_impl(this, lm);
    }

    public Transport_impl(Acceptor acceptor, Socket socket, ListenerMap lm) {
        this.socket_ = socket;
        this.shutdown_ = false;
        logger.fine("Creating new transport for socket " + socket);
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            throw Exceptions.asCommFailure(ex, 1095974917, "unable to obtain socket InputStream");
        }
        this.info_ = new TransportInfo_impl(this, acceptor, lm);
    }

    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }

    public String toString() {
        return String.format("Transport to %s with socket %s", this.info_, this.socket_);
    }
}

