/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.common.claims.UserClaimsRetrieverService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.internal.AuthnContextImpl;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.ClientAuthnData;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import com.ibm.ws.security.oauth20.web.WebUtils;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.TokenIntrospectProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenIntrospect {
    private static TraceComponent tc = Tr.register(TokenIntrospect.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static TraceComponent tcMsg = Tr.register(TokenIntrospect.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String DEFAULT_GROUP_IDENTIFIER = "groupIds";
    public static final String KEY_TOKEN_INTROSPECT_PROVIDER = "tokenIntrospectProvider";
    private static ConcurrentServiceReferenceMap<String, TokenIntrospectProvider> tokenIntrospectProviderRef = new ConcurrentServiceReferenceMap("tokenIntrospectProvider");
    static final long serialVersionUID = 9033018307517031607L;

    public static void setTokenIntrospect(ConcurrentServiceReferenceMap<String, TokenIntrospectProvider> tokenIntProviderRef) {
        tokenIntrospectProviderRef = tokenIntProviderRef;
    }

    /*
     * WARNING - void declaration
     */
    public void introspect(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        String accessTokenString = request.getParameter("token");
        if (accessTokenString == null || accessTokenString.isEmpty()) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_INTROSPECT_NO_TOKEN", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1405E: The introspect request did not have a token parameter. The request URI was {0}.");
            WebUtils.sendErrorJSON(response, 400, "invalid_request", errorMsg);
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            return;
        }
        JSONObject responseJSON = new JSONObject();
        String tokenLookupStr = accessTokenString;
        boolean isAppPasswordOrToken = false;
        if (OidcOAuth20Util.isJwtToken(accessTokenString)) {
            tokenLookupStr = HashUtils.digest(accessTokenString);
        } else if (tokenLookupStr.length() == provider.getAccessTokenLength() + 2) {
            String encode = provider.getAccessTokenEncoding();
            tokenLookupStr = "plain".equals(encode) ? EndpointUtils.computeTokenHash(accessTokenString) : EndpointUtils.computeTokenHash(accessTokenString, encode);
            isAppPasswordOrToken = true;
        }
        OAuth20Token accessToken = null;
        accessToken = isAppPasswordOrToken ? provider.getTokenCache().getByHash(tokenLookupStr) : provider.getTokenCache().get(tokenLookupStr);
        if (accessToken != null) {
            boolean isAppPassword;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token type: " + accessToken.getType() + " grant type: " + accessToken.getGrantType()), (Object[])new Object[0]);
            }
            boolean isAccessToken = accessToken.getType().equals("access_token");
            boolean bl = isAppPassword = accessToken.getGrantType() != null && accessToken.getGrantType().equals("app_password");
            if (!isAccessToken || isAppPassword) {
                Tr.error((TraceComponent)tcMsg, (String)"OAUTH_SERVER_INVALID_ACCESS_TOKEN", (Object[])new Object[0]);
                responseJSON.put((Object)"active", (Object)false);
                WebUtils.setJSONResponse(response, 200, responseJSON);
                return;
            }
        }
        ClientAuthnData clientAuthData = null;
        try {
            clientAuthData = new ClientAuthnData(request, response);
        }
        catch (OAuth20DuplicateParameterException isAppPassword) {
            void e;
            FFDCFilter.processException((Throwable)isAppPassword, (String)"com.ibm.ws.security.oauth20.web.TokenIntrospect", (String)"134", (Object)this, (Object[])new Object[]{provider, request, response});
            WebUtils.sendErrorJSON(response, 400, "invalid_request", e.getMessage());
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            return;
        }
        if (!clientAuthData.hasAuthnData()) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_INVALID_CLIENT", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1406E: The introspect request had an invalid client credential. The request URI was {0}.");
            WebUtils.sendErrorJSON(response, 400, "invalid_client", errorMsg);
            Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.client.auth.error", (Object[])new Object[]{accessToken.getClientId()});
            return;
        }
        OidcBaseClient client = null;
        client = provider.getClientProvider().get(clientAuthData.getUserName());
        if (!client.isIntrospectTokens()) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_INTROSPECT_CLIENT_NOT_AUTHORIZED", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1419E: The client is not authorized to introspect access tokens. The request URI was {0}.");
            WebUtils.sendErrorJSON(response, 400, "invalid_client", errorMsg);
            String serverLogMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_INTROSPECT_CLIENT_NOT_AUTHORIZED_SERVER_LOG", (Object[])new Object[]{clientAuthData.getUserName(), request.getRequestURI()}, (String)"CWWKS1420E: The client {0} is not authorized to introspect access tokens. The request URI was {1}.");
            Tr.error((TraceComponent)tc, (String)serverLogMsg, (Object[])new Object[0]);
            return;
        }
        if (accessToken == null || OAuth20TokenHelper.isTokenExpired(accessToken)) {
            responseJSON.put((Object)"active", (Object)false);
            Tr.error((TraceComponent)tcMsg, (String)"OAUTH_SERVER_INVALID_ACCESS_TOKEN", (Object[])new Object[0]);
            WebUtils.setJSONResponse(response, 200, responseJSON);
        } else {
            if (!this.isClientAllowedToIntrospectToken(accessToken, client, provider)) {
                responseJSON.put((Object)"active", (Object)false);
                WebUtils.setJSONResponse(response, 200, responseJSON);
                return;
            }
            if (tokenIntrospectProviderRef.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tokenIntrospectProviderRef.isEmpty", (Object[])new Object[0]);
                }
                this.introspectActive(provider, request, response, accessToken, client);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tokenIntrospectProviderRef is not Empty", (Object[])new Object[0]);
                }
                this.callTokenIntrospect(request, response, accessToken);
            }
        }
    }

    boolean isClientAllowedToIntrospectToken(OAuth20Token accessToken, OidcBaseClient client, OAuth20Provider provider) {
        boolean isAppToken;
        boolean bl = isAppToken = accessToken.getGrantType() != null && accessToken.getGrantType().equals("app_token");
        if (!isAppToken) {
            return true;
        }
        String[] usedByArray = accessToken.getUsedBy();
        String clientIdFromAuthnData = client.getClientId();
        if (usedByArray == null) {
            Map<String, String[]> extensionProperties = accessToken.getExtensionProperties();
            if (extensionProperties != null) {
                extensionProperties.put("com.ibm.wsspi.security.oidc.external.claims:used_by", new String[]{clientIdFromAuthnData});
                if (!provider.isLocalStoreUsed()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("persist the token : " + accessToken.getId() + " to database after adding usedBy ext with the client : " + clientIdFromAuthnData), (Object[])new Object[0]);
                    }
                    OAuth20EnhancedTokenCache cache = provider.getTokenCache();
                    cache.remove(accessToken.getId());
                    cache.add(accessToken.getId(), accessToken, accessToken.getLifetimeSeconds());
                }
                return true;
            }
            return false;
        }
        List<String> usedBy = Arrays.asList(usedByArray);
        if (usedBy.contains(clientIdFromAuthnData)) {
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Client : " + clientIdFromAuthnData + " is not specified in the usedBy ext of the app token : " + accessToken.getId()), (Object[])new Object[0]);
        }
        return false;
    }

    void callTokenIntrospect(HttpServletRequest request, HttpServletResponse response, OAuth20Token accessToken) throws IOException {
        TokenIntrospectProvider tokenIntrospectProvider = null;
        Iterator it = tokenIntrospectProviderRef.getServices();
        JSONObject providerJSON = null;
        int providersInstalled = tokenIntrospectProviderRef.size();
        while (it.hasNext()) {
            tokenIntrospectProvider = (TokenIntrospectProvider)it.next();
            providerJSON = this.getJsonObjectFromTokenIntrospectProvider(accessToken, tokenIntrospectProvider, request, response);
            if (providerJSON == null) continue;
            if (providersInstalled <= 1) break;
            Tr.info((TraceComponent)tcMsg, (String)"OAUTH_SERVER_MULTIPLE_TOKEN_INTROSPECT_PROVIDER_CONFIGURED", (Object[])new Object[0]);
            break;
        }
        if (providerJSON == null) {
            response.sendError(500);
            Tr.error((TraceComponent)tcMsg, (String)"OAUTH_SERVER_TOKEN_INTROSPECT_PROVIDER_INTERNAL_ERROR", (Object[])new Object[]{accessToken.getUsername(), tokenIntrospectProvider.getClass().getName()});
            return;
        }
        WebUtils.setJSONResponse(response, 200, providerJSON);
    }

    private JSONObject getJsonObjectFromTokenIntrospectProvider(OAuth20Token accessToken, TokenIntrospectProvider tokenIntrospectProvider, HttpServletRequest request, HttpServletResponse response) {
        AuthnContextImpl authnContext = new AuthnContextImpl(request, response, accessToken.getTokenString(), accessToken.getScope(), accessToken.getCreatedAt(), accessToken.getLifetimeSeconds(), accessToken.getUsername(), accessToken.getExtensionProperties());
        String strJsonObject = tokenIntrospectProvider.getUserInfo(authnContext);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserInfo:'" + strJsonObject + "'"), (Object[])new Object[0]);
        }
        if (strJsonObject != null) {
            try {
                return JSONObject.parse((String)strJsonObject);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.TokenIntrospect", (String)"296", (Object)this, (Object[])new Object[]{accessToken, tokenIntrospectProvider, request, response});
                return null;
            }
        }
        return null;
    }

    public void introspectActive(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuth20Token accessToken, OidcBaseClient client) throws OidcServerException, IOException {
        String grantType;
        JSONObject responseJSON = new JSONObject();
        responseJSON.put((Object)"active", (Object)true);
        responseJSON.put((Object)"sub", (Object)accessToken.getUsername());
        responseJSON.put((Object)"client_id", (Object)accessToken.getClientId());
        String scopes = this.getScopes(accessToken);
        responseJSON.put((Object)"scope", (Object)scopes);
        long iat = accessToken.getCreatedAt() / 1000L;
        responseJSON.put((Object)"iat", (Object)iat);
        long exp = iat + (long)accessToken.getLifetimeSeconds();
        responseJSON.put((Object)"exp", (Object)exp);
        responseJSON.put((Object)"token_type", (Object)"Bearer");
        responseJSON.put((Object)"iss", (Object)this.getCalculatedIssuerId(provider, request));
        Map<String, Object> userClaimsMap = TokenIntrospect.getUserClaims(provider, accessToken, false);
        if (userClaimsMap != null) {
            responseJSON.putAll(userClaimsMap);
        }
        if ((grantType = accessToken.getGrantType()) != null && !grantType.isEmpty()) {
            responseJSON.put((Object)"grant_type", (Object)grantType);
            if (grantType.equals("client_credentials") && (client = provider.getClientProvider().get(accessToken.getClientId())).getFunctionalUserId() != null) {
                responseJSON.put((Object)"functional_user_id", (Object)client.getFunctionalUserId());
                if (client.getFunctionalUserGroupIds() != null && !client.getFunctionalUserGroupIds().isJsonNull() && client.getFunctionalUserGroupIds().size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("client.getFunctionalUserGroupIds(): " + client.getFunctionalUserGroupIds()), (Object[])new Object[0]);
                    }
                    JSONArray groupIds = JSONArray.parse((String)client.getFunctionalUserGroupIds().toString());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupIds: " + groupIds), (Object[])new Object[0]);
                    }
                    responseJSON.put((Object)"functional_user_groupIds", (Object)groupIds);
                }
            }
        }
        WebUtils.setJSONResponse(response, 200, responseJSON);
    }

    private String getCalculatedIssuerId(OAuth20Provider provider, HttpServletRequest request) {
        String issuerIdentifier = this.getCalculatedIssuerIdFromOidcServerConfig(provider);
        if (issuerIdentifier == null) {
            issuerIdentifier = this.getCalculatedIssuerIdFromRequest(request);
        }
        return issuerIdentifier;
    }

    private String getCalculatedIssuerIdFromOidcServerConfig(OAuth20Provider provider) {
        if (provider == null) {
            return null;
        }
        OidcServerConfig oidcServerConfig = ConfigUtils.getOidcServerConfigForOAuth20Provider(provider.getID());
        if (oidcServerConfig == null) {
            return null;
        }
        return oidcServerConfig.getIssuerIdentifier();
    }

    private String getCalculatedIssuerIdFromRequest(HttpServletRequest request) {
        String hostname = request.getServerName();
        String scheme = request.getScheme();
        int port = request.getLocalPort();
        String path = request.getRequestURI();
        int lastSlashIndex = path.lastIndexOf("/");
        String issuerIdentifier = scheme + "://" + hostname + ":" + port + path.substring(0, lastSlashIndex);
        return issuerIdentifier;
    }

    private String getScopes(OAuth20Token accessToken) {
        StringBuffer sb = new StringBuffer();
        String[] scopeArray = accessToken.getScope();
        if (scopeArray != null) {
            for (String scope : scopeArray) {
                sb.append(scope);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    protected static Map<String, Object> getUserClaims(OAuth20Provider provider, OAuth20Token accessToken, boolean groupsOnly) throws IOException {
        UserClaims userClaims = TokenIntrospect.getUserClaimsObj(provider, accessToken);
        Map<String, Object> userClaimsMap = TokenIntrospect.getUserClaimsMap(userClaims, groupsOnly);
        return userClaimsMap;
    }

    protected static Map<String, Object> getUserClaimsMap(UserClaims userClaims, boolean groupsOnly) throws IOException {
        Map<String, Object> userClaimsMap = null;
        if (userClaims != null) {
            String groupIdentifier = userClaims.getGroupIdentifier();
            Map<String, Object> claimsMap = userClaims.asMap();
            userClaimsMap = groupsOnly ? new HashMap<String, Object>() : claimsMap;
            if (claimsMap.get(groupIdentifier) != null) {
                JSONArray groups = new JSONArray();
                groups.addAll(userClaims.getGroups());
                userClaimsMap.put(groupIdentifier, groups);
            }
        }
        return userClaimsMap;
    }

    protected static UserClaims getUserClaimsObj(OAuth20Provider provider, OAuth20Token accessToken) throws IOException {
        UserClaims userClaims = null;
        UserClaimsRetrieverService ucrService = ConfigUtils.getUserClaimsRetrieverService();
        if (ucrService != null) {
            String groupIdentifier = TokenIntrospect.getGroupIdentifier(provider);
            userClaims = ucrService.getUserClaims(accessToken.getUsername(), groupIdentifier);
        }
        return userClaims;
    }

    private static String getGroupIdentifier(OAuth20Provider oauth20provider) {
        String groupIdentifier = DEFAULT_GROUP_IDENTIFIER;
        OidcServerConfig oidcServerConfig = ConfigUtils.getOidcServerConfigForOAuth20Provider(oauth20provider.getID());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OidcServerConfig: " + oidcServerConfig), (Object[])new Object[0]);
        }
        if (oidcServerConfig != null) {
            groupIdentifier = oidcServerConfig.getGroupIdentifier();
        }
        return groupIdentifier;
    }
}

