/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.HttpMessageContextImpl;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthModule
implements ServerAuthModule {
    private static final TraceComponent tc = Tr.register(AuthModule.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private static Class[] supportedMessageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private MessagePolicy requestPolicy;
    private CallbackHandler handler;
    private Map<String, String> options;
    static final long serialVersionUID = -5126565670194755750L;

    public Class[] getSupportedMessageTypes() {
        return supportedMessageTypes;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.requestPolicy = requestPolicy;
        this.handler = handler;
        this.options = new HashMap<String, String>();
        if (options != null) {
            this.options.putAll(options);
        }
        if (tc.isDebugEnabled() && requestPolicy != null && requestPolicy.getTargetPolicies() != null) {
            for (MessagePolicy.TargetPolicy target : requestPolicy.getTargetPolicies()) {
                MessagePolicy.ProtectionPolicy protectionPolicy = target.getProtectionPolicy();
                if (protectionPolicy == null) continue;
                Tr.debug((TraceComponent)tc, (String)("Target request ProtectionPolicy=" + protectionPolicy.getID()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        AuthStatus status = AuthStatus.SEND_FAILURE;
        try {
            HttpAuthenticationMechanism authMech = this.getModulePropertiesUtils().getHttpAuthenticationMechanism();
            HttpMessageContext httpMessageContext = this.createHttpMessageContext(messageInfo, clientSubject);
            AuthenticationStatus authenticationStatus = authMech.validateRequest((HttpServletRequest)messageInfo.getRequestMessage(), (HttpServletResponse)messageInfo.getResponseMessage(), httpMessageContext);
            status = this.translateValidateRequestStatus(authenticationStatus);
            this.registerSession(httpMessageContext);
        }
        catch (Exception authMech) {
            void e;
            FFDCFilter.processException((Throwable)authMech, (String)"com.ibm.ws.security.javaeesec.AuthModule", (String)"90", (Object)this, (Object[])new Object[]{messageInfo, clientSubject, serviceSubject});
            e.printStackTrace();
            AuthException authException = new AuthException(e.getMessage());
            authException.initCause((Throwable)e);
            throw authException;
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus status = AuthStatus.SEND_FAILURE;
        try {
            HttpAuthenticationMechanism authMech = this.getModulePropertiesUtils().getHttpAuthenticationMechanism();
            HttpMessageContext httpMessageContext = this.createHttpMessageContext(messageInfo, null);
            AuthenticationStatus authenticationStatus = authMech.secureResponse((HttpServletRequest)messageInfo.getRequestMessage(), (HttpServletResponse)messageInfo.getResponseMessage(), httpMessageContext);
            status = this.translateSecureResponseStatus(authenticationStatus);
        }
        catch (AuthenticationException authMech) {
            void e;
            FFDCFilter.processException((Throwable)authMech, (String)"com.ibm.ws.security.javaeesec.AuthModule", (String)"112", (Object)this, (Object[])new Object[]{messageInfo, serviceSubject});
            e.printStackTrace();
            AuthException authException = new AuthException();
            authException.initCause((Throwable)e);
            throw authException;
        }
        return status;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        HttpAuthenticationMechanism authMech = this.getModulePropertiesUtils().getHttpAuthenticationMechanism();
        HttpMessageContext httpMessageContext = this.createHttpMessageContext(messageInfo, null);
        authMech.cleanSubject((HttpServletRequest)messageInfo.getRequestMessage(), (HttpServletResponse)messageInfo.getResponseMessage(), httpMessageContext);
    }

    protected HttpMessageContext createHttpMessageContext(MessageInfo messageInfo, Subject clientSubject) {
        HttpMessageContextImpl httpMessageContext = null;
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        AuthenticationParameters authParams = (AuthenticationParameters)request.getAttribute("com.ibm.ws.security.javaeesec.auth.params");
        if (authParams != null) {
            request.removeAttribute("com.ibm.ws.security.javaeesec.auth.params");
            httpMessageContext = new HttpMessageContextImpl(messageInfo, clientSubject, this.handler, authParams);
        } else {
            httpMessageContext = new HttpMessageContextImpl(messageInfo, clientSubject, this.handler);
        }
        return httpMessageContext;
    }

    protected ModulePropertiesUtils getModulePropertiesUtils() {
        return ModulePropertiesUtils.getInstance();
    }

    private AuthStatus translateValidateRequestStatus(AuthenticationStatus authenticationStatus) {
        AuthStatus status = AuthStatus.SEND_FAILURE;
        status = AuthenticationStatus.SUCCESS.equals((Object)authenticationStatus) ? AuthStatus.SUCCESS : this.translateCommon(authenticationStatus);
        return status;
    }

    private void registerSession(HttpMessageContext httpMessageContext) {
        if (httpMessageContext.isRegisterSession()) {
            httpMessageContext.getMessageInfo().getMap().put("javax.servlet.http.registerSession", Boolean.TRUE.toString());
        }
    }

    private AuthStatus translateSecureResponseStatus(AuthenticationStatus authenticationStatus) {
        AuthStatus status = AuthStatus.SEND_FAILURE;
        status = AuthenticationStatus.SUCCESS.equals((Object)authenticationStatus) ? AuthStatus.SEND_SUCCESS : this.translateCommon(authenticationStatus);
        return status;
    }

    @Trivial
    private AuthStatus translateCommon(AuthenticationStatus authenticationStatus) {
        AuthStatus status = AuthStatus.SEND_FAILURE;
        if (AuthenticationStatus.SEND_FAILURE.equals((Object)authenticationStatus)) {
            status = AuthStatus.SEND_FAILURE;
        } else if (AuthenticationStatus.SEND_CONTINUE.equals((Object)authenticationStatus)) {
            status = AuthStatus.SEND_CONTINUE;
        } else if (AuthenticationStatus.NOT_DONE.equals((Object)authenticationStatus)) {
            status = AuthStatus.SUCCESS;
        }
        return status;
    }
}

