/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SibRaEngineComponent
implements JsEngineComponent {
    private JsMessagingEngine _messagingEngine;
    private static boolean _serverStopping;
    private static final HashMap<String, HashSet<String>> CUSTOM_GROUPS;
    private static final Map MESSAGING_ENGINES;
    private static final Map ACTIVE_MESSAGING_ENGINES;
    private static final Map MESSAGING_ENGINE_LISTENERS;
    private static final Set RELOADING_MESSAGING_ENGINES;
    private static final TraceComponent TRACE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] registerMessagingEngineListener(SibRaMessagingEngineListener listener, String busName) {
        String methodName = "registerMessagingEngineListener";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"registerMessagingEngineListener", (Object)new Object[]{listener, busName});
        }
        HashSet activeMessagingEngines = new HashSet();
        Map map = ACTIVE_MESSAGING_ENGINES;
        synchronized (map) {
            Map map2 = MESSAGING_ENGINE_LISTENERS;
            synchronized (map2) {
                HashSet<SibRaMessagingEngineListener> listeners = (HashSet<SibRaMessagingEngineListener>)MESSAGING_ENGINE_LISTENERS.get(busName);
                if (listeners == null) {
                    listeners = new HashSet<SibRaMessagingEngineListener>();
                    MESSAGING_ENGINE_LISTENERS.put(busName, listeners);
                }
                listeners.add(listener);
            }
            if (busName == null) {
                for (Set messagingEngines : ACTIVE_MESSAGING_ENGINES.values()) {
                    activeMessagingEngines.addAll(messagingEngines);
                }
            } else {
                Set messagingEngines = (Set)ACTIVE_MESSAGING_ENGINES.get(busName);
                if (messagingEngines != null) {
                    activeMessagingEngines.addAll(messagingEngines);
                }
            }
        }
        JsMessagingEngine[] result = activeMessagingEngines.toArray(new JsMessagingEngine[activeMessagingEngines.size()]);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"registerMessagingEngineListener", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterMessagingEngineListener(SibRaMessagingEngineListener listener, String busName) {
        String methodName = "deregisterMessagingEngineListener";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"deregisterMessagingEngineListener", (Object)new Object[]{listener, busName});
        }
        Map map = MESSAGING_ENGINE_LISTENERS;
        synchronized (map) {
            Set listeners = (Set)MESSAGING_ENGINE_LISTENERS.get(busName);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    MESSAGING_ENGINE_LISTENERS.remove(busName);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"deregisterMessagingEngineListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] getMessagingEngines(String busName) {
        JsMessagingEngine[] result;
        String methodName = "getMessagingEngines";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getMessagingEngines", (Object)busName);
        }
        Map map = MESSAGING_ENGINES;
        synchronized (map) {
            Set messagingEngines = (Set)MESSAGING_ENGINES.get(busName);
            result = messagingEngines == null ? new JsMessagingEngine[]{} : messagingEngines.toArray(new JsMessagingEngine[messagingEngines.size()]);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getMessagingEngines", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] getActiveMessagingEngines(String busName) {
        JsMessagingEngine[] result;
        String methodName = "getActiveMessagingEngines";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getActiveMessagingEngines", (Object)busName);
        }
        Map map = ACTIVE_MESSAGING_ENGINES;
        synchronized (map) {
            Set messagingEngines = (Set)ACTIVE_MESSAGING_ENGINES.get(busName);
            result = messagingEngines == null ? new JsMessagingEngine[]{} : messagingEngines.toArray(new JsMessagingEngine[messagingEngines.size()]);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getActiveMessagingEngines", (Object)result);
        }
        return result;
    }

    public static boolean isMessagingEngineReloading(String meUuid) {
        String methodName = "isMessagingEngineReloading";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isMessagingEngineReloading", (Object)meUuid);
        }
        boolean reloading = RELOADING_MESSAGING_ENGINES.contains(meUuid);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isMessagingEngineReloading", (Object)reloading);
        }
        return reloading;
    }

    public static boolean isServerStopping() {
        return _serverStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(JsMessagingEngine engine) {
        Set listeners;
        String methodName = "initialize";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"initialize", (Object)engine);
        }
        this._messagingEngine = engine;
        Map map = MESSAGING_ENGINES;
        synchronized (map) {
            HashSet<JsMessagingEngine> messagingEngines = (HashSet<JsMessagingEngine>)MESSAGING_ENGINES.get(engine.getBusName());
            if (messagingEngines == null) {
                messagingEngines = new HashSet<JsMessagingEngine>();
                MESSAGING_ENGINES.put(engine.getBusName(), messagingEngines);
            }
            messagingEngines.add(engine);
            listeners = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        for (SibRaMessagingEngineListener listener : listeners) {
            listener.messagingEngineInitializing(this._messagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int mode) {
        Set listeners;
        String methodName = "start";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"start");
        }
        Map map = ACTIVE_MESSAGING_ENGINES;
        synchronized (map) {
            HashSet<JsMessagingEngine> messagingEngines = (HashSet<JsMessagingEngine>)ACTIVE_MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (messagingEngines == null) {
                messagingEngines = new HashSet<JsMessagingEngine>();
                ACTIVE_MESSAGING_ENGINES.put(this._messagingEngine.getBusName(), messagingEngines);
            }
            messagingEngines.add(this._messagingEngine);
            listeners = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        for (SibRaMessagingEngineListener listener : listeners) {
            listener.messagingEngineStarting(this._messagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int mode) {
        Set listeners;
        String methodName = "stop";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
        RELOADING_MESSAGING_ENGINES.remove(this._messagingEngine.getUuid().toString());
        Map map = ACTIVE_MESSAGING_ENGINES;
        synchronized (map) {
            Set messagingEngines = (Set)ACTIVE_MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (messagingEngines != null) {
                messagingEngines.remove(this._messagingEngine);
                if (messagingEngines.isEmpty()) {
                    ACTIVE_MESSAGING_ENGINES.remove(this._messagingEngine.getBusName());
                }
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Received stop for inactive ME:", (Object)this._messagingEngine);
            }
            listeners = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        for (SibRaMessagingEngineListener listener : listeners) {
            listener.messagingEngineStopping(this._messagingEngine, mode);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String methodName = "destroy";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
        RELOADING_MESSAGING_ENGINES.remove(this._messagingEngine.getUuid().toString());
        Map map = MESSAGING_ENGINES;
        synchronized (map) {
            Set messagingEngines = (Set)MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (messagingEngines != null) {
                messagingEngines.remove(this._messagingEngine);
                if (messagingEngines.isEmpty()) {
                    MESSAGING_ENGINES.remove(this._messagingEngine.getBusName());
                }
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Received destroy for unknown ME:", (Object)this._messagingEngine);
            }
        }
        Set listeners = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        for (SibRaMessagingEngineListener listener : listeners) {
            listener.messagingEngineDestroyed(this._messagingEngine);
        }
        this._messagingEngine = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
    }

    public void setCustomProperty(String name, String value) {
    }

    public void setConfig(LWMConfig config) {
        HashSet customGrps = new HashSet();
        ArrayList<String> l = new ArrayList<String>();
        String str = ((JsMEConfig)config).getMessagingEngine().getName();
        l.add(str);
        customGrps.addAll(l);
        CUSTOM_GROUPS.put(this._messagingEngine.getUuid().toString(), customGrps);
        this._messagingEngine.getName();
    }

    public static Set getCustomGroups(String meUuid) {
        return CUSTOM_GROUPS.get(meUuid);
    }

    public void serverStarted() {
    }

    public void serverStopping() {
        String methodName = "serverStopping";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"serverStopping");
            SibTr.exit((TraceComponent)TRACE, (String)"serverStopping");
        }
        _serverStopping = true;
    }

    public void busReloaded(LWMConfig newBus, boolean busChanged, boolean destinationsChanged, boolean mediationsChanged) {
        String methodName = "busReloaded";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"busReloaded", (Object)new Object[]{newBus, busChanged, destinationsChanged, mediationsChanged});
        }
        RELOADING_MESSAGING_ENGINES.add(this._messagingEngine.getUuid().toString());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"busReloaded");
        }
    }

    public void engineReloaded(Object objectSent) {
        JsMessagingEngine engine = (JsMessagingEngine)objectSent;
        String methodName = "engineReloaded";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"engineReloaded", (Object)engine);
        }
        RELOADING_MESSAGING_ENGINES.remove(engine.getUuid().toString());
        Set listeners = SibRaEngineComponent.getListeners(engine.getBusName());
        for (SibRaMessagingEngineListener listener : listeners) {
            listener.messagingEngineReloaded(engine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"engineReloaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getListeners(String busName) {
        String methodName = "getListeners";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getListeners", (Object)busName);
        }
        HashSet listeners = new HashSet();
        Map map = MESSAGING_ENGINE_LISTENERS;
        synchronized (map) {
            Set noBusListeners;
            Set busListeners = (Set)MESSAGING_ENGINE_LISTENERS.get(busName);
            if (busListeners != null) {
                listeners.addAll(busListeners);
            }
            if ((noBusListeners = (Set)MESSAGING_ENGINE_LISTENERS.get(null)) != null) {
                listeners.addAll(noBusListeners);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getListeners", listeners);
        }
        return listeners;
    }

    public void busReloaded(Object newBus, boolean busChanged, boolean destChg, boolean medChg) {
    }

    static {
        CUSTOM_GROUPS = new HashMap();
        MESSAGING_ENGINES = new HashMap();
        ACTIVE_MESSAGING_ENGINES = new HashMap();
        MESSAGING_ENGINE_LISTENERS = new HashMap();
        RELOADING_MESSAGING_ENGINES = Collections.synchronizedSet(new HashSet());
        TRACE = SibTr.register(SibRaEngineComponent.class, (String)"SIBJmsRaCommon", (String)"com.ibm.ws.sib.ra.CWSIVMessages");
    }
}

