/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.interfaces.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractConfig
implements WebSphereConfig {
    private static final TraceComponent tc = Tr.register(AbstractConfig.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final SortedSources sources;
    private boolean closed = false;
    private final ConversionManager conversionManager;
    static final long serialVersionUID = 625127597269146974L;

    @Trivial
    public AbstractConfig(ConversionManager conversionManager, SortedSources sources) {
        this.sources = sources;
        this.conversionManager = conversionManager;
    }

    protected abstract Set<String> getKeySet();

    public Iterable<ConfigSource> getConfigSources() {
        this.assertNotClosed();
        return this.sources;
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        this.assertNotClosed();
        SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
        Object value = null;
        if (sourced != null) {
            value = sourced.getValue();
        }
        Optional<Object> optional = Optional.ofNullable(value);
        return optional;
    }

    public Set<String> getPropertyNames() {
        this.assertNotClosed();
        Set<String> keys = this.getKeySet();
        return keys;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"config.closed.CWMCG0001E", (Object[])new Object[0]));
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Config[");
        sb.append(this.hashCode());
        sb.append("](");
        if (this.closed) {
            sb.append("CLOSED");
        } else {
            sb.append(this.sources.size());
            sb.append(" sources");
        }
        sb.append(")");
        return sb.toString();
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        Object value = this.getValue(propertyName, propertyType, false);
        return (T)value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType) {
        Object value = this.getValue(propertyName, propertyType, false);
        return value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType, boolean optional) {
        Object value = null;
        this.assertNotClosed();
        SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
        if (sourced != null) {
            value = sourced.getValue();
        } else if (!optional) {
            throw new NoSuchElementException(Tr.formatMessage((TraceComponent)tc, (String)"no.such.element.CWMCG0015E", (Object[])new Object[]{propertyName}));
        }
        return value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType, String defaultString) {
        Object value = null;
        this.assertNotClosed();
        SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
        if (sourced != null) {
            value = sourced.getValue();
        } else if (!defaultString.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
            value = this.convertValue(defaultString, propertyType);
        } else {
            throw new NoSuchElementException(Tr.formatMessage((TraceComponent)tc, (String)"no.such.element.CWMCG0015E", (Object[])new Object[]{propertyName}));
        }
        return value;
    }

    @Override
    public <T> T convertValue(String rawValue, Class<T> type) {
        this.assertNotClosed();
        Object value = this.getConversionManager().convert(rawValue, type);
        return (T)value;
    }

    @Override
    public Object convertValue(String rawValue, Type type) {
        this.assertNotClosed();
        Object value = this.getConversionManager().convert(rawValue, type);
        return value;
    }

    @Override
    public Object convertValue(String rawValue, Type type, Class<?> genericSubType) {
        this.assertNotClosed();
        Object value = this.getConversionManager().convert(rawValue, type, genericSubType);
        return value;
    }

    public ConversionManager getConversionManager() {
        return this.conversionManager;
    }
}

