/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.internal.ORBWrapperInternal;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.ws.transport.iiop.spi.ReadyListener;
import com.ibm.ws.transport.iiop.spi.SubsystemFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={}, property={"service.vendor=IBM", "service.ranking:Integer=5"})
public final class ORBWrapper {
    public static final String pid;
    private final ReadyListenerImpl readyListener;
    static final long serialVersionUID = -5101733945935061969L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public ORBWrapper(Map<String, Object> properties, @Reference(name="ComponentFactory", target="(component.factory=com.ibm.ws.transport.iiop.internal.ORBWrapperInternal)") ComponentFactory<ORBWrapperInternal> factory, @Reference(name="IIOPEndpoint", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY) List<IIOPEndpoint> endpoints, @Reference(name="SubsystemFactory", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY) List<SubsystemFactory> subsystemFactories) {
        this.readyListener = new ReadyListenerImpl(Collections.unmodifiableMap(((Stream)subsystemFactories.stream().sequential()).collect(LinkedHashMap::new, (m, f) -> m.put(f, new AtomicBoolean()), Map::putAll)), Collections.unmodifiableMap(properties), factory);
        subsystemFactories.forEach(sf -> sf.register(this.readyListener, properties, Collections.unmodifiableList(endpoints)));
    }

    @Deactivate
    void deactivate() {
        this.readyListener.unregister();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.ORBWrapper", ORBWrapper.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
        pid = ORBWrapperInternal.class.getName();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ReadyListenerImpl
    implements ReadyListener {
        private final Map<SubsystemFactory, ? extends AtomicBoolean> subsystemFactories;
        private final Map<String, Object> properties;
        private final ComponentFactory<ORBWrapperInternal> factory;
        private final AtomicReference<ComponentInstance<ORBWrapperInternal>> instanceRef = new AtomicReference();
        static final long serialVersionUID = -8453144014285442371L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ReadyListenerImpl(Map<SubsystemFactory, ? extends AtomicBoolean> subsystemFactories, Map<String, Object> properties, ComponentFactory<ORBWrapperInternal> factory) {
            this.subsystemFactories = subsystemFactories;
            this.properties = properties;
            this.factory = factory;
        }

        @Override
        public void readyChanged(SubsystemFactory id, boolean ready) {
            this.instanceRef.getAndUpdate(i -> {
                try {
                    this.subsystemFactories.get(id).set(ready);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (this.subsystemFactories.values().stream().allMatch(AtomicBoolean::get)) {
                    return null == i ? this.factory.newInstance(this.copyProps()) : i;
                }
                if (null != i) {
                    i.dispose();
                }
                return null;
            });
        }

        @Override
        public String listenerId() {
            return (String)this.properties.get("id");
        }

        void unregister() {
            this.subsystemFactories.keySet().forEach(sf -> sf.unregister(this));
        }

        private Hashtable<String, Object> copyProps() {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.putAll(this.properties);
            return h;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.ORBWrapper$ReadyListenerImpl", ReadyListenerImpl.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
        }
    }
}

