/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.metatype.Extendable;
import org.eclipse.equinox.metatype.impl.Persistence;

public class ExtendableHelper
implements Extendable {
    private final Map<String, Map<String, String>> extensions;

    public ExtendableHelper() {
        this(Collections.emptyMap());
    }

    public ExtendableHelper(Map<String, Map<String, String>> extensions) {
        if (extensions == null) {
            throw new NullPointerException();
        }
        this.extensions = extensions;
    }

    public Map<String, String> getExtensionAttributes(String schema) {
        return Collections.unmodifiableMap(this.extensions.get(schema));
    }

    public Set<String> getExtensionUris() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    void getStrings(Set<String> strings) {
        for (Map.Entry<String, Map<String, String>> e1 : this.extensions.entrySet()) {
            strings.add(e1.getKey());
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                strings.add(e2.getKey());
                strings.add(e2.getValue());
            }
        }
    }

    public static ExtendableHelper load(Persistence.Reader reader) throws IOException {
        HashMap<String, Map<String, String>> extensions = new HashMap<String, Map<String, String>>();
        int numExtensions = reader.readInt();
        int i = 0;
        while (i < numExtensions) {
            String extKey = reader.readString();
            int numAttrs = reader.readInt();
            HashMap<String, String> extensionAttrs = new HashMap<String, String>();
            int j = 0;
            while (j < numAttrs) {
                String attrKey = reader.readString();
                String attrValue = reader.readString();
                extensionAttrs.put(attrKey, attrValue);
                ++j;
            }
            extensions.put(extKey, extensionAttrs);
            ++i;
        }
        return new ExtendableHelper(extensions);
    }

    public void write(Persistence.Writer writer) throws IOException {
        writer.writeInt(this.extensions.size());
        for (Map.Entry<String, Map<String, String>> extensionEntry : this.extensions.entrySet()) {
            writer.writeString(extensionEntry.getKey());
            Map<String, String> extensionAttrs = extensionEntry.getValue();
            writer.writeInt(extensionAttrs.size());
            for (Map.Entry<String, String> attrs : extensionAttrs.entrySet()) {
                writer.writeString(attrs.getKey());
                writer.writeString(attrs.getValue());
            }
        }
    }
}

