/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions;

import com.ibm.ws.jain.protocol.ip.sip.extensions.ContentDispositionHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;

public class ContentDispositionHeaderImpl
extends ParametersHeaderImpl
implements ContentDispositionHeader {
    private static final long serialVersionUID = 4228648805461504221L;
    protected String m_type;

    @Override
    public void setDispositionType(String type) throws IllegalArgumentException {
        if (type == null || type.equals("")) {
            throw new IllegalArgumentException("Disp: null or empty type");
        }
        this.m_type = type;
    }

    @Override
    public String getDispositionType() {
        return this.m_type;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        String type = parser.nextToken(';');
        this.setDispositionType(type);
        super.parseValue(parser);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_type);
        super.encodeValue(ret);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof ContentDispositionHeaderImpl)) {
            return false;
        }
        ContentDispositionHeaderImpl o = (ContentDispositionHeaderImpl)other;
        if (this.m_type == null || this.m_type.length() == 0) {
            return o.m_type == null || o.m_type.length() == 0;
        }
        if (o.m_type == null || o.m_type.length() == 0) {
            return false;
        }
        return this.m_type.equals(o.m_type);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public String getName() {
        return "Content-Disposition";
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }
}

