/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.EmptyIterator;
import com.ibm.ws.sip.container.servlets.URIImpl;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import java.util.Iterator;
import javax.servlet.sip.SipURI;

public class SipURIImpl
extends URIImpl
implements SipURI {
    private static final LogMgr c_logger = Log.get(SipURIImpl.class);
    public static final String LR = "lr";
    public static final String MADDR = "maddr";
    public static final String METHOD = "method";
    public static final String TRANSPORT = "transport";
    public static final String TTL = "ttl";
    private static final String USER = "user";
    private static final String SIP = "sip";
    private static final String SIPS = "sips";

    public SipURIImpl(SipURL jainSipUrl) {
        super(jainSipUrl);
    }

    @Override
    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("javax.servlet.sip.SipURI#getHeader(java.lang.String name): name must not be null");
        }
        return this.getJainURL().getHeader(name);
    }

    public void removeHeaders() {
        this.getJainURL().removeHeaders();
    }

    private final SipURL getJainURL() {
        return (SipURL)this.m_jainURI;
    }

    @Override
    public Iterator getHeaderNames() {
        Iterator iter = this.getJainURL().getHeaders();
        if (null == iter) {
            iter = EmptyIterator.getInstance();
        }
        return iter;
    }

    @Override
    public String getHost() {
        return this.getJainURL().getHost();
    }

    @Override
    public boolean getLrParam() {
        return this.getParameter(LR) != null;
    }

    @Override
    public String getMAddrParam() {
        return this.getParameter(MADDR);
    }

    @Override
    public String getMethodParam() {
        return this.getParameter(METHOD);
    }

    @Override
    public String getParameter(String name) {
        super.getParameter(name);
        return this.getJainURL().getParameter(name);
    }

    public Iterator getParameterNames() {
        Iterator iter = this.getJainURL().getParameters();
        if (null == iter) {
            iter = EmptyIterator.getInstance();
        }
        return iter;
    }

    @Override
    public int getPort() {
        return this.getJainURL().getPort();
    }

    @Override
    public String getTransportParam() {
        return this.getParameter(TRANSPORT);
    }

    @Override
    public int getTTLParam() {
        int rValue;
        block3: {
            rValue = -1;
            String s = this.getParameter(TTL);
            if (null != s) {
                try {
                    rValue = Integer.parseInt(s);
                }
                catch (NumberFormatException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block3;
                    c_logger.traceDebug(this, "getTTLParam", "Failed to parse: " + s + " , returning -1 ");
                }
            }
        }
        return rValue;
    }

    @Override
    public String getUser() {
        return this.getJainURL().getUserName();
    }

    @Override
    public String getUserParam() {
        return this.getParameter(USER);
    }

    @Override
    public String getUserPassword() {
        return this.getJainURL().getUserPassword();
    }

    @Override
    public boolean isSecure() {
        return this.getJainURL().getScheme().equals(SIPS);
    }

    @Override
    public void removeParameter(String name) {
        this.getJainURL().removeParameter(name);
    }

    @Override
    public void setHeader(String name, String value) {
        block2: {
            try {
                this.getJainURL().setHeader(name, value);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.set.header", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setHost(String host) {
        block2: {
            try {
                this.getJainURL().setHost(host);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{host};
                c_logger.error("error.set.host", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setLrParam(boolean flag) {
        if (flag) {
            this.setParameter(LR, "");
        } else {
            this.removeParameter(LR);
        }
    }

    @Override
    public void setMAddrParam(String maddr) {
        this.setParameter(MADDR, maddr);
    }

    @Override
    public void setMethodParam(String method) {
        this.setParameter(METHOD, method);
    }

    @Override
    public void setParameter(String name, String value) {
        block2: {
            super.setParameter(name, value);
            try {
                this.getJainURL().setParameter(name, value);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.set.parameter", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setPort(int port) {
        block4: {
            try {
                if (port > 0) {
                    this.getJainURL().setPort(port);
                } else {
                    this.getJainURL().removePort();
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block4;
                Object[] args = new Object[]{new Integer(port)};
                c_logger.error("error.set.port", "Request", args, (Throwable)e2);
            }
        }
    }

    public void removePort() {
        this.getJainURL().removePort();
    }

    @Override
    public void setSecure(boolean b) {
        block2: {
            String scheme = b ? SIPS : SIP;
            try {
                this.getJainURL().setScheme(scheme);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{new Boolean(b)};
                c_logger.error("error.set.secure", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setTransportParam(String transport) {
        block2: {
            try {
                this.getJainURL().setTransport(transport);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{TRANSPORT, transport};
                c_logger.error("error.set.parameter", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setTTLParam(int ttl) {
        this.setParameter(TTL, Integer.toString(ttl));
    }

    @Override
    public void setUser(String user) {
        block2: {
            try {
                this.getJainURL().setUserName(user);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{user};
                c_logger.error("error.set.user", "Request", args, (Throwable)e2);
            }
        }
    }

    @Override
    public void setUserParam(String user) {
        this.setParameter(USER, user);
    }

    @Override
    public void setUserPassword(String password) {
        block4: {
            try {
                this.getJainURL().setUserPassword(password);
            }
            catch (SipParseException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{password};
                    c_logger.error("error.set.user.password", "Request", args, (Throwable)e2);
                }
            }
            catch (SipException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                Object[] args = new Object[]{password};
                c_logger.error("error.set.user.password", "Request", args, (Throwable)e3);
            }
        }
    }

    @Override
    public String getScheme() {
        return this.getJainURL().getScheme();
    }

    @Override
    public boolean isSipURI() {
        return true;
    }

    @Override
    public Object clone(boolean isProtected) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{isProtected};
            c_logger.traceEntry((Object)SipURIImpl.class.getName(), "clone", params);
        }
        SipURIImpl cloned = null;
        cloned = !isProtected ? new SipURIImpl((SipURL)this.getJainURL().clone()) : new SipURIImpl(this.getJainURL());
        return cloned;
    }

    @Override
    public String toString() {
        return this.getJainURL().toString();
    }

    public SipURL getJainSipUrl() {
        return this.getJainURL();
    }

    @Override
    public boolean equals(Object obj) {
        SipURIImpl urlObj;
        boolean rc = false;
        if (obj instanceof SipURIImpl && (urlObj = (SipURIImpl)obj).getJainURL().equals(this.getJainURL())) {
            rc = true;
        }
        return rc;
    }

    @Override
    public int hashCode() {
        return "SipURIImpl".hashCode() ^ this.getJainURL().hashCode();
    }

    public static boolean isSchemeSupported(String scheme) {
        boolean rc = false;
        if (scheme.equalsIgnoreCase(SIP) || scheme.equalsIgnoreCase(SIPS)) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void removeHeader(String name) {
        this.getJainURL().removeHeader(name);
    }
}

