/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkList;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MSDelegatingLocalTransaction
implements ExternalLocalTransaction,
PersistentTransaction {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(MSDelegatingLocalTransaction.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    protected MessageStoreImpl _ms;
    protected PersistenceManager _persistence;
    protected XidManager _xidManager;
    protected TransactionState _state = TransactionState.STATE_ACTIVE;
    protected PersistentTranId _ptid;
    protected WorkList _workList;
    protected List<TransactionCallback> _callbacks = Collections.synchronizedList(new ArrayList(5));
    protected int _maxSize;
    protected int _size = 0;
    protected BatchingContext _bc;

    public MSDelegatingLocalTransaction(MessageStoreImpl ms, PersistenceManager persistence, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MSDelegatingLocalTransaction", (Object)("MessageStore=" + (Object)((Object)ms) + ", Persistence=" + persistence + ", MaxSize=" + maxSize));
        }
        this._ms = ms;
        this._persistence = persistence;
        this._maxSize = maxSize;
        if (this._ms != null) {
            this._xidManager = this._ms.getXidManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MSDelegatingLocalTransaction");
        }
    }

    @Override
    public synchronized void addWork(WorkItem item) throws ProtocolException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + item));
        }
        if (this._state != TransactionState.STATE_ACTIVE) {
            ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)pe);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            }
            throw pe;
        }
        if (item != null) {
            if (this._workList == null) {
                this._workList = new TaskList();
            }
        } else {
            ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)pe);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            }
            throw pe;
        }
        this._workList.addWork(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
        }
    }

    @Override
    public WorkList getWorkList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWorkList", (Object)("return=" + this._workList));
        }
        return this._workList;
    }

    public void registerCallback(TransactionCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + callback));
        }
        this._callbacks.add(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerCallback");
        }
    }

    public boolean hasSubordinates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasSubordinates");
        }
        boolean retval = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasSubordinates", (Object)("return=" + retval));
        }
        return retval;
    }

    public final boolean isAutoCommit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public synchronized PersistentTranId getPersistentTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentTranId");
        }
        if (this._ptid == null) {
            this._ptid = this._xidManager != null ? new PersistentTranId(this._xidManager.generateLocalTranId()) : new PersistentTranId(this.hashCode());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws SIResourceException {
        if (++this._size > this._maxSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new SIResourceException((Throwable)new TransactionMaxSizeExceededException());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    public boolean isAlive() {
        boolean retval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAlive");
        }
        boolean bl = retval = this._state == TransactionState.STATE_ACTIVE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAlive", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"begin");
        }
        if (this._state == TransactionState.STATE_ACTIVE && this._workList != null) {
            SIIncorrectCallException ice = new SIIncorrectCallException(nls.getFormattedMessage("TRAN_PROTOCOL_ERROR_SIMS1001", null, "TRAN_PROTOCOL_ERROR_SIMS1001"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot begin new LocalTran. Existing work needs completing first!", (Object)ice);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"begin");
            }
            throw ice;
        }
        MSDelegatingLocalTransaction mSDelegatingLocalTransaction = this;
        synchronized (mSDelegatingLocalTransaction) {
            this._ptid = null;
        }
        this._workList = null;
        this._size = 0;
        this._callbacks.clear();
        this._state = TransactionState.STATE_ACTIVE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"begin");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SIIncorrectCallException, SIRollbackException, SIResourceException, SIErrorException {
        block35: {
            boolean bl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit");
            }
            if (this._state != TransactionState.STATE_ACTIVE) {
                SIIncorrectCallException sie = new SIIncorrectCallException(nls.getFormattedMessage("CANNOT_COMMIT_COMPLETE_SIMS1004", new Object[0], null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot commit Transaction. Transaction is complete or completing!", (Object)sie);
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw sie;
                if (!tc.isEntryEnabled()) throw sie;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                throw sie;
            }
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback callback = this._callbacks.get(i);
                callback.beforeCompletion((TransactionCommon)this);
            }
            if (this._workList != null) {
                try {
                    this._workList.preCommit(this);
                }
                catch (Throwable t) {
                    block32: {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:363:1.51.1.14", (Object)this);
                        try {
                            this.rollback();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:377:1.51.1.14", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block32;
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)e);
                        }
                    }
                    this._state = TransactionState.STATE_ROLLEDBACK;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)t);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                    }
                    throw new SIRollbackException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{t}, null), t);
                }
            }
            this._state = TransactionState.STATE_COMMITTING_1PC;
            try {
                if (this._workList != null) {
                    this._persistence.commit(this, true);
                    this._workList.commit(this);
                }
                this._state = TransactionState.STATE_COMMITTED;
                bl = this._state == TransactionState.STATE_COMMITTED;
            }
            catch (SeverePersistenceException spe) {
                try {
                    FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:411:1.51.1.14", (Object)this);
                    if (this._ms != null) {
                        this._ms.reportLocalError();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)spe));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{spe}, null), (Throwable)spe);
                    catch (PersistenceException pe) {
                        block33: {
                            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:425:1.51.1.14", (Object)this);
                            try {
                                this._workList.rollback(this);
                                this._state = TransactionState.STATE_ROLLEDBACK;
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:441:1.51.1.14", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block33;
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling-back WorkList after Commit failure!", (Object)t);
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction rolled-back due to Exception in Commit!", (Object)((Object)pe));
                        }
                        throw new SIRollbackException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{pe}, null), (Throwable)pe);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:450:1.51.1.14", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during commit phase of transaction!", (Object)t);
                        }
                        throw new SIErrorException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{t}, null), t);
                    }
                }
                catch (Throwable throwable) {
                    block34: {
                        boolean committed = this._state == TransactionState.STATE_COMMITTED;
                        try {
                            if (this._workList != null) {
                                this._workList.postComplete(this, committed);
                            }
                            for (int i = 0; i < this._callbacks.size(); ++i) {
                                TransactionCallback callback = this._callbacks.get(i);
                                callback.afterCompletion((TransactionCommon)this, committed);
                            }
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:477:1.51.1.14", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block34;
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)t);
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                    if (!tc.isEntryEnabled()) throw throwable;
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                    throw throwable;
                }
            }
            boolean committed = bl;
            try {
                if (this._workList != null) {
                    this._workList.postComplete(this, committed);
                }
                for (int i = 0; i < this._callbacks.size(); ++i) {
                    TransactionCallback callback = this._callbacks.get(i);
                    callback.afterCompletion((TransactionCommon)this, committed);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:477:1.51.1.14", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block35;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)t);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
    }

    public void rollback() throws SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback");
        }
        if (this._state != TransactionState.STATE_ACTIVE) {
            SIIncorrectCallException sie = new SIIncorrectCallException(nls.getFormattedMessage("CANNOT_ROLLBACK_COMPLETE_SIMS1005", new Object[0], null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot rollback Transaction. Transaction is complete or completing!", (Object)sie);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            throw sie;
        }
        this._state = TransactionState.STATE_ROLLINGBACK;
        try {
            if (this._workList != null) {
                this._workList.rollback(this);
            }
            this._state = TransactionState.STATE_ROLLEDBACK;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.rollback", (String)"1:539:1.51.1.14", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during rollback phase of transaction!", (Object)t);
            }
            throw new SIResourceException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{t}, null), t);
        }
        finally {
            block19: {
                try {
                    if (this._workList != null) {
                        this._workList.postComplete(this, false);
                    }
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        TransactionCallback callback = this._callbacks.get(i);
                        callback.afterCompletion((TransactionCommon)this, false);
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.rollback", (String)"1:565:1.51.1.14", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block19;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post rollback phase of transaction!", (Object)t);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
        }
    }

    @Override
    public final int getTransactionType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_LOCAL");
        }
        return 1;
    }

    @Override
    public void setTransactionState(TransactionState state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionState", (Object)("State=" + state));
        }
        this._state = state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionState");
        }
    }

    @Override
    public TransactionState getTransactionState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionState");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionState", (Object)("return=" + this._state));
        }
        return this._state;
    }

    @Override
    public BatchingContext getBatchingContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    @Override
    public void setBatchingContext(BatchingContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + bc));
        }
        this._bc = bc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBatchingContext");
        }
    }

    @Override
    public MessageStore getOwningMessageStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore", (Object)("return=" + (Object)((Object)this._ms)));
        }
        return this._ms;
    }
}

