/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.jose4j.util;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.AttributeToSubject;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.JtiNonceCache;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.jose4j.Jose4jValidator;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Jose4jUtil {
    private static final TraceComponent tc = Tr.register(Jose4jUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private static final String SIGNATURE_ALG_HS256 = "HS256";
    private static final String SIGNATURE_ALG_RS256 = "RS256";
    private static final String SIGNATURE_ALG_NONE = "none";
    private final SSLSupport sslSupport;
    private static final JtiNonceCache jtiCache = new JtiNonceCache();
    static final long serialVersionUID = -309043300267708408L;

    public Jose4jUtil(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    @FFDCIgnore(value={Exception.class})
    public ProviderAuthenticationResult createResultWithJose4J(String responseState, Map<String, String> tokens, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = null;
        String tokenStr = this.getIdToken(tokens, clientConfig);
        String accessToken = tokens.get("access_token");
        String refreshToken = tokens.get("refresh_token");
        String clientId = clientConfig.getClientId();
        try {
            String nonceInIDToken;
            boolean bNonceVerified;
            OidcTokenImplBase idToken;
            if (tokenStr == null) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_IDTOKEN_REQUEST_FAILURE", (Object[])new Object[]{clientId, clientConfig.getTokenEndpointUrl()});
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            JwtContext jwtContext = Jose4jUtil.parseJwtWithoutValidation(tokenStr);
            JwtClaims jwtClaims = this.parseJwtWithValidation(clientConfig, tokenStr, jwtContext, oidcClientRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("post jwtClaims: " + jwtClaims + " firstPass jwtClaims=" + jwtContext.getJwtClaims()), (Object[])new Object[0]);
            }
            if ((idToken = new OidcTokenImplBase(jwtClaims, accessToken, refreshToken, clientId, oidcClientRequest.getTokenTypeNoSpace())).getSubject() == null) {
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            AttributeToSubject attributeToSubject = new AttributeToSubject(clientConfig, idToken);
            if (attributeToSubject.checkUserNameForNull()) {
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            boolean isImplicit = "implicit".equals(clientConfig.getGrantType());
            if ((clientConfig.isNonceEnabled() || isImplicit) && !(bNonceVerified = OidcUtil.verifyNonce(oidcClientRequest, nonceInIDToken = idToken.getNonce(), clientConfig, responseState))) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_REQUEST_NONCE_FAILED", (Object[])new Object[]{clientId, nonceInIDToken});
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            if (clientConfig.isSocial()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"social login flow, storing id token in result", (Object[])new Object[0]);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("id_token", tokenStr);
                props.put("access_token", accessToken);
                if (idToken != null) {
                    props.put("id_token_object", idToken);
                }
                oidcResult = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, null, null, props, null);
                return oidcResult;
            }
            Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
            if (clientConfig.isIncludeCustomCacheKeyInSubject() || clientConfig.isDisableLtpaCookie()) {
                long storingTime = new Date().getTime();
                String customCacheKey = oidcClientRequest.getAndSetCustomCacheKeyValue();
                customProperties.put("com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds", storingTime);
                if (clientConfig.isIncludeCustomCacheKeyInSubject()) {
                    customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
                }
                customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            }
            Subject subject = null;
            if (clientConfig.isIncludeIdTokenInSubject()) {
                subject = new Subject();
                subject.getPrivateCredentials().add(idToken);
                customProperties.putAll(tokens);
            } else {
                if (refreshToken != null) {
                    customProperties.put("refresh_token", refreshToken);
                }
                if (accessToken != null) {
                    customProperties.put("access_token", accessToken);
                }
            }
            if (idToken != null) {
                customProperties.put("id_token_object", idToken);
            }
            oidcResult = attributeToSubject.doMapping(customProperties, subject);
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e.getLocalizedMessage(), clientId});
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    String getIdToken(Map<String, String> tokens, ConvergedClientConfig clientConfig) {
        if (tokens == null) {
            return null;
        }
        String idToken = tokens.get("id_token");
        if (idToken == null && this.useAccessTokenAsIdToken(clientConfig)) {
            idToken = tokens.get("access_token");
        }
        return idToken;
    }

    boolean useAccessTokenAsIdToken(ConvergedClientConfig clientConfig) {
        return clientConfig.getUseAccessTokenAsIdToken();
    }

    protected static JwtContext parseJwtWithoutValidation(String jwtString) throws Exception {
        JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        JwtContext jwtContext = firstPassJwtConsumer.process(jwtString);
        return jwtContext;
    }

    @FFDCIgnore(value={Exception.class})
    protected JwtClaims parseJwtWithValidation(ConvergedClientConfig clientConfig, String jwtString, JwtContext jwtContext, OidcClientRequest oidcClientRequest) throws JWTTokenValidationFailedException, IllegalStateException, Exception {
        try {
            List jsonStructures = jwtContext.getJoseObjects();
            if (jsonStructures == null || jsonStructures.isEmpty()) {
                throw new Exception("Invalid JsonWebStructure");
            }
            JsonWebStructure jsonStruct = (JsonWebStructure)jsonStructures.get(0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JsonWebStructure class: " + jsonStruct.getClass().getName() + " data:" + jsonStruct), (Object[])new Object[0]);
                if (jsonStruct instanceof JsonWebSignature) {
                    JsonWebSignature signature = (JsonWebSignature)jsonStruct;
                    Tr.debug((TraceComponent)tc, (String)("JsonWebSignature alg: " + signature.getAlgorithmHeaderValue() + " 3rd:'" + signature.getEncodedSignature() + "'"), (Object[])new Object[0]);
                }
            }
            String kid = jsonStruct.getKeyIdHeaderValue();
            String x5t = jsonStruct.getX509CertSha1ThumbprintHeaderValue();
            Key key = null;
            Exception caughtException = null;
            try {
                key = this.getVerifyKey(clientConfig, kid, x5t);
            }
            catch (Exception e) {
                caughtException = e;
            }
            if (key == null) {
                Object[] objs = new Object[]{clientConfig.getSignatureAlgorithm(), ""};
                if (caughtException != null) {
                    objs = new Object[]{clientConfig.getSignatureAlgorithm(), caughtException.getLocalizedMessage()};
                }
                oidcClientRequest.setRsFailMsg("No Key", Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_NO_VERIFYING_KEY", (Object[])objs));
                throw oidcClientRequest.error(true, tc, "OIDC_CLIENT_NO_VERIFYING_KEY", objs);
            }
            Jose4jValidator validator = new Jose4jValidator(key, clientConfig.getClockSkewInSeconds(), new OIDCClientAuthenticatorUtil().getIssuerIdentifier(clientConfig), clientConfig.getClientId(), clientConfig.getSignatureAlgorithm(), oidcClientRequest);
            return validator.parseJwtWithValidation(jwtString, jwtContext, (JsonWebSignature)jsonStruct);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught an unexpected exception.", (Object[])new Object[]{e});
            }
            throw e;
        }
    }

    protected Key getVerifyKey(ConvergedClientConfig clientConfig, String kid, String x5t) throws Exception {
        Object keyValue = null;
        String signatureAlgorithm = clientConfig.getSignatureAlgorithm();
        if (SIGNATURE_ALG_HS256.equals(signatureAlgorithm)) {
            keyValue = new HmacKey(clientConfig.getSharedKey().getBytes("UTF-8"));
        } else if (SIGNATURE_ALG_RS256.equals(signatureAlgorithm)) {
            if (clientConfig.getJwkEndpointUrl() != null || clientConfig.getJsonWebKey() != null) {
                JwKRetriever retriever = this.createJwkRetriever(clientConfig);
                keyValue = retriever.getPublicKeyFromJwk(kid, x5t, "sig", clientConfig.getUseSystemPropertiesForHttpClientConnections());
            } else {
                keyValue = clientConfig.getPublicKey();
            }
        } else if (SIGNATURE_ALG_NONE.equals(signatureAlgorithm)) {
            keyValue = new HmacKey(clientConfig.getSharedKey().getBytes("UTF-8"));
        }
        return keyValue;
    }

    public JwKRetriever createJwkRetriever(ConvergedClientConfig oidcClientConfig) {
        JwKRetriever retriever = null;
        if (oidcClientConfig != null) {
            retriever = new JwKRetriever(oidcClientConfig.getId(), oidcClientConfig.getSslRef(), oidcClientConfig.getJwkEndpointUrl(), oidcClientConfig.getJwkSet(), this.sslSupport, oidcClientConfig.isHostNameVerificationEnabled(), oidcClientConfig.getJwkClientId(), oidcClientConfig.getJwkClientSecret(), oidcClientConfig.getSignatureAlgorithm());
        }
        return retriever;
    }

    protected ProviderAuthenticationResult createProviderAuthenticationResult(JSONObject jobj, ConvergedClientConfig clientConfig, String accessToken) {
        AttributeToSubject attributeToSubject = new AttributeToSubject(clientConfig, jobj, accessToken);
        if (attributeToSubject.checkUserNameForNull()) {
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        Hashtable<String, Object> customProperties = attributeToSubject.handleCustomProperties();
        if (accessToken != null) {
            customProperties.put("access_token", accessToken);
        }
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = attributeToSubject.doMapping(customProperties, new Subject());
        return oidcResult;
    }

    @FFDCIgnore(value={Exception.class})
    public ProviderAuthenticationResult createResultWithJose4JForJwt(String jwtString, ConvergedClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = null;
        String accessToken = jwtString;
        String refreshToken = null;
        String clientId = clientConfig.getClientId();
        try {
            JwtContext jwtContext = Jose4jUtil.parseJwtWithoutValidation(jwtString);
            JwtClaims jwtClaims = this.parseJwtWithValidation(clientConfig, jwtString, jwtContext, oidcClientRequest);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jwtClaims: " + jwtClaims), (Object[])new Object[0]);
            }
            OidcTokenImplBase idToken = new OidcTokenImplBase(jwtClaims, accessToken, refreshToken, clientId, oidcClientRequest.getTokenTypeNoSpace());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jwt token(idToken):" + idToken.toString()), (Object[])new Object[0]);
            }
            if ((oidcResult = this.checkForReusedJwt(clientConfig, idToken)) != null) {
                return oidcResult;
            }
            AttributeToSubject attributeToSubject = new AttributeToSubject(clientConfig, idToken);
            if (attributeToSubject.checkUserNameForNull()) {
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
            Subject subject = null;
            if (clientConfig.isIncludeIdTokenInSubject()) {
                subject = new Subject();
                subject.getPrivateCredentials().add(idToken);
            }
            if (accessToken != null) {
                customProperties.put("access_token", accessToken);
                if (clientConfig.isIncludeCustomCacheKeyInSubject()) {
                    customProperties.put("com.ibm.wsspi.security.cred.cacheKey", String.valueOf(accessToken.hashCode()));
                }
                customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            }
            oidcResult = attributeToSubject.doMapping(customProperties, subject);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Get exception", (Object[])new Object[]{e});
            }
            Object[] objs = new Object[]{e.getLocalizedMessage(), clientId};
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_VERIFY_ERR", (Object[])objs);
            oidcClientRequest.setRsFailMsg(null, Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_VERIFY_ERR", (Object[])objs));
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    ProviderAuthenticationResult checkForReusedJwt(ConvergedClientConfig clientConfig, OidcTokenImplBase idToken) {
        if (clientConfig.getTokenReuse()) {
            return null;
        }
        if (jtiCache.contain(idToken)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Jwt token can only be submitted once. The issuer is " + idToken.getIssuer() + ", and JTI is " + idToken.getJwtId()), (Object[])new Object[0]);
            }
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_DUP_JTI_ERR", (Object[])new Object[]{idToken.getIssuer(), idToken.getJwtId()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 939135952528860596L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.setProperty("org.jose4j.jws.default-allow-none", "true");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil$1", 1.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
            }
        });
    }
}

