/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPubSubOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamControl;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamControllableIterator;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.impl.TransmitMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;

public class InternalOutputStreamSetControl
extends AbstractControlAdapter
implements SIMPPubSubOutboundTransmitControllable {
    private static final TraceComponent tc = SibTr.register(InternalOutputStreamSetControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected StreamSet _streamSet;
    protected InternalOutputStreamManager _ioStreamManager;
    protected HealthStateTree _healthState;
    protected RemoteTopicSpaceControl parent;
    public static final String STREAM_SET_UNINITIALISED_STRING = "STREAM_SET_UNINITIALISED";

    public InternalOutputStreamSetControl(StreamSet streamSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamSetControl", (Object)new Object[]{streamSet});
        }
        this._streamSet = streamSet;
        this._healthState = new HealthStateTree();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamSetControl", (Object)this);
        }
    }

    public SIMPIterator getTransmitMessagesIterator(int maxMsgs) throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessagesIterator");
        }
        InternalOutputStreamSetXmitMessageIterator msgItr = null;
        try {
            msgItr = new InternalOutputStreamSetXmitMessageIterator(maxMsgs);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.getTransmitMessagesIterator", (String)"1:272:1.30", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"InternalOutputStreamSetControl.getTransmitMessagesIterator", "1:280:1.30", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)msgItr);
        }
        return msgItr;
    }

    public SIMPTransmitMessageControllable getTransmitMessageByID(String id) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)id);
        }
        SIMPTransmitMessageControllable msg = null;
        SIMPIterator it = this.getStreams();
        while (it.hasNext() && msg == null) {
            msg = ((InternalOutputStreamControl)it.next()).getTransmitMessageByID(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)msg);
        }
        return msg;
    }

    public DeliveryStreamType getType() {
        return DeliveryStreamType.PUBSUB_SOURCE;
    }

    public String getId() {
        SIBUuid12 streamID;
        String streamIDStr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = streamIDStr = (streamID = this._streamSet.getStreamID()) != null ? streamID.toString() : STREAM_SET_UNINITIALISED_STRING;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)streamIDStr);
        }
        return streamIDStr;
    }

    public String getName() {
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._streamSet == null || this._ioStreamManager == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"InternalOutputStreamControl.assertValidControllable", "1:363:1.30", this._streamSet}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._streamSet = null;
        this._ioStreamManager = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessagesAtSource(IndoubtAction indoubtAction) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
        this.assertValidControllable();
        StreamSet streamSet = this._streamSet;
        synchronized (streamSet) {
            boolean foundUncommittedMsgs = false;
            if (indoubtAction != IndoubtAction.INDOUBT_LEAVE) {
                SIMPIterator itr = this.getTransmitMessagesIterator(-1);
                TransmitMessage xmitMsg = null;
                String state = null;
                while (itr != null && itr.hasNext()) {
                    xmitMsg = (TransmitMessage)itr.next();
                    state = xmitMsg.getState();
                    if (state.equals(SIMPTransmitMessageControllable.State.COMMITTING.toString())) {
                        foundUncommittedMsgs = true;
                        continue;
                    }
                    try {
                        SIMPMessage msg = xmitMsg.getSIMPMessage();
                        if (msg == null) continue;
                        this._ioStreamManager.removeMessage(this._streamSet, msg);
                    }
                    catch (SIResourceException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.clearMessagesAtSource", (String)"1:496:1.30", (Object)this);
                        SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"InternalOutputStreamSetControl.clearMessagesAtSource", "1:504:1.30", e}, null), (Throwable)e);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource", (Object)((Object)finalE));
                        }
                        throw finalE;
                    }
                }
            }
            if (!foundUncommittedMsgs) {
                this._ioStreamManager.forceFlush(this._streamSet.getStreamID());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
    }

    public boolean containsGuesses() {
        return false;
    }

    public void forceFlushAtSource() {
    }

    public int getCurrentMaxIndoubtMessages(int priority, int COS) {
        return 0;
    }

    public SIMPIterator getStreams() throws SIMPControllableNotFoundException {
        Iterator<Stream> it;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getStreams");
            }
            it = null;
            try {
                it = this._streamSet.iterator();
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.getStreams", (String)"1:567:1.30", (Object)this);
                SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"InternalOutputStreamSetControl.getStreams", "1:575:1.30", e}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)((Object)finalE));
            }
        }
        InternalOutputStreamControllableIterator returnIterator = new InternalOutputStreamControllableIterator(it);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)returnIterator);
        }
        return returnIterator;
    }

    public SIMPIterator getAttatchedRemoteSubscribers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttatchedRemoteSubscribers");
        }
        BasicSIMPIterator itr = null;
        try {
            ProtocolItemStream protocolItemStream = (ProtocolItemStream)this._streamSet.getItemStream();
            BaseDestinationHandler destHandler = protocolItemStream.getDestinationHandler();
            itr = new BasicSIMPIterator(destHandler.getAOControlAdapterIterator());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.getAttatchedRemoteSubscribers", (String)"1:613:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttatchedRemoteSubscribers", (Object)itr);
        }
        return itr;
    }

    public long getDepth() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        long count = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            InternalOutputStreamControl ios = (InternalOutputStreamControl)iterator.next();
            count += (long)ios.getNumberOfActiveMessages();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)count);
        }
        return count;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String remoteMEUuid = this._streamSet.getRemoteMEUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)remoteMEUuid);
        }
        return remoteMEUuid;
    }

    public void setParentControlAdapter(ControlAdapter parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setParentControlAdapter", (Object)parent);
        }
        this.parent = (RemoteTopicSpaceControl)parent;
        this._ioStreamManager = this.parent.getOutputHandler().getInternalOutputStreamManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setParentControlAdapter");
        }
    }

    public long getNumberOfMessagesSent() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesSent");
        }
        long count = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            InternalOutputStreamControl srcStreamControl = (InternalOutputStreamControl)iterator.next();
            count += srcStreamControl.getNumberOfMessagesSent();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesSent", (Object)new Long(count));
        }
        return count;
    }

    public long getNumberOfUnacknowledgedMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfUnacknowledgedMessages");
        }
        long count = 0L;
        try {
            SIMPIterator iterator = this.getTransmitMessagesIterator(-1);
            while (iterator.hasNext()) {
                TransmitMessage msg = (TransmitMessage)iterator.next();
                if (!msg.getState().equals(SIMPTransmitMessageControllable.State.PENDING_ACKNOWLEDGEMENT.toString())) continue;
                ++count;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.getNumberOfUnacknowledgedMessages", (String)"1:712:1.30", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getNumberOfUnacknowledgedMessages", "1:716:1.30", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfUnacknowledgedMessages", (Object)count);
        }
        return count;
    }

    public void moveMessages(boolean discard) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessages", (Object)discard);
        }
        this.clearMessagesAtSource(IndoubtAction.INDOUBT_DELETE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessages");
        }
    }

    public HealthState getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        SIMPIterator it = null;
        try {
            it = this.getStreams();
        }
        catch (SIMPControllableNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.getHealthState", (String)"1:756:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)((Object)e));
            }
            return null;
        }
        while (it.hasNext()) {
            SIMPDeliveryTransmitControllable control = (SIMPDeliveryTransmitControllable)it.next();
            this._healthState.addHealthStateNode(control.getHealthState());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)this._healthState);
        }
        return this._healthState;
    }

    private class InternalOutputStreamSetXmitMessageIterator
    implements SIMPIterator {
        Iterator streamSetIterator = null;
        InternalOutputStream currentStream = null;
        Iterator<SIMPTransmitMessageControllable> currentStreamMsgIterator = null;
        int index;
        int max;
        boolean allMsgs;

        public InternalOutputStreamSetXmitMessageIterator(int maxMsgs) throws SIResourceException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamSetXmitMessageIterator", (Object)maxMsgs);
            }
            this.index = 0;
            this.max = maxMsgs;
            this.allMsgs = maxMsgs == -1;
            this.streamSetIterator = InternalOutputStreamSetControl.this._streamSet.iterator();
            this.moveToNextStream();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamSetXmitMessageIterator", (Object)this);
            }
        }

        private void moveToNextStream() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"moveToNextStream");
            }
            boolean keepSearchingStreams = true;
            while (keepSearchingStreams) {
                if (this.streamSetIterator.hasNext()) {
                    this.currentStream = (InternalOutputStream)this.streamSetIterator.next();
                    this.currentStreamMsgIterator = this.currentStream.getControlAdapter().getTransmitMessagesIterator(-1);
                    if (!this.currentStreamMsgIterator.hasNext()) continue;
                    keepSearchingStreams = false;
                    continue;
                }
                keepSearchingStreams = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveToNextStream");
            }
        }

        public Object next() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            SIMPTransmitMessageControllable returnMessage = null;
            if (this.allMsgs || this.index < this.max) {
                if (!this.currentStreamMsgIterator.hasNext()) {
                    this.moveToNextStream();
                }
                returnMessage = this.currentStreamMsgIterator.next();
                ++this.index;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)returnMessage);
            }
            return returnMessage;
        }

        public boolean hasNext() {
            boolean returnValue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"hasNext");
            }
            if (this.currentStreamMsgIterator == null || !this.currentStreamMsgIterator.hasNext()) {
                this.moveToNextStream();
            }
            boolean bl = returnValue = (this.allMsgs || this.index < this.max) && this.currentStreamMsgIterator != null && this.currentStreamMsgIterator.hasNext();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(returnValue));
            }
            return returnValue;
        }

        public void remove() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"remove");
            }
            InvalidOperationException finalE = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"InternalOutputStreamSetControl.InternalOutputStreamSetXmitMessageIterator.remove", "1:218:1.30", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)finalE));
            }
            throw finalE;
        }

        public void finished() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"finished");
            }
            this.streamSetIterator = null;
            this.currentStream = null;
            this.currentStreamMsgIterator = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"finished");
            }
        }
    }
}

