/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigSerializer {
    static final long serialVersionUID = 4799512866657811567L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Properties serializeConfig(OpenApiConfig config, OpenAPI model) {
        Properties result = new Properties();
        for (ConfigField field : ConfigField.values()) {
            String value = field.function.apply(config);
            if (value == null) continue;
            result.put(field.name, value);
        }
        for (String pathName : ConfigSerializer.getPathNames(model)) {
            Set value = config.pathServers(pathName);
            if (value == null || value.isEmpty()) continue;
            result.put("pathServer." + pathName, ConfigSerializer.serializeSet(value));
        }
        for (String operationId : ConfigSerializer.getOperationIds(model)) {
            Set value = config.operationServers(operationId);
            if (value == null || value.isEmpty()) continue;
            result.put("operationServer." + operationId, ConfigSerializer.serializeSet(value));
        }
        return result;
    }

    private static String serializeSet(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return String.join((CharSequence)",", list);
    }

    private static String serializeMap(Map<String, String> map) {
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(entryList, Map.Entry.comparingByKey());
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
        }
        return sb.toString();
    }

    private static Set<String> getPathNames(OpenAPI model) {
        return ConfigSerializer.getPathItems(model).keySet();
    }

    private static Set<String> getOperationIds(OpenAPI model) {
        return ConfigSerializer.getPathItems(model).values().stream().flatMap(i -> i.getOperations().values().stream()).filter(o -> o.getOperationId() != null).map(o -> o.getOperationId()).collect(Collectors.toSet());
    }

    private static Map<String, PathItem> getPathItems(OpenAPI model) {
        Paths paths = model.getPaths();
        if (paths == null) {
            return Collections.emptyMap();
        }
        Map pathItems = paths.getPathItems();
        if (pathItems == null) {
            return Collections.emptyMap();
        }
        return pathItems;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.cache.ConfigSerializer", ConfigSerializer.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }

    static enum ConfigField {
        MODEL_READER("modelReader", OpenApiConfig::modelReader),
        FILTER("filter", OpenApiConfig::filter),
        SCAN_DISABLE("scanDisable", c -> Boolean.toString(c.scanDisable())),
        SCAN_PACKAGES("scanPackages", OpenApiConfig::scanPackages, Pattern::pattern),
        SCAN_CLASSES("scanClasses", OpenApiConfig::scanClasses, Pattern::pattern),
        SCAN_EXCLUDE_PACKAGES("scanExcludePackages", OpenApiConfig::scanExcludePackages, Pattern::pattern),
        SCAN_EXCLUDE_CLASSES("scanExcludeClasses", OpenApiConfig::scanExcludeClasses, Pattern::pattern),
        SERVERS("servers", c -> ConfigSerializer.access$100(c.servers())),
        SCAN_DEPENDENCIES_DISABLE("scanDependenciesDisable", c -> Boolean.toString(c.scanDependenciesDisable())),
        SCAN_DEPENDENCIES_JARS("scanDependenciesJars", c -> ConfigSerializer.access$100(c.scanDependenciesJars())),
        CUSTOM_SCHEMA_REGISTRY_CLASS("customSchemaRegistryClass", OpenApiConfig::customSchemaRegistryClass),
        APPLICATION_PATH_DISABLE("applicationPathDisable", c -> Boolean.toString(c.applicationPathDisable())),
        SCHEMAS("getSchemas", c -> ConfigSerializer.access$000(c.getSchemas())),
        OPEN_API_VERSION("getOpenApiVersion", OpenApiConfig::getOpenApiVersion),
        INFO_TITLE("getInfoTitle", OpenApiConfig::getInfoTitle),
        INFO_VERSION("getInfoVersion", OpenApiConfig::getInfoVersion),
        INFO_DESCRIPTION("getInfoDescription", OpenApiConfig::getInfoDescription),
        INFO_TERMS_OF_SERVICE("getInfoTermsOfService", OpenApiConfig::getInfoTermsOfService),
        INFO_CONTACT_EMAIL("getInfoContactEmail", OpenApiConfig::getInfoContactEmail),
        INFO_CONTACT_NAME("getInfoContactName", OpenApiConfig::getInfoContactName),
        INFO_CONTACT_URL("getInfoContactUrl", OpenApiConfig::getInfoContactUrl),
        INFO_LICENSE_NAME("getInfoLicenseName", OpenApiConfig::getInfoLicenseName),
        INFO_LICENSE_URL("getInfoLicenseUrl", OpenApiConfig::getInfoLicenseName),
        OPERATION_ID_STRATEGY("getOperationIdStrategy", OpenApiConfig::getOperationIdStrategy, Enum::name),
        ARRAY_REFERENCES_ENABLE("arrayReferencesEnable", c -> Boolean.toString(c.arrayReferencesEnable())),
        DEFAULT_PRODUCES("getDefaultProduces", OpenApiConfig::getDefaultProduces, Optional::toString),
        DEFAULT_CONSUMES("getDefaultConsumes", OpenApiConfig::getDefaultConsumes, Optional::toString);

        Function<OpenApiConfig, String> function;
        String name;

        private ConfigField(String name, Function<OpenApiConfig, String> function) {
            this.name = name;
            this.function = function;
        }

        private <V> ConfigField(String name, Function<OpenApiConfig, V> valueGetter, Function<V, String> stringConverter) {
            this.name = name;
            this.function = c -> {
                Object value = valueGetter.apply((OpenApiConfig)c);
                return value == null ? null : (String)stringConverter.apply(value);
            };
        }
    }
}

