/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleUtils {
    private static final TraceComponent tc = Tr.register(ModuleUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -2857557967098505614L;

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static WebModuleInfo getWebModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        WebModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException e) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Failed to get web module info: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        if (overlayCache != null) {
            moduleInfo = (WebModuleInfo)overlayCache.getFromCache(WebModuleInfo.class);
        }
        return moduleInfo;
    }
}

