/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.ICatalog;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.ws.ui.internal.v1.ITool;
import com.ibm.ws.ui.internal.v1.IToolboxService;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.pojo.DuplicateException;
import com.ibm.ws.ui.internal.v1.pojo.FeatureTool;
import com.ibm.ws.ui.internal.validation.InvalidCatalogException;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Catalog
implements ICatalog {
    private static final transient TraceComponent tc = Tr.register(Catalog.class);
    public static final transient String PERSIST_NAME = "catalog";
    private transient IPersistenceProvider persist;
    private transient IToolboxService toolboxes;
    private transient IFeatureToolService featureToolService;
    private Map<String, Object> _metadata = null;
    private Map<String, FeatureTool> featureTools = null;
    private Map<String, Bookmark> bookmarks = null;

    private void initializeDefaults() {
        this.featureTools = new HashMap<String, FeatureTool>();
        this.bookmarks = new HashMap<String, Bookmark>();
        Bookmark openlibertyio = new Bookmark("openliberty.io", "https://openliberty.io", "images/tools/Open_Liberty_square_142x142.png", "Open Liberty website.");
        this.bookmarks.put(openlibertyio.getId(), openlibertyio);
        this._metadata = new HashMap<String, Object>();
        this._metadata.put("lastModified", new Date().getTime());
        this._metadata.put("isDefault", true);
    }

    Catalog() {
    }

    public Catalog(IPersistenceProvider persist, IToolboxService toolboxService, IFeatureToolService featureToolService) {
        this.setIPersistenceProvider(persist);
        this.setIToolboxService(toolboxService);
        this.setIFeatureToolService(featureToolService);
        this.initializeDefaults();
    }

    @Trivial
    public synchronized void setIPersistenceProvider(IPersistenceProvider persist) {
        this.persist = persist;
    }

    @Trivial
    public synchronized void setIToolboxService(IToolboxService toolboxes) {
        this.toolboxes = toolboxes;
    }

    @Trivial
    public synchronized void setIFeatureToolService(IFeatureToolService featureToolService) {
        this.featureToolService = featureToolService;
    }

    private synchronized void set_metadata(Map<String, Object> _metadata) {
        this._metadata = _metadata;
    }

    @Override
    public synchronized Map<String, Object> get_metadata() {
        if (this._metadata == null) {
            return null;
        }
        HashMap<String, Object> returnedMap = new HashMap<String, Object>();
        this.getFeatureTools();
        returnedMap.putAll(this._metadata);
        return Collections.unmodifiableMap(returnedMap);
    }

    private synchronized void setFeatureTools(List<FeatureTool> featureTools) {
        HashMap<String, FeatureTool> newFeatureTools = null;
        if (featureTools != null) {
            newFeatureTools = new HashMap<String, FeatureTool>();
            for (FeatureTool tool : featureTools) {
                newFeatureTools.put(tool.getId(), tool);
            }
        }
        this.featureTools = newFeatureTools;
    }

    private void validateToolsAgainstFeatures(boolean changeDefault) {
        if (this.featureToolService == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Catalog featureToolService has not been set. Returning without processing feature tools...", (Object[])new Object[0]);
            }
            return;
        }
        Set<FeatureTool> featureSet = this.featureToolService.getTools();
        boolean metaDataChanged = false;
        HashSet<String> toolsToDelete = new HashSet<String>();
        for (Map.Entry<String, FeatureTool> entry : this.featureTools.entrySet()) {
            String key = entry.getKey();
            FeatureTool tool = entry.getValue();
            if (featureSet.contains(tool)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The previously stored FeatureTool " + tool + " is no longer valid. Adding to list of tools to delete."), (Object[])new Object[0]);
            }
            toolsToDelete.add(key);
        }
        for (String toolToDelete : toolsToDelete) {
            this.featureTools.remove(toolToDelete);
            metaDataChanged = true;
        }
        for (FeatureTool featureTool : featureSet) {
            if (this.featureTools.get(featureTool.getId()) != null) continue;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Adding FeatureTool to list of catalog tools: " + featureTool), (Object[])new Object[0]);
            }
            this.featureTools.put(featureTool.getId(), featureTool);
            metaDataChanged = true;
        }
        if (metaDataChanged) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Refreshing catalog metadata and persisting", (Object[])new Object[0]);
            }
            this.updateMetadataOnChange(changeDefault);
            if (changeDefault) {
                this.storeCatalog();
            }
        }
    }

    @Override
    public synchronized List<FeatureTool> getFeatureTools() {
        if (this.featureTools == null) {
            return null;
        }
        this.validateToolsAgainstFeatures(true);
        if (this.featureToolService != null) {
            return Collections.unmodifiableList(this.featureToolService.getToolsForRequestLocale());
        }
        ArrayList<FeatureTool> ret = new ArrayList<FeatureTool>();
        ret.addAll(this.featureTools.values());
        return Collections.unmodifiableList(ret);
    }

    void initialProcessFeatures() {
        this.validateToolsAgainstFeatures(false);
    }

    private synchronized void setBookmarks(List<Bookmark> bookmarks) {
        HashMap<String, Bookmark> newBookmarks = null;
        if (bookmarks != null) {
            newBookmarks = new HashMap<String, Bookmark>();
            for (Bookmark tool : bookmarks) {
                newBookmarks.put(tool.getId(), tool);
            }
        }
        this.bookmarks = newBookmarks;
    }

    @Override
    public synchronized List<Bookmark> getBookmarks() {
        if (this.bookmarks == null) {
            return null;
        }
        ArrayList<Bookmark> ret = new ArrayList<Bookmark>();
        ret.addAll(this.bookmarks.values());
        return Collections.unmodifiableList(ret);
    }

    @Override
    public synchronized ITool getTool(String id) {
        FeatureTool t = this.getFeatureTool(id);
        if (t != null) {
            return t;
        }
        return this.bookmarks.get(id);
    }

    @Override
    public synchronized FeatureTool getFeatureTool(String id) {
        if (this.featureToolService != null) {
            return this.featureToolService.getToolForRequestLocale(id);
        }
        return this.featureTools.get(id);
    }

    @Override
    public synchronized Bookmark getBookmark(String id) {
        return this.bookmarks.get(id);
    }

    synchronized void storeCatalog() {
        try {
            this.persist.store(PERSIST_NAME, this);
        }
        catch (JSONMarshallException e) {
            Tr.error((TraceComponent)tc, (String)"STORE_CATALOG_TO_MARSHALL_ERROR", (Object[])new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"STORE_CATALOG_TO_PERSISTENCE_ERROR", (Object[])new Object[]{e.getMessage()});
        }
    }

    private synchronized void updateMetadataOnChange(boolean changeDefault) {
        this._metadata.put("lastModified", new Date().getTime());
        if (changeDefault) {
            this._metadata.put("isDefault", false);
        }
    }

    @Override
    @FFDCIgnore(value={InvalidToolException.class})
    public synchronized Bookmark addBookmark(Bookmark tool) throws DuplicateException, InvalidToolException {
        Bookmark toAdd = tool;
        if (toAdd.getId() == null && toAdd.getType() == null) {
            toAdd = new Bookmark(tool.getName(), tool.getURL(), tool.getIcon(), tool.getDescription());
        }
        try {
            toAdd.validateSelf();
        }
        catch (InvalidToolException e) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "TOOL_OBJECT_NOT_VALID", e.getMessage()));
        }
        if (this.bookmarks.get(toAdd.getId()) != null) {
            throw new DuplicateException(RequestNLS.formatMessage(tc, "TOOL_ALREADY_EXIST", toAdd.getId()));
        }
        this.bookmarks.put(toAdd.getId(), toAdd);
        this.updateMetadataOnChange(true);
        this.storeCatalog();
        return toAdd;
    }

    @Override
    public synchronized Bookmark deleteBookmark(String id) {
        Bookmark deletedTool = this.bookmarks.remove(id);
        if (deletedTool != null) {
            this.updateMetadataOnChange(true);
            this.storeCatalog();
            this.toolboxes.removeToolEntryFromAllToolboxes(id);
        }
        return deletedTool;
    }

    @Override
    public synchronized void reset() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Catalog reset request received. Removing all known catalog entries from all toolboxes.", (Object[])new Object[0]);
        }
        for (ITool iTool : this.featureTools.values()) {
            this.toolboxes.removeToolEntryFromAllToolboxes(iTool.getId());
        }
        for (ITool iTool : this.bookmarks.values()) {
            this.toolboxes.removeToolEntryFromAllToolboxes(iTool.getId());
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Catalog reset request received. Resetting catalog to initial state.", (Object[])new Object[0]);
        }
        this.initializeDefaults();
        this.initialProcessFeatures();
        this.storeCatalog();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Catalog reset complete.", (Object[])new Object[0]);
        }
    }

    @Override
    @FFDCIgnore(value={InvalidToolException.class})
    public synchronized void validateSelf() throws InvalidCatalogException {
        if (this.featureTools == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Catalog is not considered valid because it is missing its required 'featureTools' field.", (Object[])new Object[0]);
            }
            throw new InvalidCatalogException("The Catalog is not valid, the 'featureTools' field is null");
        }
        if (this.bookmarks == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Catalog is not considered valid because it is missing its required 'bookmarks' field.", (Object[])new Object[0]);
            }
            throw new InvalidCatalogException("The Catalog is not valid, the 'bookmarks' field is null");
        }
        if (this._metadata == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Catalog is not considered valid because it is missing its required '_metadata' field.", (Object[])new Object[0]);
            }
            throw new InvalidCatalogException("The Catalog is not valid, the '_metadata' field is null");
        }
        if (!this._metadata.containsKey("lastModified")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Catalog is not considered valid because it is missing its required metadata 'lastModified'.", (Object[])new Object[]{this._metadata});
            }
            throw new InvalidCatalogException("The Catalog is not valid, the metadata 'lastModified' is not defined");
        }
        if (!this._metadata.containsKey("isDefault")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Catalog is not considered valid because it is missing its required metadata 'isDefault'.", (Object[])new Object[]{this._metadata});
            }
            throw new InvalidCatalogException("The Catalog is not valid, the metadata 'isDefault' is not defined");
        }
        ArrayList<String> keyRemovals = new ArrayList<String>();
        for (Map.Entry<String, FeatureTool> entry : this.featureTools.entrySet()) {
            try {
                entry.getValue().validateSelf();
            }
            catch (InvalidToolException invalidToolException) {
                Tr.warning((TraceComponent)tc, (String)"INVALID_TOOL_CONTENT_WARNING", (Object[])new Object[]{entry.getValue().getId(), invalidToolException.getMessage()});
                keyRemovals.add(entry.getKey());
            }
        }
        for (String string : keyRemovals) {
            this.featureTools.remove(string);
        }
        keyRemovals.clear();
        for (Map.Entry<String, Bookmark> entry : this.bookmarks.entrySet()) {
            try {
                entry.getValue().validateSelf();
            }
            catch (InvalidToolException invalidToolException) {
                Tr.warning((TraceComponent)tc, (String)"INVALID_TOOL_CONTENT_WARNING", (Object[])new Object[]{entry.getValue().getId(), invalidToolException.getMessage()});
                keyRemovals.add(entry.getKey());
            }
        }
        for (String string : keyRemovals) {
            this.bookmarks.remove(string);
        }
        this.updateMetadataOnChange(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Catalog) {
            Catalog that = (Catalog)o;
            Catalog catalog = this;
            synchronized (catalog) {
                Catalog catalog2 = that;
                synchronized (catalog2) {
                    boolean sameFields = true;
                    sameFields &= this.featureTools == that.featureTools || this.featureTools != null && this.featureTools.equals(that.featureTools);
                    boolean bl = this.bookmarks == that.bookmarks || this.bookmarks != null && this.bookmarks.equals(that.bookmarks);
                    return sameFields &= bl;
                }
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.featureTools == null ? 0 : this.featureTools.hashCode();
    }
}

