/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.ws.ui.internal.v1.ICatalog;
import com.ibm.ws.ui.internal.v1.ICatalogService;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.ws.ui.internal.v1.IToolbox;
import com.ibm.ws.ui.internal.v1.IToolboxService;
import com.ibm.ws.ui.internal.v1.pojo.Catalog;
import com.ibm.ws.ui.internal.v1.pojo.Toolbox;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import com.ibm.ws.ui.persistence.InvalidPOJOException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ICatalogService.class, IToolboxService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class POJOLoaderService
implements ICatalogService,
IToolboxService {
    private static final TraceComponent tc = Tr.register(POJOLoaderService.class);
    private WSSecurityService securityService;
    private IFeatureToolService featureToolService;
    private IPersistenceProvider persistenceProviderFile;
    private IPersistenceProvider persistenceProviderCollective;
    private ICatalog catalog;
    private Map<String, IToolbox> toolboxes = new HashMap<String, IToolbox>();

    @Reference(service=WSSecurityService.class)
    protected synchronized void setWSSecurityService(WSSecurityService securityService) {
        this.securityService = securityService;
    }

    protected synchronized void unsetWSSecurityService(WSSecurityService securityService) {
        if (this.securityService == securityService) {
            this.securityService = null;
        }
    }

    private void clearCachedInstances() {
        this.catalog = null;
        if (this.toolboxes != null) {
            this.toolboxes.clear();
        }
    }

    @Reference(service=IFeatureToolService.class)
    protected synchronized void setIFeatureToolService(IFeatureToolService featureToolService) {
        this.featureToolService = featureToolService;
    }

    protected synchronized void unsetIFeatureToolService(IFeatureToolService featureToolService) {
        if (this.featureToolService == featureToolService) {
            this.featureToolService = null;
        }
    }

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY, target="(com.ibm.ws.ui.persistence.provider=FILE)")
    protected synchronized void setIPersistenceProviderFILE(IPersistenceProvider provider) {
        this.persistenceProviderFile = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED", (Object[])new Object[]{"FILE"});
        this.clearCachedInstances();
    }

    protected synchronized void unsetIPersistenceProviderFILE(IPersistenceProvider provider) {
        if (this.persistenceProviderFile == provider) {
            this.persistenceProviderFile = null;
        }
    }

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(com.ibm.ws.ui.persistence.provider=COLLECTIVE)")
    protected synchronized void setIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        this.persistenceProviderCollective = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED", (Object[])new Object[]{"COLLECTIVE"});
        this.clearCachedInstances();
    }

    protected synchronized void unsetIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        if (this.persistenceProviderCollective == provider) {
            this.persistenceProviderCollective = null;
        }
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED", (Object[])new Object[]{"FILE"});
        this.clearCachedInstances();
    }

    @Activate
    protected synchronized void activate() {
        this.clearCachedInstances();
    }

    @Deactivate
    protected synchronized void deactive() {
        this.clearCachedInstances();
        this.toolboxes = null;
    }

    private IPersistenceProvider getPersist() {
        if (this.persistenceProviderCollective != null) {
            return this.persistenceProviderCollective;
        }
        return this.persistenceProviderFile;
    }

    @FFDCIgnore(value={FileNotFoundException.class})
    private Catalog loadCatalogFromPersistence(IPersistenceProvider persist) {
        try {
            Catalog catalog = persist.load("catalog", Catalog.class);
            catalog.setIPersistenceProvider(this.getPersist());
            catalog.setIToolboxService(this);
            catalog.setIFeatureToolService(this.featureToolService);
            catalog.initialProcessFeatures();
            catalog.validateSelf();
            Tr.info((TraceComponent)tc, (String)"LOADED_PERSISTED_CATALOG", (Object[])new Object[0]);
            return catalog;
        }
        catch (FileNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The persisted instance is not available. This is an expected code path and is likely fine.\nIf the file should have been there, we'll see isDefault=true (rather than isDefault=false).\nThat is the indicator to the client something may be wrong.", (Object[])new Object[0]);
            }
        }
        catch (JSONMarshallException e) {
            String msg = e.getMessage();
            if (msg != null && msg.equals("Fatal problems occurred while mapping content")) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_CATALOG_CONTENT", (Object[])new Object[0]);
            } else if (msg != null && msg.equals("Unable to parse non-well-formed content")) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_CATALOG_SYNTAX", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_CATALOG_ACCESS", (Object[])new Object[0]);
        }
        catch (InvalidPOJOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught an InvalidPOJOException while trying to load the catalog from persisted storage", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"LOADED_CATALOG_NOT_VALID", (Object[])new Object[0]);
        }
        return null;
    }

    private Catalog loadCatalogFromFile() {
        return this.loadCatalogFromPersistence(this.persistenceProviderFile);
    }

    private Catalog createDefaultCatalog() {
        Tr.info((TraceComponent)tc, (String)"LOADED_DEFAULT_CATALOG", (Object[])new Object[0]);
        Catalog catalog = new Catalog(this.getPersist(), this, this.featureToolService);
        catalog.initialProcessFeatures();
        return catalog;
    }

    private Catalog loadCatalogFromCollective() {
        Catalog catalog = this.loadCatalogFromPersistence(this.persistenceProviderCollective);
        if (catalog == null) {
            catalog = this.loadCatalogFromFile();
            if (catalog != null) {
                Tr.info((TraceComponent)tc, (String)"CATALOG_FILE_PROMOTED_TO_COLLECTIVE", (Object[])new Object[]{"FILE", "COLLECTIVE"});
            } else {
                catalog = this.createDefaultCatalog();
            }
            catalog.storeCatalog();
        }
        return catalog;
    }

    private ICatalog loadCatalog() {
        if (this.persistenceProviderCollective != null) {
            return this.loadCatalogFromCollective();
        }
        Catalog catalog = this.loadCatalogFromFile();
        if (catalog == null) {
            catalog = this.createDefaultCatalog();
        }
        return catalog;
    }

    @Override
    public synchronized ICatalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = this.loadCatalog();
        }
        return this.catalog;
    }

    private String getUserDisplayName(String userId) {
        try {
            return this.securityService.getUserRegistry(null).getUserDisplayName(userId);
        }
        catch (EntryNotFoundException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_DISPLAY_NAME_FOR_USER", (Object[])new Object[]{userId});
        }
        catch (CustomRegistryException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_DISPLAY_NAME_FOR_USER", (Object[])new Object[]{userId});
        }
        catch (RemoteException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_DISPLAY_NAME_FOR_USER", (Object[])new Object[]{userId});
        }
        catch (WSSecurityException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_DISPLAY_NAME_FOR_USER", (Object[])new Object[]{userId});
        }
        return userId;
    }

    @FFDCIgnore(value={FileNotFoundException.class})
    private Toolbox loadToolboxFromPersistence(IPersistenceProvider persist, String userId) {
        try {
            String persistedName = "toolbox-" + userId;
            Toolbox toolbox = persist.load(persistedName, Toolbox.class);
            toolbox.setCatalog(this.getCatalog());
            toolbox.setPersistenceProvider(this.getPersist());
            toolbox.validateSelf();
            Tr.info((TraceComponent)tc, (String)"LOADED_PERSISTED_TOOLBOX", (Object[])new Object[]{userId});
            return toolbox;
        }
        catch (FileNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The persisted instance is not available. This is an expected code path and is likely fine.\nIf the file should have been there, we'll see isDefault=true (rather than isDefault=false).\nThat is the indicator to the client something may be wrong.", (Object[])new Object[0]);
            }
        }
        catch (JSONMarshallException e) {
            String msg = e.getMessage();
            if (msg != null && msg.equals("Fatal problems occurred while mapping content")) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_TOOLBOX_CONTENT", (Object[])new Object[]{userId});
            } else if (msg != null && msg.equals("Unable to parse non-well-formed content")) {
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_TOOLBOX_SYNTAX", (Object[])new Object[]{userId});
            }
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_TOOLBOX_ACCESS", (Object[])new Object[]{userId});
        }
        catch (InvalidPOJOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught an InvalidPOJOException while trying to load the catalog from persisted storage", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"LOADED_TOOLBOX_NOT_VALID", (Object[])new Object[]{userId});
        }
        return null;
    }

    private Toolbox loadToolboxFromFile(String userId) {
        return this.loadToolboxFromPersistence(this.persistenceProviderFile, userId);
    }

    private Toolbox createDefaultToolbox(String userId) {
        Tr.info((TraceComponent)tc, (String)"LOADED_DEFAULT_TOOLBOX", (Object[])new Object[]{userId});
        return new Toolbox(this.getCatalog(), this.getPersist(), userId, this.getUserDisplayName(userId));
    }

    private Toolbox loadToolboxFromCollective(String userId) {
        Toolbox toolbox = this.loadToolboxFromPersistence(this.persistenceProviderCollective, userId);
        if (toolbox == null) {
            toolbox = this.loadToolboxFromFile(userId);
            if (toolbox != null) {
                Tr.info((TraceComponent)tc, (String)"TOOLBOX_FILE_PROMOTED_TO_COLLECTIVE", (Object[])new Object[]{userId, "FILE", "COLLECTIVE"});
            } else {
                toolbox = this.createDefaultToolbox(userId);
            }
            toolbox.storeToolbox();
        }
        return toolbox;
    }

    private IToolbox loadToolbox(String userId) {
        if (this.persistenceProviderCollective != null) {
            return this.loadToolboxFromCollective(userId);
        }
        Toolbox toolbox = this.loadToolboxFromFile(userId);
        if (toolbox == null) {
            toolbox = this.createDefaultToolbox(userId);
        }
        return toolbox;
    }

    @Override
    public synchronized IToolbox getToolbox(String userId) {
        IToolbox toolbox = this.toolboxes.get(userId);
        if (toolbox == null) {
            toolbox = this.loadToolbox(userId);
            this.setToolbox(userId, toolbox);
        }
        return toolbox;
    }

    public synchronized void setToolbox(String userId, IToolbox activatedInstance) {
        if (activatedInstance == null) {
            this.toolboxes.remove(userId);
        } else {
            this.toolboxes.put(userId, activatedInstance);
        }
    }

    @Override
    public synchronized void resetAllToolboxes() {
        for (IToolbox tb : this.toolboxes.values()) {
            tb.reset();
        }
    }

    @Override
    public synchronized void removeToolEntryFromAllToolboxes(String id) {
        for (IToolbox tb : this.toolboxes.values()) {
            tb.deleteToolEntry(id);
        }
    }
}

