/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ui.internal.v1.utils.SortedBundle;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;

public class ManifestUtils {
    private static final TraceComponent tc = Tr.register(ManifestUtils.class);
    public static final String SUBSYSTEM_SYMBOLIC_NAME = "Subsystem-SymbolicName";
    public static final String SUBSYSTEM_NAME = "Subsystem-Name";
    public static final String SUBSYSTEM_CATEGORY = "Subsystem-Category";
    public static final String SUBSYSTEM_VERSION = "Subsystem-Version";
    public static final String SUBSYSTEM_ICON = "Subsystem-Icon";
    public static final String SUBSYSTEM_DESCRIPTION = "Subsystem-Description";
    public static final String SUBSYSTEM_CONTENT = "Subsystem-Content";
    public static final String SUBSYSTEM_ENDPOINT_CONTENT = "Subsystem-Endpoint-Content";
    public static final String SUBSYSTEM_ENDPOINT_ICONS = "Subsystem-Endpoint-Icons";
    public static final String SUBSYSTEM_ENDPOINT_NAMES = "Subsystem-Endpoint-Names";
    public static final String SUBSYSTEM_ENDPOINT_SHORTNAMES = "Subsystem-Endpoint-ShortNames";
    public static final String SUBSYSTEM_ENDPOINT_URLS = "Subsystem-Endpoint-Urls";
    public static final String IBM_SHORT_NAME = "IBM-ShortName";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String BUNDLE_VERSION_NAME = "Bundle-Version";
    public static final String WEBCONTEXT_PATH_NAME = "Web-ContextPath";

    public static File[] findAllFeatureManifests(final File featureDir) {
        Object[] manifestFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                File[] manifestFiles = featureDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        boolean result = false;
                        if (pathname.getName().toLowerCase().endsWith(".mf")) {
                            result = true;
                        }
                        return result;
                    }
                });
                return manifestFiles;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found Manifests: " + Arrays.toString(manifestFiles)), (Object[])new Object[0]);
        }
        return manifestFiles;
    }

    public static Map<String, Map<String, String>> findToolFeatureManifests(File[] manifestFiles) {
        HashMap<String, Map<String, String>> featureManifests = new HashMap<String, Map<String, String>>();
        if (manifestFiles != null) {
            for (final File manifestFile : manifestFiles) {
                Manifest featureManifest;
                block10: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Reading Manifest file: " + manifestFile), (Object[])new Object[0]);
                    }
                    featureManifest = null;
                    try {
                        featureManifest = AccessController.doPrivileged(new PrivilegedExceptionAction<Manifest>(){

                            @Override
                            public Manifest run() throws FileNotFoundException, IOException {
                                return ManifestProcessor.parseManifest((InputStream)new FileInputStream(manifestFile));
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                        Tr.debug((TraceComponent)tc, (String)("An exception occurred while reading the feature manifest " + manifestFile.getAbsolutePath()), (Object[])new Object[]{e.toString()});
                    }
                }
                if (featureManifest != null) {
                    Map headers = ManifestProcessor.readManifestIntoMap((Manifest)featureManifest);
                    String symbolicCategory = (String)headers.get(SUBSYSTEM_CATEGORY);
                    if (symbolicCategory == null) continue;
                    for (String category : symbolicCategory.split(",")) {
                        if ("admincenter".equals(category.toLowerCase())) {
                            featureManifests.put(manifestFile.getAbsolutePath(), headers);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Adding Manifest file " + manifestFile.getAbsolutePath() + " to list of tools."), (Object[])new Object[0]);
                            continue;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Manifest file " + manifestFile.getAbsolutePath() + " is not a tool manifest"), (Object[])new Object[0]);
                    }
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Unable to read Manifest file: " + manifestFile.getAbsolutePath()), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Manifest files to process is null.", (Object[])new Object[0]);
        }
        return featureManifests;
    }

    public static String getInstalledFeatureName(String symbolicNameHeader, String shortName, String featurePrefix) {
        String installedFeatureName = null;
        ManifestHeaderProcessor.NameValuePair nvpSymbolicName = ManifestHeaderProcessor.parseBundleSymbolicName((String)symbolicNameHeader);
        String symbolicName = nvpSymbolicName.getName();
        Map symbolicNameAttrs = nvpSymbolicName.getAttributes();
        String visibility = (String)symbolicNameAttrs.get("visibility:");
        if (visibility == null) {
            visibility = "private";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Visibility for " + symbolicName + " is " + visibility), (Object[])new Object[0]);
        }
        if (featurePrefix == null) {
            featurePrefix = "";
        }
        installedFeatureName = "public".equals(visibility.toLowerCase()) ? (shortName != null ? featurePrefix + shortName : featurePrefix + symbolicName) : featurePrefix + symbolicName;
        return installedFeatureName;
    }

    public static SortedBundle processBundleManifest(final File bundle) {
        SortedBundle sortedBundle = null;
        if (bundle != null) {
            Map<String, String> manifestAttrs = null;
            try {
                manifestAttrs = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Map<String, String> run() throws ZipException, IOException {
                        ZipFile zipFile = null;
                        InputStream zis = null;
                        Map attrs = null;
                        try {
                            zipFile = new ZipFile(bundle);
                            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                            zis = zipFile.getInputStream(zipEntry);
                            attrs = ManifestProcessor.readManifestIntoMap((Manifest)ManifestProcessor.parseManifest((InputStream)zis));
                        }
                        finally {
                            if (zis != null) {
                                zis.close();
                            }
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        return attrs;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (manifestAttrs != null) {
                String symbolicName = manifestAttrs.get(BUNDLE_SYMBOLIC_NAME);
                String versionString = manifestAttrs.get(BUNDLE_VERSION_NAME);
                if (symbolicName != null && versionString != null) {
                    symbolicName = ManifestHeaderProcessor.parseBundleSymbolicName((String)symbolicName).getName();
                    Version version = new Version(versionString);
                    String webContextPath = manifestAttrs.get(WEBCONTEXT_PATH_NAME);
                    String uiEndpointFeatureName = manifestAttrs.get("IBM-AdminCenter-PrimaryEndpoint");
                    sortedBundle = new SortedBundle(symbolicName, version, webContextPath, uiEndpointFeatureName);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Creating Sorted Bundle: " + sortedBundle), (Object[])new Object[0]);
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Problem reading Manifest Attrs for " + bundle.getAbsolutePath()), (Object[])new Object[0]);
            }
        }
        return sortedBundle;
    }
}

